/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountLimitsResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeAccountLimitsResponse> {
    private final Integer maxNumberOfAutoScalingGroups;
    private final Integer maxNumberOfLaunchConfigurations;
    private final Integer numberOfAutoScalingGroups;
    private final Integer numberOfLaunchConfigurations;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.maxNumberOfAutoScalingGroups = builder.maxNumberOfAutoScalingGroups;
        this.maxNumberOfLaunchConfigurations = builder.maxNumberOfLaunchConfigurations;
        this.numberOfAutoScalingGroups = builder.numberOfAutoScalingGroups;
        this.numberOfLaunchConfigurations = builder.numberOfLaunchConfigurations;
    }

    public Integer maxNumberOfAutoScalingGroups() {
        return this.maxNumberOfAutoScalingGroups;
    }

    public Integer maxNumberOfLaunchConfigurations() {
        return this.maxNumberOfLaunchConfigurations;
    }

    public Integer numberOfAutoScalingGroups() {
        return this.numberOfAutoScalingGroups;
    }

    public Integer numberOfLaunchConfigurations() {
        return this.numberOfLaunchConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfAutoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfLaunchConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAutoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfLaunchConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse)((Object)obj);
        return Objects.equals(this.maxNumberOfAutoScalingGroups(), other.maxNumberOfAutoScalingGroups()) && Objects.equals(this.maxNumberOfLaunchConfigurations(), other.maxNumberOfLaunchConfigurations()) && Objects.equals(this.numberOfAutoScalingGroups(), other.numberOfAutoScalingGroups()) && Objects.equals(this.numberOfLaunchConfigurations(), other.numberOfLaunchConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.maxNumberOfAutoScalingGroups() != null) {
            sb.append("MaxNumberOfAutoScalingGroups: ").append(this.maxNumberOfAutoScalingGroups()).append(",");
        }
        if (this.maxNumberOfLaunchConfigurations() != null) {
            sb.append("MaxNumberOfLaunchConfigurations: ").append(this.maxNumberOfLaunchConfigurations()).append(",");
        }
        if (this.numberOfAutoScalingGroups() != null) {
            sb.append("NumberOfAutoScalingGroups: ").append(this.numberOfAutoScalingGroups()).append(",");
        }
        if (this.numberOfLaunchConfigurations() != null) {
            sb.append("NumberOfLaunchConfigurations: ").append(this.numberOfLaunchConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxNumberOfAutoScalingGroups": {
                return Optional.of(clazz.cast(this.maxNumberOfAutoScalingGroups()));
            }
            case "MaxNumberOfLaunchConfigurations": {
                return Optional.of(clazz.cast(this.maxNumberOfLaunchConfigurations()));
            }
            case "NumberOfAutoScalingGroups": {
                return Optional.of(clazz.cast(this.numberOfAutoScalingGroups()));
            }
            case "NumberOfLaunchConfigurations": {
                return Optional.of(clazz.cast(this.numberOfLaunchConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private Integer maxNumberOfAutoScalingGroups;
        private Integer maxNumberOfLaunchConfigurations;
        private Integer numberOfAutoScalingGroups;
        private Integer numberOfLaunchConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            this.maxNumberOfAutoScalingGroups(model.maxNumberOfAutoScalingGroups);
            this.maxNumberOfLaunchConfigurations(model.maxNumberOfLaunchConfigurations);
            this.numberOfAutoScalingGroups(model.numberOfAutoScalingGroups);
            this.numberOfLaunchConfigurations(model.numberOfLaunchConfigurations);
        }

        public final Integer getMaxNumberOfAutoScalingGroups() {
            return this.maxNumberOfAutoScalingGroups;
        }

        @Override
        public final Builder maxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
            return this;
        }

        public final void setMaxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
        }

        public final Integer getMaxNumberOfLaunchConfigurations() {
            return this.maxNumberOfLaunchConfigurations;
        }

        @Override
        public final Builder maxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
            return this;
        }

        public final void setMaxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
        }

        public final Integer getNumberOfAutoScalingGroups() {
            return this.numberOfAutoScalingGroups;
        }

        @Override
        public final Builder numberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
            return this;
        }

        public final void setNumberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
        }

        public final Integer getNumberOfLaunchConfigurations() {
            return this.numberOfLaunchConfigurations;
        }

        @Override
        public final Builder numberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
            return this;
        }

        public final void setNumberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        public Builder maxNumberOfAutoScalingGroups(Integer var1);

        public Builder maxNumberOfLaunchConfigurations(Integer var1);

        public Builder numberOfAutoScalingGroups(Integer var1);

        public Builder numberOfLaunchConfigurations(Integer var1);
    }
}

