/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.PolicyNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.PolicyTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePoliciesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribePoliciesRequest> {
    private final String autoScalingGroupName;
    private final List<String> policyNames;
    private final List<String> policyTypes;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyNames = builder.policyNames;
        this.policyTypes = builder.policyTypes;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public List<String> policyTypes() {
        return this.policyTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoliciesRequest)) {
            return false;
        }
        DescribePoliciesRequest other = (DescribePoliciesRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.policyNames(), other.policyNames()) && Objects.equals(this.policyTypes(), other.policyTypes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        if (this.policyTypes() != null) {
            sb.append("PolicyTypes: ").append(this.policyTypes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "PolicyNames": {
                return Optional.of(clazz.cast(this.policyNames()));
            }
            case "PolicyTypes": {
                return Optional.of(clazz.cast(this.policyTypes()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> policyNames;
        private List<String> policyTypes;
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePoliciesRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.policyNames(model.policyNames);
            this.policyTypes(model.policyTypes);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        public final Collection<String> getPolicyTypes() {
            return this.policyTypes;
        }

        @Override
        public final Builder policyTypes(Collection<String> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(String ... policyTypes) {
            this.policyTypes(Arrays.asList(policyTypes));
            return this;
        }

        public final void setPolicyTypes(Collection<String> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribePoliciesRequest build() {
            return new DescribePoliciesRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, DescribePoliciesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);

        public Builder policyTypes(Collection<String> var1);

        public Builder policyTypes(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

