/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.autoscaling.model.ActivitiesCopier;
import software.amazon.awssdk.services.autoscaling.model.Activity;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExitStandbyResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, ExitStandbyResponse> {
    private final List<Activity> activities;

    private ExitStandbyResponse(BuilderImpl builder) {
        super(builder);
        this.activities = builder.activities;
    }

    public List<Activity> activities() {
        return this.activities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExitStandbyResponse)) {
            return false;
        }
        ExitStandbyResponse other = (ExitStandbyResponse)((Object)obj);
        return Objects.equals(this.activities(), other.activities());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.activities() != null) {
            sb.append("Activities: ").append(this.activities()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Activities": {
                return Optional.of(clazz.cast(this.activities()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<Activity> activities;

        private BuilderImpl() {
        }

        private BuilderImpl(ExitStandbyResponse model) {
            this.activities(model.activities);
        }

        public final Collection<Activity.Builder> getActivities() {
            return this.activities != null ? (Collection)this.activities.stream().map(Activity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Activity ... activities) {
            this.activities(Arrays.asList(activities));
            return this;
        }

        public final void setActivities(Collection<Activity.BuilderImpl> activities) {
            this.activities = ActivitiesCopier.copyFromBuilder(activities);
        }

        @Override
        public ExitStandbyResponse build() {
            return new ExitStandbyResponse(this);
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    CopyableBuilder<Builder, ExitStandbyResponse> {
        public Builder activities(Collection<Activity> var1);

        public Builder activities(Activity ... var1);
    }
}

