/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingPolicy;

public final class DescribePoliciesPaginator
implements SdkIterable<DescribePoliciesResponse> {
    private final AutoScalingClient client;
    private final DescribePoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribePoliciesPaginator(AutoScalingClient client, DescribePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePoliciesResponseFetcher();
    }

    public Iterator<DescribePoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ScalingPolicy> scalingPolicies() {
        Function<DescribePoliciesResponse, Iterator> getIterator = response -> response != null ? response.scalingPolicies().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribePoliciesResponseFetcher
    implements NextPageFetcher<DescribePoliciesResponse> {
        private DescribePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePoliciesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribePoliciesResponse nextPage(DescribePoliciesResponse previousPage) {
            if (previousPage == null) {
                return DescribePoliciesPaginator.this.client.describePolicies(DescribePoliciesPaginator.this.firstRequest);
            }
            return DescribePoliciesPaginator.this.client.describePolicies((DescribePoliciesRequest)((Object)DescribePoliciesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

