/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLifecycleHooksResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeLifecycleHooksResponse.Builder, DescribeLifecycleHooksResponse> {
    private final List<LifecycleHook> lifecycleHooks;

    private DescribeLifecycleHooksResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleHooks = builder.lifecycleHooks;
    }

    /**
     * <p>
     * The lifecycle hooks for the specified group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The lifecycle hooks for the specified group.
     */
    public List<LifecycleHook> lifecycleHooks() {
        return lifecycleHooks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleHooks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksResponse)) {
            return false;
        }
        DescribeLifecycleHooksResponse other = (DescribeLifecycleHooksResponse) obj;
        return Objects.equals(lifecycleHooks(), other.lifecycleHooks());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeLifecycleHooksResponse").add("LifecycleHooks", lifecycleHooks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleHooks":
            return Optional.of(clazz.cast(lifecycleHooks()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder, CopyableBuilder<Builder, DescribeLifecycleHooksResponse> {
        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * 
         * @param lifecycleHooks
         *        The lifecycle hooks for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks);

        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * 
         * @param lifecycleHooks
         *        The lifecycle hooks for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHooks(LifecycleHook... lifecycleHooks);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<LifecycleHook> lifecycleHooks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksResponse model) {
            lifecycleHooks(model.lifecycleHooks);
        }

        public final Collection<LifecycleHook.Builder> getLifecycleHooks() {
            return lifecycleHooks != null ? lifecycleHooks.stream().map(LifecycleHook::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copy(lifecycleHooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(LifecycleHook... lifecycleHooks) {
            lifecycleHooks(Arrays.asList(lifecycleHooks));
            return this;
        }

        public final void setLifecycleHooks(Collection<LifecycleHook.BuilderImpl> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copyFromBuilder(lifecycleHooks);
        }

        @Override
        public DescribeLifecycleHooksResponse build() {
            return new DescribeLifecycleHooksResponse(this);
        }
    }
}
