/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScheduledActionsRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DescribeScheduledActionsRequest.Builder, DescribeScheduledActionsRequest> {
    private final String autoScalingGroupName;

    private final List<String> scheduledActionNames;

    private final Instant startTime;

    private final Instant endTime;

    private final String nextToken;

    private final Integer maxRecords;

    private DescribeScheduledActionsRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionNames = builder.scheduledActionNames;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * Describes one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If you
     * specify an unknown scheduled action, it is ignored with no error.
     * </p>
     * <p>
     * You can describe up to a maximum of 50 instances with a single call. If there are more items to return, the call
     * returns a token. To get the next set of items, repeat the call with the returned token.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Describes one or more scheduled actions. If you omit this parameter, all scheduled actions are described.
     *         If you specify an unknown scheduled action, it is ignored with no error.</p>
     *         <p>
     *         You can describe up to a maximum of 50 instances with a single call. If there are more items to return,
     *         the call returns a token. To get the next set of items, repeat the call with the returned token.
     */
    public List<String> scheduledActionNames() {
        return scheduledActionNames;
    }

    /**
     * <p>
     * The earliest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.
     * </p>
     * 
     * @return The earliest scheduled start time to return. If scheduled action names are provided, this parameter is
     *         ignored.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.
     * </p>
     * 
     * @return The latest scheduled start time to return. If scheduled action names are provided, this parameter is
     *         ignored.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.
     * </p>
     * 
     * @return The maximum number of items to return with this call. The default value is 50 and the maximum value is
     *         100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionNames());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsRequest)) {
            return false;
        }
        DescribeScheduledActionsRequest other = (DescribeScheduledActionsRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(scheduledActionNames(), other.scheduledActionNames())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxRecords(), other.maxRecords());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeScheduledActionsRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("ScheduledActionNames", scheduledActionNames()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("NextToken", nextToken()).add("MaxRecords", maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "ScheduledActionNames":
            return Optional.of(clazz.cast(scheduledActionNames()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        case "EndTime":
            return Optional.of(clazz.cast(endTime()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxRecords":
            return Optional.of(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, DescribeScheduledActionsRequest> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * Describes one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If
         * you specify an unknown scheduled action, it is ignored with no error.
         * </p>
         * <p>
         * You can describe up to a maximum of 50 instances with a single call. If there are more items to return, the
         * call returns a token. To get the next set of items, repeat the call with the returned token.
         * </p>
         * 
         * @param scheduledActionNames
         *        Describes one or more scheduled actions. If you omit this parameter, all scheduled actions are
         *        described. If you specify an unknown scheduled action, it is ignored with no error.</p>
         *        <p>
         *        You can describe up to a maximum of 50 instances with a single call. If there are more items to
         *        return, the call returns a token. To get the next set of items, repeat the call with the returned
         *        token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionNames(Collection<String> scheduledActionNames);

        /**
         * <p>
         * Describes one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If
         * you specify an unknown scheduled action, it is ignored with no error.
         * </p>
         * <p>
         * You can describe up to a maximum of 50 instances with a single call. If there are more items to return, the
         * call returns a token. To get the next set of items, repeat the call with the returned token.
         * </p>
         * 
         * @param scheduledActionNames
         *        Describes one or more scheduled actions. If you omit this parameter, all scheduled actions are
         *        described. If you specify an unknown scheduled action, it is ignored with no error.</p>
         *        <p>
         *        You can describe up to a maximum of 50 instances with a single call. If there are more items to
         *        return, the call returns a token. To get the next set of items, repeat the call with the returned
         *        token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionNames(String... scheduledActionNames);

        /**
         * <p>
         * The earliest scheduled start time to return. If scheduled action names are provided, this parameter is
         * ignored.
         * </p>
         * 
         * @param startTime
         *        The earliest scheduled start time to return. If scheduled action names are provided, this parameter is
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.
         * </p>
         * 
         * @param endTime
         *        The latest scheduled start time to return. If scheduled action names are provided, this parameter is
         *        ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return with this call. The default value is 50 and the maximum value is 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to return with this call. The default value is 50 and the maximum value is
         *        100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> scheduledActionNames;

        private Instant startTime;

        private Instant endTime;

        private String nextToken;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            scheduledActionNames(model.scheduledActionNames);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            maxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScheduledActionNames() {
            return scheduledActionNames;
        }

        @Override
        public final Builder scheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActionNames(String... scheduledActionNames) {
            scheduledActionNames(Arrays.asList(scheduledActionNames));
            return this;
        }

        public final void setScheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledActionsRequest build() {
            return new DescribeScheduledActionsRequest(this);
        }
    }
}
