/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SuspendProcessesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<SuspendProcessesRequest.Builder, SuspendProcessesRequest> {
    private final String autoScalingGroupName;

    private final List<String> scalingProcesses;

    private SuspendProcessesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scalingProcesses = builder.scalingProcesses;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * One or more of the following processes. If you omit this parameter, all processes are specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Launch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminate</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HealthCheck</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceUnhealthy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AZRebalance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AlarmNotification</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AddToLoadBalancer</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more of the following processes. If you omit this parameter, all processes are specified.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Launch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminate</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HealthCheck</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReplaceUnhealthy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AZRebalance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AlarmNotification</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActions</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AddToLoadBalancer</code>
     *         </p>
     *         </li>
     */
    public List<String> scalingProcesses() {
        return scalingProcesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingProcesses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendProcessesRequest)) {
            return false;
        }
        SuspendProcessesRequest other = (SuspendProcessesRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(scalingProcesses(), other.scalingProcesses());
    }

    @Override
    public String toString() {
        return ToString.builder("SuspendProcessesRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("ScalingProcesses", scalingProcesses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "ScalingProcesses":
            return Optional.of(clazz.cast(scalingProcesses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, SuspendProcessesRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * One or more of the following processes. If you omit this parameter, all processes are specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingProcesses
         *        One or more of the following processes. If you omit this parameter, all processes are specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingProcesses(Collection<String> scalingProcesses);

        /**
         * <p>
         * One or more of the following processes. If you omit this parameter, all processes are specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingProcesses
         *        One or more of the following processes. If you omit this parameter, all processes are specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingProcesses(String... scalingProcesses);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> scalingProcesses;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendProcessesRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            scalingProcesses(model.scalingProcesses);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScalingProcesses() {
            return scalingProcesses;
        }

        @Override
        public final Builder scalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingProcesses(String... scalingProcesses) {
            scalingProcesses(Arrays.asList(scalingProcesses));
            return this;
        }

        public final void setScalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SuspendProcessesRequest build() {
            return new SuspendProcessesRequest(this);
        }
    }
}
