/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * LaunchConfiguration StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LaunchConfigurationUnmarshaller implements Unmarshaller<LaunchConfiguration, StaxUnmarshallerContext> {

    public LaunchConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchConfiguration.Builder launchConfiguration = LaunchConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> securityGroups = null;
        java.util.List<String> classicLinkVPCSecurityGroups = null;
        java.util.List<BlockDeviceMapping> blockDeviceMappings = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                launchConfiguration.securityGroups(securityGroups);
                launchConfiguration.classicLinkVPCSecurityGroups(classicLinkVPCSecurityGroups);
                launchConfiguration.blockDeviceMappings(blockDeviceMappings);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("LaunchConfigurationName", targetDepth)) {
                    launchConfiguration.launchConfigurationName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LaunchConfigurationARN", targetDepth)) {
                    launchConfiguration.launchConfigurationARN(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ImageId", targetDepth)) {
                    launchConfiguration.imageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("KeyName", targetDepth)) {
                    launchConfiguration.keyName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SecurityGroups", targetDepth)) {
                    securityGroups = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("SecurityGroups/member", targetDepth)) {
                    securityGroups.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ClassicLinkVPCId", targetDepth)) {
                    launchConfiguration.classicLinkVPCId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ClassicLinkVPCSecurityGroups", targetDepth)) {
                    classicLinkVPCSecurityGroups = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("ClassicLinkVPCSecurityGroups/member", targetDepth)) {
                    classicLinkVPCSecurityGroups.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("UserData", targetDepth)) {
                    launchConfiguration.userData(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("InstanceType", targetDepth)) {
                    launchConfiguration.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("KernelId", targetDepth)) {
                    launchConfiguration.kernelId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RamdiskId", targetDepth)) {
                    launchConfiguration.ramdiskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("BlockDeviceMappings", targetDepth)) {
                    blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                    continue;
                }

                if (context.testExpression("BlockDeviceMappings/member", targetDepth)) {
                    blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("InstanceMonitoring", targetDepth)) {
                    launchConfiguration.instanceMonitoring(InstanceMonitoringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SpotPrice", targetDepth)) {
                    launchConfiguration.spotPrice(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IamInstanceProfile", targetDepth)) {
                    launchConfiguration.iamInstanceProfile(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CreatedTime", targetDepth)) {
                    launchConfiguration.createdTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EbsOptimized", targetDepth)) {
                    launchConfiguration.ebsOptimized(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AssociatePublicIpAddress", targetDepth)) {
                    launchConfiguration.associatePublicIpAddress(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PlacementTenancy", targetDepth)) {
                    launchConfiguration.placementTenancy(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    launchConfiguration.securityGroups(securityGroups);
                    launchConfiguration.classicLinkVPCSecurityGroups(classicLinkVPCSecurityGroups);
                    launchConfiguration.blockDeviceMappings(blockDeviceMappings);
                    break;
                }
            }
        }
        return launchConfiguration.build();
    }

    private static final LaunchConfigurationUnmarshaller INSTANCE = new LaunchConfigurationUnmarshaller();

    public static LaunchConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
