/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeletePolicyRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DeletePolicyRequest.Builder, DeletePolicyRequest> {
    private final String autoScalingGroupName;

    private final String policyName;

    private DeletePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the policy.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the policy.
     */
    public String policyName() {
        return policyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePolicyRequest)) {
            return false;
        }
        DeletePolicyRequest other = (DeletePolicyRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(policyName(), other.policyName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeletePolicyRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("PolicyName", policyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.of(clazz.cast(autoScalingGroupName()));
        case "PolicyName":
            return Optional.of(clazz.cast(policyName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, DeletePolicyRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the policy.
         * </p>
         * 
         * @param policyName
         *        The name or Amazon Resource Name (ARN) of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePolicyRequest model) {
            autoScalingGroupName(model.autoScalingGroupName);
            policyName(model.policyName);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeletePolicyRequest build() {
            return new DeletePolicyRequest(this);
        }
    }
}
