/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAutoScalingNotificationTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeAutoScalingNotificationTypesResponse.Builder, DescribeAutoScalingNotificationTypesResponse> {
    private final List<String> autoScalingNotificationTypes;

    private DescribeAutoScalingNotificationTypesResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingNotificationTypes = builder.autoScalingNotificationTypes;
    }

    /**
     * <p>
     * The notification types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The notification types.
     */
    public List<String> autoScalingNotificationTypes() {
        return autoScalingNotificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingNotificationTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingNotificationTypesResponse)) {
            return false;
        }
        DescribeAutoScalingNotificationTypesResponse other = (DescribeAutoScalingNotificationTypesResponse) obj;
        return Objects.equals(autoScalingNotificationTypes(), other.autoScalingNotificationTypes());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAutoScalingNotificationTypesResponse")
                .add("AutoScalingNotificationTypes", autoScalingNotificationTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingNotificationTypes":
            return Optional.of(clazz.cast(autoScalingNotificationTypes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder,
            CopyableBuilder<Builder, DescribeAutoScalingNotificationTypesResponse> {
        /**
         * <p>
         * The notification types.
         * </p>
         * 
         * @param autoScalingNotificationTypes
         *        The notification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes);

        /**
         * <p>
         * The notification types.
         * </p>
         * 
         * @param autoScalingNotificationTypes
         *        The notification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingNotificationTypes(String... autoScalingNotificationTypes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<String> autoScalingNotificationTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingNotificationTypesResponse model) {
            autoScalingNotificationTypes(model.autoScalingNotificationTypes);
        }

        public final Collection<String> getAutoScalingNotificationTypes() {
            return autoScalingNotificationTypes;
        }

        @Override
        public final Builder autoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingNotificationTypes(String... autoScalingNotificationTypes) {
            autoScalingNotificationTypes(Arrays.asList(autoScalingNotificationTypes));
            return this;
        }

        public final void setAutoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
        }

        @Override
        public DescribeAutoScalingNotificationTypesResponse build() {
            return new DescribeAutoScalingNotificationTypesResponse(this);
        }
    }
}
