/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTerminationPolicyTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeTerminationPolicyTypesResponse.Builder, DescribeTerminationPolicyTypesResponse> {
    private final List<String> terminationPolicyTypes;

    private DescribeTerminationPolicyTypesResponse(BuilderImpl builder) {
        super(builder);
        this.terminationPolicyTypes = builder.terminationPolicyTypes;
    }

    /**
     * <p>
     * The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
     * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>, and
     * <code>Default</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
     *         <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
     *         <code>ClosestToNextInstanceHour</code>, and <code>Default</code>).
     */
    public List<String> terminationPolicyTypes() {
        return terminationPolicyTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(terminationPolicyTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTerminationPolicyTypesResponse)) {
            return false;
        }
        DescribeTerminationPolicyTypesResponse other = (DescribeTerminationPolicyTypesResponse) obj;
        return Objects.equals(terminationPolicyTypes(), other.terminationPolicyTypes());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTerminationPolicyTypesResponse").add("TerminationPolicyTypes", terminationPolicyTypes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminationPolicyTypes":
            return Optional.of(clazz.cast(terminationPolicyTypes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder,
            CopyableBuilder<Builder, DescribeTerminationPolicyTypesResponse> {
        /**
         * <p>
         * The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
         * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
         * and <code>Default</code>).
         * </p>
         * 
         * @param terminationPolicyTypes
         *        The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
         *        <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
         *        <code>ClosestToNextInstanceHour</code>, and <code>Default</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes);

        /**
         * <p>
         * The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
         * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
         * and <code>Default</code>).
         * </p>
         * 
         * @param terminationPolicyTypes
         *        The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
         *        <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
         *        <code>ClosestToNextInstanceHour</code>, and <code>Default</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicyTypes(String... terminationPolicyTypes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<String> terminationPolicyTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTerminationPolicyTypesResponse model) {
            terminationPolicyTypes(model.terminationPolicyTypes);
        }

        public final Collection<String> getTerminationPolicyTypes() {
            return terminationPolicyTypes;
        }

        @Override
        public final Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicyTypes(String... terminationPolicyTypes) {
            terminationPolicyTypes(Arrays.asList(terminationPolicyTypes));
            return this;
        }

        public final void setTerminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
        }

        @Override
        public DescribeTerminationPolicyTypesResponse build() {
            return new DescribeTerminationPolicyTypesResponse(this);
        }
    }
}
