/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachInstancesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DetachInstancesResponse.Builder, DetachInstancesResponse> {
    private final List<Activity> activities;

    private DetachInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.activities = builder.activities;
    }

    /**
     * <p>
     * The activities related to detaching the instances from the Auto Scaling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The activities related to detaching the instances from the Auto Scaling group.
     */
    public List<Activity> activities() {
        return activities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activities());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachInstancesResponse)) {
            return false;
        }
        DetachInstancesResponse other = (DetachInstancesResponse) obj;
        return Objects.equals(activities(), other.activities());
    }

    @Override
    public String toString() {
        return ToString.builder("DetachInstancesResponse").add("Activities", activities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Activities":
            return Optional.of(clazz.cast(activities()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder, CopyableBuilder<Builder, DetachInstancesResponse> {
        /**
         * <p>
         * The activities related to detaching the instances from the Auto Scaling group.
         * </p>
         * 
         * @param activities
         *        The activities related to detaching the instances from the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Collection<Activity> activities);

        /**
         * <p>
         * The activities related to detaching the instances from the Auto Scaling group.
         * </p>
         * 
         * @param activities
         *        The activities related to detaching the instances from the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Activity... activities);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<Activity> activities;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachInstancesResponse model) {
            activities(model.activities);
        }

        public final Collection<Activity.Builder> getActivities() {
            return activities != null ? activities.stream().map(Activity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Activity... activities) {
            activities(Arrays.asList(activities));
            return this;
        }

        public final void setActivities(Collection<Activity.BuilderImpl> activities) {
            this.activities = ActivitiesCopier.copyFromBuilder(activities);
        }

        @Override
        public DetachInstancesResponse build() {
            return new DetachInstancesResponse(this);
        }
    }
}
