/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribePoliciesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribePoliciesRequestMarshaller implements Marshaller<Request<DescribePoliciesRequest>, DescribePoliciesRequest> {

    public Request<DescribePoliciesRequest> marshall(DescribePoliciesRequest describePoliciesRequest) {

        if (describePoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribePoliciesRequest> request = new DefaultRequest<DescribePoliciesRequest>(describePoliciesRequest,
                "AutoScalingClient");
        request.addParameter("Action", "DescribePolicies");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describePoliciesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(describePoliciesRequest.autoScalingGroupName()));
        }

        java.util.List<String> policyNamesList = describePoliciesRequest.policyNames();

        if (policyNamesList != null) {
            if (!policyNamesList.isEmpty()) {
                int policyNamesListIndex = 1;

                for (String policyNamesListValue : policyNamesList) {
                    if (policyNamesListValue != null) {
                        request.addParameter("PolicyNames.member." + policyNamesListIndex,
                                StringUtils.fromString(policyNamesListValue));
                    }
                    policyNamesListIndex++;
                }
            } else {
                request.addParameter("PolicyNames", "");
            }
        }

        java.util.List<String> policyTypesList = describePoliciesRequest.policyTypes();

        if (policyTypesList != null) {
            if (!policyTypesList.isEmpty()) {
                int policyTypesListIndex = 1;

                for (String policyTypesListValue : policyTypesList) {
                    if (policyTypesListValue != null) {
                        request.addParameter("PolicyTypes.member." + policyTypesListIndex,
                                StringUtils.fromString(policyTypesListValue));
                    }
                    policyTypesListIndex++;
                }
            } else {
                request.addParameter("PolicyTypes", "");
            }
        }

        if (describePoliciesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describePoliciesRequest.nextToken()));
        }

        if (describePoliciesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describePoliciesRequest.maxRecords()));
        }

        return request;
    }

}
