/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeScheduledActionsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeScheduledActionsRequestMarshaller implements
        Marshaller<Request<DescribeScheduledActionsRequest>, DescribeScheduledActionsRequest> {

    public Request<DescribeScheduledActionsRequest> marshall(DescribeScheduledActionsRequest describeScheduledActionsRequest) {

        if (describeScheduledActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeScheduledActionsRequest> request = new DefaultRequest<DescribeScheduledActionsRequest>(
                describeScheduledActionsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeScheduledActions");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeScheduledActionsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringUtils.fromString(describeScheduledActionsRequest.autoScalingGroupName()));
        }

        java.util.List<String> scheduledActionNamesList = describeScheduledActionsRequest.scheduledActionNames();

        if (scheduledActionNamesList != null) {
            if (!scheduledActionNamesList.isEmpty()) {
                int scheduledActionNamesListIndex = 1;

                for (String scheduledActionNamesListValue : scheduledActionNamesList) {
                    if (scheduledActionNamesListValue != null) {
                        request.addParameter("ScheduledActionNames.member." + scheduledActionNamesListIndex,
                                StringUtils.fromString(scheduledActionNamesListValue));
                    }
                    scheduledActionNamesListIndex++;
                }
            } else {
                request.addParameter("ScheduledActionNames", "");
            }
        }

        if (describeScheduledActionsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant(describeScheduledActionsRequest.startTime()));
        }

        if (describeScheduledActionsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant(describeScheduledActionsRequest.endTime()));
        }

        if (describeScheduledActionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeScheduledActionsRequest.nextToken()));
        }

        if (describeScheduledActionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeScheduledActionsRequest.maxRecords()));
        }

        return request;
    }

}
