/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoScalingInstanceDetails
implements ToCopyableBuilder<Builder, AutoScalingInstanceDetails> {
    private final String instanceId;
    private final String autoScalingGroupName;
    private final String availabilityZone;
    private final String lifecycleState;
    private final String healthStatus;
    private final String launchConfigurationName;
    private final Boolean protectedFromScaleIn;

    private AutoScalingInstanceDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.availabilityZone = builder.availabilityZone;
        this.lifecycleState = builder.lifecycleState;
        this.healthStatus = builder.healthStatus;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.protectedFromScaleIn = builder.protectedFromScaleIn;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String lifecycleState() {
        return this.lifecycleState;
    }

    public String healthStatus() {
        return this.healthStatus;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public Boolean protectedFromScaleIn() {
        return this.protectedFromScaleIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedFromScaleIn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingInstanceDetails)) {
            return false;
        }
        AutoScalingInstanceDetails other = (AutoScalingInstanceDetails)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.lifecycleState(), other.lifecycleState()) && Objects.equals(this.healthStatus(), other.healthStatus()) && Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.protectedFromScaleIn(), other.protectedFromScaleIn());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingInstanceDetails").add("InstanceId", (Object)this.instanceId()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("LifecycleState", (Object)this.lifecycleState()).add("HealthStatus", (Object)this.healthStatus()).add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("ProtectedFromScaleIn", (Object)this.protectedFromScaleIn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "LifecycleState": {
                return Optional.of(clazz.cast(this.lifecycleState()));
            }
            case "HealthStatus": {
                return Optional.of(clazz.cast(this.healthStatus()));
            }
            case "LaunchConfigurationName": {
                return Optional.of(clazz.cast(this.launchConfigurationName()));
            }
            case "ProtectedFromScaleIn": {
                return Optional.of(clazz.cast(this.protectedFromScaleIn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String autoScalingGroupName;
        private String availabilityZone;
        private String lifecycleState;
        private String healthStatus;
        private String launchConfigurationName;
        private Boolean protectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingInstanceDetails model) {
            this.instanceId(model.instanceId);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.availabilityZone(model.availabilityZone);
            this.lifecycleState(model.lifecycleState);
            this.healthStatus(model.healthStatus);
            this.launchConfigurationName(model.launchConfigurationName);
            this.protectedFromScaleIn(model.protectedFromScaleIn);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getLifecycleState() {
            return this.lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final Boolean getProtectedFromScaleIn() {
            return this.protectedFromScaleIn;
        }

        @Override
        public final Builder protectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
            return this;
        }

        public final void setProtectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
        }

        public AutoScalingInstanceDetails build() {
            return new AutoScalingInstanceDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingInstanceDetails> {
        public Builder instanceId(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder availabilityZone(String var1);

        public Builder lifecycleState(String var1);

        public Builder healthStatus(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder protectedFromScaleIn(Boolean var1);
    }
}

