/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingPolicy;

public class DescribePoliciesIterable
implements SdkIterable<DescribePoliciesResponse> {
    private final AutoScalingClient client;
    private final DescribePoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePoliciesIterable(AutoScalingClient client, DescribePoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePoliciesResponseFetcher();
    }

    public Iterator<DescribePoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ScalingPolicy> scalingPolicies() {
        Function<DescribePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scalingPolicies() != null) {
                return response.scalingPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribePoliciesIterable resume(DescribePoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribePoliciesIterable(this.client, (DescribePoliciesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribePoliciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribePoliciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribePoliciesResponseFetcher
    implements SyncPageFetcher<DescribePoliciesResponse> {
        private DescribePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePoliciesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribePoliciesResponse nextPage(DescribePoliciesResponse previousPage) {
            if (previousPage == null) {
                return DescribePoliciesIterable.this.client.describePolicies(DescribePoliciesIterable.this.firstRequest);
            }
            return DescribePoliciesIterable.this.client.describePolicies((DescribePoliciesRequest)((Object)DescribePoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

