/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.autoscaling.model.AlreadyExistsException;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingException;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse;
import software.amazon.awssdk.services.autoscaling.model.ResourceContentionException;
import software.amazon.awssdk.services.autoscaling.model.ResourceInUseException;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingActivityInProgressException;
import software.amazon.awssdk.services.autoscaling.model.ServiceLinkedRoleFailureException;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionResponse;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher;
import software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher;
import software.amazon.awssdk.services.autoscaling.transform.AttachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.AttachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchDeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.BatchPutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CompleteLifecycleActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.CreateOrUpdateTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAdjustmentTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeAutoScalingNotificationTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLaunchConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHookTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLifecycleHooksRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeMetricCollectionTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeNotificationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribePoliciesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingActivitiesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScalingProcessTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DescribeTerminationPolicyTypesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachInstancesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancerTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DetachLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.DisableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnableMetricsCollectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.EnterStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExecutePolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ExitStandbyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutLifecycleHookRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScalingPolicyRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.PutScheduledUpdateGroupActionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.RecordLifecycleActionHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.ResumeProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetDesiredCapacityRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceHealthRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SetInstanceProtectionRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SuspendProcessesRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.TerminateInstanceInAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.services.autoscaling.transform.UpdateAutoScalingGroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link AutoScalingAsyncClient}.
 *
 * @see AutoScalingAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAutoScalingAsyncClient implements AutoScalingAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAutoScalingAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAutoScalingAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Attaches one or more EC2 instances to the specified Auto Scaling group.
     * </p>
     * <p>
     * When you attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the group by the number of
     * instances being attached. If the number of instances being attached plus the desired capacity of the group
     * exceeds the maximum size of the group, the operation fails.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with
     * the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also
     * registered with the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html">Attach EC2 Instances to Your
     * Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param attachInstancesRequest
     * @return A Java Future containing the result of the AttachInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachInstancesResponse> attachInstances(AttachInstancesRequest attachInstancesRequest) {
        try {

            HttpResponseHandler<AttachInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<AttachInstancesRequest, AttachInstancesResponse>()
                    .withMarshaller(new AttachInstancesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(attachInstancesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches one or more target groups to the specified Auto Scaling group.
     * </p>
     * <p>
     * To describe the target groups for an Auto Scaling group, use <a>DescribeLoadBalancerTargetGroups</a>. To detach
     * the target group from the Auto Scaling group, use <a>DetachLoadBalancerTargetGroups</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-load-balancer-asg.html">Attach a Load Balancer
     * to Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param attachLoadBalancerTargetGroupsRequest
     * @return A Java Future containing the result of the AttachLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachLoadBalancerTargetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachLoadBalancerTargetGroupsResponse> attachLoadBalancerTargetGroups(
            AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) {
        try {

            HttpResponseHandler<AttachLoadBalancerTargetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachLoadBalancerTargetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<AttachLoadBalancerTargetGroupsRequest, AttachLoadBalancerTargetGroupsResponse>()
                            .withMarshaller(new AttachLoadBalancerTargetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachLoadBalancerTargetGroupsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches one or more Classic Load Balancers to the specified Auto Scaling group.
     * </p>
     * <p>
     * To attach an Application Load Balancer instead, see <a>AttachLoadBalancerTargetGroups</a>.
     * </p>
     * <p>
     * To describe the load balancers for an Auto Scaling group, use <a>DescribeLoadBalancers</a>. To detach the load
     * balancer from the Auto Scaling group, use <a>DetachLoadBalancers</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-load-balancer-asg.html">Attach a Load Balancer
     * to Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param attachLoadBalancersRequest
     * @return A Java Future containing the result of the AttachLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.AttachLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachLoadBalancersResponse> attachLoadBalancers(
            AttachLoadBalancersRequest attachLoadBalancersRequest) {
        try {

            HttpResponseHandler<AttachLoadBalancersResponse> responseHandler = protocolFactory
                    .createResponseHandler(AttachLoadBalancersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<AttachLoadBalancersRequest, AttachLoadBalancersResponse>()
                    .withMarshaller(new AttachLoadBalancersRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(attachLoadBalancersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more scheduled actions for the specified Auto Scaling group.
     * </p>
     *
     * @param batchDeleteScheduledActionRequest
     * @return A Java Future containing the result of the BatchDeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.BatchDeleteScheduledAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchDeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteScheduledActionResponse> batchDeleteScheduledAction(
            BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) {
        try {

            HttpResponseHandler<BatchDeleteScheduledActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(BatchDeleteScheduledActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteScheduledActionRequest, BatchDeleteScheduledActionResponse>()
                            .withMarshaller(new BatchDeleteScheduledActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchDeleteScheduledActionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates one or more scheduled scaling actions for an Auto Scaling group. If you leave a parameter
     * unspecified when updating a scheduled scaling action, the corresponding value remains unchanged.
     * </p>
     *
     * @param batchPutScheduledUpdateGroupActionRequest
     * @return A Java Future containing the result of the BatchPutScheduledUpdateGroupAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.BatchPutScheduledUpdateGroupAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/BatchPutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchPutScheduledUpdateGroupActionResponse> batchPutScheduledUpdateGroupAction(
            BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) {
        try {

            HttpResponseHandler<BatchPutScheduledUpdateGroupActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(BatchPutScheduledUpdateGroupActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<BatchPutScheduledUpdateGroupActionRequest, BatchPutScheduledUpdateGroupActionResponse>()
                            .withMarshaller(new BatchPutScheduledUpdateGroupActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchPutScheduledUpdateGroupActionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Completes the lifecycle action for the specified token or instance with the specified result.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when
     * Amazon EC2 Auto Scaling launches or terminates instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you finish before the timeout period ends, complete the lifecycle action.</b>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
     * Lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param completeLifecycleActionRequest
     * @return A Java Future containing the result of the CompleteLifecycleAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CompleteLifecycleAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CompleteLifecycleActionResponse> completeLifecycleAction(
            CompleteLifecycleActionRequest completeLifecycleActionRequest) {
        try {

            HttpResponseHandler<CompleteLifecycleActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CompleteLifecycleActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<CompleteLifecycleActionRequest, CompleteLifecycleActionResponse>()
                            .withMarshaller(new CompleteLifecycleActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(completeLifecycleActionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Auto Scaling group with the specified name and attributes.
     * </p>
     * <p>
     * If you exceed your maximum limit of Auto Scaling groups, the call fails. For information about viewing this
     * limit, see <a>DescribeAccountLimits</a>. For information about updating this limit, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html">Auto Scaling Limits</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html">Auto Scaling Groups</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param createAutoScalingGroupRequest
     * @return A Java Future containing the result of the CreateAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateAutoScalingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAutoScalingGroupResponse> createAutoScalingGroup(
            CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        try {

            HttpResponseHandler<CreateAutoScalingGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateAutoScalingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAutoScalingGroupRequest, CreateAutoScalingGroupResponse>()
                            .withMarshaller(new CreateAutoScalingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createAutoScalingGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a launch configuration.
     * </p>
     * <p>
     * If you exceed your maximum limit of launch configurations, the call fails. For information about viewing this
     * limit, see <a>DescribeAccountLimits</a>. For information about updating this limit, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html">Auto Scaling Limits</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html">Launch Configurations</a> in
     * the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param createLaunchConfigurationRequest
     * @return A Java Future containing the result of the CreateLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLaunchConfigurationResponse> createLaunchConfiguration(
            CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        try {

            HttpResponseHandler<CreateLaunchConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateLaunchConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLaunchConfigurationRequest, CreateLaunchConfigurationResponse>()
                            .withMarshaller(new CreateLaunchConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createLaunchConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates tags for the specified Auto Scaling group.
     * </p>
     * <p>
     * When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and
     * you do not get an error message.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling Groups
     * and Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param createOrUpdateTagsRequest
     * @return A Java Future containing the result of the CreateOrUpdateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.CreateOrUpdateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateOrUpdateTags" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOrUpdateTagsResponse> createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) {
        try {

            HttpResponseHandler<CreateOrUpdateTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateOrUpdateTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<CreateOrUpdateTagsRequest, CreateOrUpdateTagsResponse>()
                    .withMarshaller(new CreateOrUpdateTagsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createOrUpdateTagsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Auto Scaling group.
     * </p>
     * <p>
     * If the group has instances or scaling activities in progress, you must specify the option to force the deletion
     * in order for it to succeed.
     * </p>
     * <p>
     * If the group has policies, deleting the group deletes the policies, the underlying alarm actions, and any alarm
     * that no longer has an associated action.
     * </p>
     * <p>
     * To remove instances from the Auto Scaling group before deleting it, call <a>DetachInstances</a> with the list of
     * instances and the option to decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling does not
     * launch replacement instances.
     * </p>
     * <p>
     * To terminate all instances before deleting the Auto Scaling group, call <a>UpdateAutoScalingGroup</a> and set the
     * minimum size and desired capacity of the Auto Scaling group to zero.
     * </p>
     *
     * @param deleteAutoScalingGroupRequest
     * @return A Java Future containing the result of the DeleteAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteAutoScalingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAutoScalingGroupResponse> deleteAutoScalingGroup(
            DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) {
        try {

            HttpResponseHandler<DeleteAutoScalingGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteAutoScalingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAutoScalingGroupRequest, DeleteAutoScalingGroupResponse>()
                            .withMarshaller(new DeleteAutoScalingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteAutoScalingGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified launch configuration.
     * </p>
     * <p>
     * The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch
     * configuration is no longer available for use.
     * </p>
     *
     * @param deleteLaunchConfigurationRequest
     * @return A Java Future containing the result of the DeleteLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLaunchConfigurationResponse> deleteLaunchConfiguration(
            DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) {
        try {

            HttpResponseHandler<DeleteLaunchConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLaunchConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchConfigurationRequest, DeleteLaunchConfigurationResponse>()
                            .withMarshaller(new DeleteLaunchConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteLaunchConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified lifecycle hook.
     * </p>
     * <p>
     * If there are any outstanding lifecycle actions, they are completed first (<code>ABANDON</code> for launching
     * instances, <code>CONTINUE</code> for terminating instances).
     * </p>
     *
     * @param deleteLifecycleHookRequest
     * @return A Java Future containing the result of the DeleteLifecycleHook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteLifecycleHook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLifecycleHookResponse> deleteLifecycleHook(
            DeleteLifecycleHookRequest deleteLifecycleHookRequest) {
        try {

            HttpResponseHandler<DeleteLifecycleHookResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteLifecycleHookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteLifecycleHookRequest, DeleteLifecycleHookResponse>()
                    .withMarshaller(new DeleteLifecycleHookRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteLifecycleHookRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified notification.
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     * @return A Java Future containing the result of the DeleteNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteNotificationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNotificationConfigurationResponse> deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) {
        try {

            HttpResponseHandler<DeleteNotificationConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteNotificationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNotificationConfigurationRequest, DeleteNotificationConfigurationResponse>()
                            .withMarshaller(new DeleteNotificationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNotificationConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Auto Scaling policy.
     * </p>
     * <p>
     * Deleting a policy deletes the underlying alarm action, but does not delete the alarm, even if it no longer has an
     * associated action.
     * </p>
     *
     * @param deletePolicyRequest
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeletePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        try {

            HttpResponseHandler<DeletePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeletePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeletePolicyRequest, DeletePolicyResponse>()
                    .withMarshaller(new DeletePolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified scheduled action.
     * </p>
     *
     * @param deleteScheduledActionRequest
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteScheduledAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            DeleteScheduledActionRequest deleteScheduledActionRequest) {
        try {

            HttpResponseHandler<DeleteScheduledActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteScheduledActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteScheduledActionRequest, DeleteScheduledActionResponse>()
                    .withMarshaller(new DeleteScheduledActionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteScheduledActionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified tags.
     * </p>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        try {

            HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>()
                    .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteTagsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current Auto Scaling resource limits for your AWS account.
     * </p>
     * <p>
     * For information about requesting an increase in these limits, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html">Auto Scaling Limits</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        try {

            HttpResponseHandler<DescribeAccountLimitsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAccountLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse>()
                    .withMarshaller(new DescribeAccountLimitsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeAccountLimitsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the policy adjustment types for use with <a>PutScalingPolicy</a>.
     * </p>
     *
     * @param describeAdjustmentTypesRequest
     * @return A Java Future containing the result of the DescribeAdjustmentTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAdjustmentTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAdjustmentTypesResponse> describeAdjustmentTypes(
            DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest) {
        try {

            HttpResponseHandler<DescribeAdjustmentTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAdjustmentTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAdjustmentTypesRequest, DescribeAdjustmentTypesResponse>()
                            .withMarshaller(new DescribeAdjustmentTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAdjustmentTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more Auto Scaling groups.
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     * @return A Java Future containing the result of the DescribeAutoScalingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAutoScalingGroupsResponse> describeAutoScalingGroups(
            DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        try {

            HttpResponseHandler<DescribeAutoScalingGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAutoScalingGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResponse>()
                            .withMarshaller(new DescribeAutoScalingGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAutoScalingGroupsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more Auto Scaling groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher publisher = client.describeAutoScalingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingGroupsPublisher publisher = client.describeAutoScalingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingGroups(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutoScalingGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAutoScalingGroupsPublisher describeAutoScalingGroupsPaginator(
            DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        return new DescribeAutoScalingGroupsPublisher(this, applyPaginatorUserAgent(describeAutoScalingGroupsRequest));
    }

    /**
     * <p>
     * Describes one or more Auto Scaling instances.
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     * @return A Java Future containing the result of the DescribeAutoScalingInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAutoScalingInstancesResponse> describeAutoScalingInstances(
            DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        try {

            HttpResponseHandler<DescribeAutoScalingInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAutoScalingInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAutoScalingInstancesRequest, DescribeAutoScalingInstancesResponse>()
                            .withMarshaller(new DescribeAutoScalingInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAutoScalingInstancesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more Auto Scaling instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher publisher = client.describeAutoScalingInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeAutoScalingInstancesPublisher publisher = client.describeAutoScalingInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutoScalingInstances(software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutoScalingInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAutoScalingInstancesPublisher describeAutoScalingInstancesPaginator(
            DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        return new DescribeAutoScalingInstancesPublisher(this, applyPaginatorUserAgent(describeAutoScalingInstancesRequest));
    }

    /**
     * <p>
     * Describes the notification types that are supported by Amazon EC2 Auto Scaling.
     * </p>
     *
     * @param describeAutoScalingNotificationTypesRequest
     * @return A Java Future containing the result of the DescribeAutoScalingNotificationTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeAutoScalingNotificationTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAutoScalingNotificationTypesResponse> describeAutoScalingNotificationTypes(
            DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest) {
        try {

            HttpResponseHandler<DescribeAutoScalingNotificationTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAutoScalingNotificationTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAutoScalingNotificationTypesRequest, DescribeAutoScalingNotificationTypesResponse>()
                            .withMarshaller(new DescribeAutoScalingNotificationTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAutoScalingNotificationTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more launch configurations.
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     * @return A Java Future containing the result of the DescribeLaunchConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLaunchConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLaunchConfigurationsResponse> describeLaunchConfigurations(
            DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        try {

            HttpResponseHandler<DescribeLaunchConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLaunchConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLaunchConfigurationsRequest, DescribeLaunchConfigurationsResponse>()
                            .withMarshaller(new DescribeLaunchConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLaunchConfigurationsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more launch configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher publisher = client.describeLaunchConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeLaunchConfigurationsPublisher publisher = client.describeLaunchConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLaunchConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLaunchConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeLaunchConfigurationsPublisher describeLaunchConfigurationsPaginator(
            DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        return new DescribeLaunchConfigurationsPublisher(this, applyPaginatorUserAgent(describeLaunchConfigurationsRequest));
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * <p>
     * The following hook types are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * autoscaling:EC2_INSTANCE_LAUNCHING
     * </p>
     * </li>
     * <li>
     * <p>
     * autoscaling:EC2_INSTANCE_TERMINATING
     * </p>
     * </li>
     * </ul>
     *
     * @param describeLifecycleHookTypesRequest
     * @return A Java Future containing the result of the DescribeLifecycleHookTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLifecycleHookTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLifecycleHookTypesResponse> describeLifecycleHookTypes(
            DescribeLifecycleHookTypesRequest describeLifecycleHookTypesRequest) {
        try {

            HttpResponseHandler<DescribeLifecycleHookTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLifecycleHookTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLifecycleHookTypesRequest, DescribeLifecycleHookTypesResponse>()
                            .withMarshaller(new DescribeLifecycleHookTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLifecycleHookTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the lifecycle hooks for the specified Auto Scaling group.
     * </p>
     *
     * @param describeLifecycleHooksRequest
     * @return A Java Future containing the result of the DescribeLifecycleHooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLifecycleHooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHooks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLifecycleHooksResponse> describeLifecycleHooks(
            DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {
        try {

            HttpResponseHandler<DescribeLifecycleHooksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLifecycleHooksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLifecycleHooksRequest, DescribeLifecycleHooksResponse>()
                            .withMarshaller(new DescribeLifecycleHooksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLifecycleHooksRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the target groups for the specified Auto Scaling group.
     * </p>
     *
     * @param describeLoadBalancerTargetGroupsRequest
     * @return A Java Future containing the result of the DescribeLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancerTargetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoadBalancerTargetGroupsResponse> describeLoadBalancerTargetGroups(
            DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) {
        try {

            HttpResponseHandler<DescribeLoadBalancerTargetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLoadBalancerTargetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLoadBalancerTargetGroupsRequest, DescribeLoadBalancerTargetGroupsResponse>()
                            .withMarshaller(new DescribeLoadBalancerTargetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeLoadBalancerTargetGroupsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the load balancers for the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation describes only Classic Load Balancers. If you have Application Load Balancers, use
     * <a>DescribeLoadBalancerTargetGroups</a> instead.
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return A Java Future containing the result of the DescribeLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoadBalancersResponse> describeLoadBalancers(
            DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        try {

            HttpResponseHandler<DescribeLoadBalancersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLoadBalancersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse>()
                    .withMarshaller(new DescribeLoadBalancersRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(describeLoadBalancersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
     * </p>
     * <p>
     * The <code>GroupStandbyInstances</code> metric is not returned by default. You must explicitly request this metric
     * when calling <a>EnableMetricsCollection</a>.
     * </p>
     *
     * @param describeMetricCollectionTypesRequest
     * @return A Java Future containing the result of the DescribeMetricCollectionTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeMetricCollectionTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetricCollectionTypesResponse> describeMetricCollectionTypes(
            DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) {
        try {

            HttpResponseHandler<DescribeMetricCollectionTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeMetricCollectionTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMetricCollectionTypesRequest, DescribeMetricCollectionTypesResponse>()
                            .withMarshaller(new DescribeMetricCollectionTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeMetricCollectionTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the notification actions associated with the specified Auto Scaling group.
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     * @return A Java Future containing the result of the DescribeNotificationConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeNotificationConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNotificationConfigurationsResponse> describeNotificationConfigurations(
            DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        try {

            HttpResponseHandler<DescribeNotificationConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeNotificationConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeNotificationConfigurationsRequest, DescribeNotificationConfigurationsResponse>()
                            .withMarshaller(new DescribeNotificationConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeNotificationConfigurationsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the notification actions associated with the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher publisher = client.describeNotificationConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeNotificationConfigurationsPublisher publisher = client.describeNotificationConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationConfigurations(software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNotificationConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeNotificationConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeNotificationConfigurationsPublisher describeNotificationConfigurationsPaginator(
            DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        return new DescribeNotificationConfigurationsPublisher(this,
                applyPaginatorUserAgent(describeNotificationConfigurationsRequest));
    }

    /**
     * <p>
     * Describes the policies for the specified Auto Scaling group.
     * </p>
     *
     * @param describePoliciesRequest
     * @return A Java Future containing the result of the DescribePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePoliciesResponse> describePolicies(DescribePoliciesRequest describePoliciesRequest) {
        try {

            HttpResponseHandler<DescribePoliciesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribePoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribePoliciesRequest, DescribePoliciesResponse>()
                    .withMarshaller(new DescribePoliciesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describePoliciesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the policies for the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher publisher = client.describePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribePoliciesPublisher publisher = client.describePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePolicies(software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribePoliciesPublisher describePoliciesPaginator(DescribePoliciesRequest describePoliciesRequest) {
        return new DescribePoliciesPublisher(this, applyPaginatorUserAgent(describePoliciesRequest));
    }

    /**
     * <p>
     * Describes one or more scaling activities for the specified Auto Scaling group.
     * </p>
     *
     * @param describeScalingActivitiesRequest
     * @return A Java Future containing the result of the DescribeScalingActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingActivities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScalingActivitiesResponse> describeScalingActivities(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        try {

            HttpResponseHandler<DescribeScalingActivitiesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeScalingActivitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeScalingActivitiesRequest, DescribeScalingActivitiesResponse>()
                            .withMarshaller(new DescribeScalingActivitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeScalingActivitiesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more scaling activities for the specified Auto Scaling group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScalingActivitiesPublisher publisher = client.describeScalingActivitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingActivities(software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScalingActivitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingActivities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeScalingActivitiesPublisher describeScalingActivitiesPaginator(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        return new DescribeScalingActivitiesPublisher(this, applyPaginatorUserAgent(describeScalingActivitiesRequest));
    }

    /**
     * <p>
     * Describes the scaling process types for use with <a>ResumeProcesses</a> and <a>SuspendProcesses</a>.
     * </p>
     *
     * @param describeScalingProcessTypesRequest
     * @return A Java Future containing the result of the DescribeScalingProcessTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScalingProcessTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScalingProcessTypesResponse> describeScalingProcessTypes(
            DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) {
        try {

            HttpResponseHandler<DescribeScalingProcessTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeScalingProcessTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeScalingProcessTypesRequest, DescribeScalingProcessTypesResponse>()
                            .withMarshaller(new DescribeScalingProcessTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeScalingProcessTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the actions scheduled for your Auto Scaling group that haven't run. To describe the actions that have
     * already run, use <a>DescribeScalingActivities</a>.
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        try {

            HttpResponseHandler<DescribeScheduledActionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeScheduledActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeScheduledActionsRequest, DescribeScheduledActionsResponse>()
                            .withMarshaller(new DescribeScheduledActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeScheduledActionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the actions scheduled for your Auto Scaling group that haven't run. To describe the actions that have
     * already run, use <a>DescribeScalingActivities</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeScheduledActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeScheduledActionsPublisher describeScheduledActionsPaginator(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        return new DescribeScheduledActionsPublisher(this, applyPaginatorUserAgent(describeScheduledActionsRequest));
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        try {

            HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                    .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTagsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.autoscaling.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest)} operation.</b>
     * </p>
     *
     * @param describeTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeTagsPublisher describeTagsPaginator(DescribeTagsRequest describeTagsRequest) {
        return new DescribeTagsPublisher(this, applyPaginatorUserAgent(describeTagsRequest));
    }

    /**
     * <p>
     * Describes the termination policies supported by Amazon EC2 Auto Scaling.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling Which Auto
     * Scaling Instances Terminate During Scale In</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param describeTerminationPolicyTypesRequest
     * @return A Java Future containing the result of the DescribeTerminationPolicyTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DescribeTerminationPolicyTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTerminationPolicyTypesResponse> describeTerminationPolicyTypes(
            DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) {
        try {

            HttpResponseHandler<DescribeTerminationPolicyTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTerminationPolicyTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTerminationPolicyTypesRequest, DescribeTerminationPolicyTypesResponse>()
                            .withMarshaller(new DescribeTerminationPolicyTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeTerminationPolicyTypesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more instances from the specified Auto Scaling group.
     * </p>
     * <p>
     * After the instances are detached, you can manage them independent of the Auto Scaling group.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling launches instances to
     * replace the ones that are detached.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the
     * load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from
     * the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html">Detach EC2 Instances from
     * Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param detachInstancesRequest
     * @return A Java Future containing the result of the DetachInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachInstancesResponse> detachInstances(DetachInstancesRequest detachInstancesRequest) {
        try {

            HttpResponseHandler<DetachInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetachInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DetachInstancesRequest, DetachInstancesResponse>()
                    .withMarshaller(new DetachInstancesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(detachInstancesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches one or more target groups from the specified Auto Scaling group.
     * </p>
     *
     * @param detachLoadBalancerTargetGroupsRequest
     * @return A Java Future containing the result of the DetachLoadBalancerTargetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachLoadBalancerTargetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachLoadBalancerTargetGroupsResponse> detachLoadBalancerTargetGroups(
            DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) {
        try {

            HttpResponseHandler<DetachLoadBalancerTargetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetachLoadBalancerTargetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DetachLoadBalancerTargetGroupsRequest, DetachLoadBalancerTargetGroupsResponse>()
                            .withMarshaller(new DetachLoadBalancerTargetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachLoadBalancerTargetGroupsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches one or more Classic Load Balancers from the specified Auto Scaling group.
     * </p>
     * <p>
     * This operation detaches only Classic Load Balancers. If you have Application Load Balancers, use
     * <a>DetachLoadBalancerTargetGroups</a> instead.
     * </p>
     * <p>
     * When you detach a load balancer, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the load balancer using
     * <a>DescribeLoadBalancers</a>. The instances remain running.
     * </p>
     *
     * @param detachLoadBalancersRequest
     * @return A Java Future containing the result of the DetachLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DetachLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachLoadBalancersResponse> detachLoadBalancers(
            DetachLoadBalancersRequest detachLoadBalancersRequest) {
        try {

            HttpResponseHandler<DetachLoadBalancersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetachLoadBalancersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<DetachLoadBalancersRequest, DetachLoadBalancersResponse>()
                    .withMarshaller(new DetachLoadBalancersRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(detachLoadBalancersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables group metrics for the specified Auto Scaling group.
     * </p>
     *
     * @param disableMetricsCollectionRequest
     * @return A Java Future containing the result of the DisableMetricsCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.DisableMetricsCollection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableMetricsCollectionResponse> disableMetricsCollection(
            DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        try {

            HttpResponseHandler<DisableMetricsCollectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DisableMetricsCollectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<DisableMetricsCollectionRequest, DisableMetricsCollectionResponse>()
                            .withMarshaller(new DisableMetricsCollectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disableMetricsCollectionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables group metrics for the specified Auto Scaling group. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html">Monitoring Your Auto
     * Scaling Groups and Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param enableMetricsCollectionRequest
     * @return A Java Future containing the result of the EnableMetricsCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.EnableMetricsCollection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableMetricsCollectionResponse> enableMetricsCollection(
            EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        try {

            HttpResponseHandler<EnableMetricsCollectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(EnableMetricsCollectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<EnableMetricsCollectionRequest, EnableMetricsCollectionResponse>()
                            .withMarshaller(new EnableMetricsCollectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(enableMetricsCollectionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Moves the specified instances into the standby state.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily Removing
     * Instances from Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param enterStandbyRequest
     * @return A Java Future containing the result of the EnterStandby operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.EnterStandby
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnterStandbyResponse> enterStandby(EnterStandbyRequest enterStandbyRequest) {
        try {

            HttpResponseHandler<EnterStandbyResponse> responseHandler = protocolFactory
                    .createResponseHandler(EnterStandbyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<EnterStandbyRequest, EnterStandbyResponse>()
                    .withMarshaller(new EnterStandbyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(enterStandbyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Executes the specified policy.
     * </p>
     *
     * @param executePolicyRequest
     * @return A Java Future containing the result of the ExecutePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ExecutePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExecutePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ExecutePolicyResponse> executePolicy(ExecutePolicyRequest executePolicyRequest) {
        try {

            HttpResponseHandler<ExecutePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(ExecutePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ExecutePolicyRequest, ExecutePolicyResponse>()
                    .withMarshaller(new ExecutePolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(executePolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Moves the specified instances out of the standby state.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html">Temporarily Removing
     * Instances from Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param exitStandbyRequest
     * @return A Java Future containing the result of the ExitStandby operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ExitStandby
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ExitStandbyResponse> exitStandby(ExitStandbyRequest exitStandbyRequest) {
        try {

            HttpResponseHandler<ExitStandbyResponse> responseHandler = protocolFactory
                    .createResponseHandler(ExitStandbyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ExitStandbyRequest, ExitStandbyResponse>()
                    .withMarshaller(new ExitStandbyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(exitStandbyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a lifecycle hook for the specified Auto Scaling group.
     * </p>
     * <p>
     * A lifecycle hook tells Amazon EC2 Auto Scaling to perform an action on an instance that is not actively in
     * service; for example, either when the instance launches or before the instance terminates.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when
     * Amazon EC2 Auto Scaling launches or terminates instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, complete the lifecycle action.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Auto Scaling Lifecycle Hooks</a>
     * in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call
     * fails. For information about updating this limit, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     *
     * @param putLifecycleHookRequest
     * @return A Java Future containing the result of the PutLifecycleHook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutLifecycleHook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutLifecycleHook" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutLifecycleHookResponse> putLifecycleHook(PutLifecycleHookRequest putLifecycleHookRequest) {
        try {

            HttpResponseHandler<PutLifecycleHookResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutLifecycleHookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<PutLifecycleHookRequest, PutLifecycleHookResponse>()
                    .withMarshaller(new PutLifecycleHookRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putLifecycleHookRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the
     * specified topic can have messages delivered to an endpoint such as a web server or an email address.
     * </p>
     * <p>
     * This configuration overwrites any existing configuration.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html">Getting SNS Notifications
     * When Your Auto Scaling Group Scales</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     *
     * @param putNotificationConfigurationRequest
     * @return A Java Future containing the result of the PutNotificationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutNotificationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutNotificationConfigurationResponse> putNotificationConfiguration(
            PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        try {

            HttpResponseHandler<PutNotificationConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutNotificationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<PutNotificationConfigurationRequest, PutNotificationConfigurationResponse>()
                            .withMarshaller(new PutNotificationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putNotificationConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a policy for an Auto Scaling group. To update an existing policy, use the existing policy name
     * and set the parameters to change. Any existing parameter not changed in an update to an existing policy is not
     * changed in this update request.
     * </p>
     * <p>
     * If you exceed your maximum limit of step adjustments, which by default is 20 per region, the call fails. For
     * information about updating this limit, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     *
     * @param putScalingPolicyRequest
     * @return A Java Future containing the result of the PutScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        try {

            HttpResponseHandler<PutScalingPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutScalingPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<PutScalingPolicyRequest, PutScalingPolicyResponse>()
                    .withMarshaller(new PutScalingPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putScalingPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a scheduled scaling action for an Auto Scaling group. If you leave a parameter unspecified
     * when updating a scheduled scaling action, the corresponding value remains unchanged.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html">Scheduled Scaling</a> in the
     * <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param putScheduledUpdateGroupActionRequest
     * @return A Java Future containing the result of the PutScheduledUpdateGroupAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException You already have an Auto Scaling group or launch configuration with this name.
     *         </li>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.PutScheduledUpdateGroupAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutScheduledUpdateGroupActionResponse> putScheduledUpdateGroupAction(
            PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {
        try {

            HttpResponseHandler<PutScheduledUpdateGroupActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutScheduledUpdateGroupActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<PutScheduledUpdateGroupActionRequest, PutScheduledUpdateGroupActionResponse>()
                            .withMarshaller(new PutScheduledUpdateGroupActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putScheduledUpdateGroupActionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the
     * timeout by the length of time defined using <a>PutLifecycleHook</a>.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when
     * Amazon EC2 Auto Scaling launches or terminates instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, complete the lifecycle action.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
     * Lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param recordLifecycleActionHeartbeatRequest
     * @return A Java Future containing the result of the RecordLifecycleActionHeartbeat operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.RecordLifecycleActionHeartbeat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RecordLifecycleActionHeartbeatResponse> recordLifecycleActionHeartbeat(
            RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) {
        try {

            HttpResponseHandler<RecordLifecycleActionHeartbeatResponse> responseHandler = protocolFactory
                    .createResponseHandler(RecordLifecycleActionHeartbeatResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<RecordLifecycleActionHeartbeatRequest, RecordLifecycleActionHeartbeatResponse>()
                            .withMarshaller(new RecordLifecycleActionHeartbeatRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(recordLifecycleActionHeartbeatRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resumes the specified suspended automatic scaling processes, or all suspended process, for the specified Auto
     * Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and
     * Resuming Scaling Processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param resumeProcessesRequest
     * @return A Java Future containing the result of the ResumeProcesses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.ResumeProcesses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ResumeProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ResumeProcessesResponse> resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) {
        try {

            HttpResponseHandler<ResumeProcessesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResumeProcessesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<ResumeProcessesRequest, ResumeProcessesResponse>()
                    .withMarshaller(new ResumeProcessesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(resumeProcessesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the size of the specified Auto Scaling group.
     * </p>
     * <p>
     * For more information about desired capacity, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/WhatIsAutoScaling.html">What Is Amazon EC2 Auto
     * Scaling?</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param setDesiredCapacityRequest
     * @return A Java Future containing the result of the SetDesiredCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetDesiredCapacity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SetDesiredCapacityResponse> setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        try {

            HttpResponseHandler<SetDesiredCapacityResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetDesiredCapacityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<SetDesiredCapacityRequest, SetDesiredCapacityResponse>()
                    .withMarshaller(new SetDesiredCapacityRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(setDesiredCapacityRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the health status of the specified instance.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health
     * Checks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param setInstanceHealthRequest
     * @return A Java Future containing the result of the SetInstanceHealth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetInstanceHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceHealth" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SetInstanceHealthResponse> setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest) {
        try {

            HttpResponseHandler<SetInstanceHealthResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetInstanceHealthResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<SetInstanceHealthRequest, SetInstanceHealthResponse>()
                    .withMarshaller(new SetInstanceHealthRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(setInstanceHealthRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the instance protection settings of the specified instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     * >Instance Protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param setInstanceProtectionRequest
     * @return A Java Future containing the result of the SetInstanceProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You have already reached a limit for your Auto Scaling resources (for example,
     *         groups, launch configurations, or lifecycle hooks). For more information, see
     *         <a>DescribeAccountLimits</a>.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SetInstanceProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetInstanceProtectionResponse> setInstanceProtection(
            SetInstanceProtectionRequest setInstanceProtectionRequest) {
        try {

            HttpResponseHandler<SetInstanceProtectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetInstanceProtectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<SetInstanceProtectionRequest, SetInstanceProtectionResponse>()
                    .withMarshaller(new SetInstanceProtectionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(setInstanceProtectionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Suspends the specified automatic scaling processes, or all processes, for the specified Auto Scaling group.
     * </p>
     * <p>
     * If you suspend either the <code>Launch</code> or <code>Terminate</code> process types, it can prevent other
     * process types from functioning properly.
     * </p>
     * <p>
     * To resume processes that have been suspended, use <a>ResumeProcesses</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and
     * Resuming Scaling Processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     *
     * @param suspendProcessesRequest
     * @return A Java Future containing the result of the SuspendProcesses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The operation can't be performed because the resource is in use.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.SuspendProcesses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SuspendProcessesResponse> suspendProcesses(SuspendProcessesRequest suspendProcessesRequest) {
        try {

            HttpResponseHandler<SuspendProcessesResponse> responseHandler = protocolFactory
                    .createResponseHandler(SuspendProcessesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler.execute(new ClientExecutionParams<SuspendProcessesRequest, SuspendProcessesResponse>()
                    .withMarshaller(new SuspendProcessesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(suspendProcessesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Terminates the specified instance and optionally adjusts the desired group size.
     * </p>
     * <p>
     * This call simply makes a termination request. The instance is not terminated immediately.
     * </p>
     *
     * @param terminateInstanceInAutoScalingGroupRequest
     * @return A Java Future containing the result of the TerminateInstanceInAutoScalingGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.TerminateInstanceInAutoScalingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TerminateInstanceInAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TerminateInstanceInAutoScalingGroupResponse> terminateInstanceInAutoScalingGroup(
            TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) {
        try {

            HttpResponseHandler<TerminateInstanceInAutoScalingGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(TerminateInstanceInAutoScalingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<TerminateInstanceInAutoScalingGroupRequest, TerminateInstanceInAutoScalingGroupResponse>()
                            .withMarshaller(new TerminateInstanceInAutoScalingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(terminateInstanceInAutoScalingGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration for the specified Auto Scaling group.
     * </p>
     * <p>
     * The new settings take effect on any scaling activities after this call returns. Scaling activities that are
     * currently in progress aren't affected.
     * </p>
     * <p>
     * To update an Auto Scaling group with a launch configuration with <code>InstanceMonitoring</code> set to
     * <code>false</code>, you must first disable the collection of group metrics. Otherwise, you get an error. If you
     * have previously enabled the collection of group metrics, you can disable it using
     * <a>DisableMetricsCollection</a>.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify a new value for <code>MinSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MinSize</code> is larger than the current size of the group, we implicitly call
     * <a>SetDesiredCapacity</a> to set the size of the group to the new value of <code>MinSize</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MaxSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MaxSize</code> is smaller than the current size of the group, we implicitly call
     * <a>SetDesiredCapacity</a> to set the size of the group to the new value of <code>MaxSize</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * All other optional parameters are left unchanged if not specified.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateAutoScalingGroupRequest
     * @return A Java Future containing the result of the UpdateAutoScalingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScalingActivityInProgressException The operation can't be performed because there are scaling
     *         activities in progress.</li>
     *         <li>ResourceContentionException You already have a pending update to an Auto Scaling resource (for
     *         example, a group, instance, or load balancer).</li>
     *         <li>ServiceLinkedRoleFailureException The service-linked role is not yet ready for use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AutoScalingAsyncClient.UpdateAutoScalingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/UpdateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAutoScalingGroupResponse> updateAutoScalingGroup(
            UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        try {

            HttpResponseHandler<UpdateAutoScalingGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateAutoScalingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAutoScalingGroupRequest, UpdateAutoScalingGroupResponse>()
                            .withMarshaller(new UpdateAutoScalingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateAutoScalingGroupRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUse")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ScalingActivityInProgress")
                                .exceptionBuilderSupplier(ScalingActivityInProgressException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextToken")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceeded")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExists")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceContention")
                                .exceptionBuilderSupplier(ResourceContentionException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceLinkedRoleFailure")
                                .exceptionBuilderSupplier(ServiceLinkedRoleFailureException::builder).httpStatusCode(500).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(AutoScalingException::builder).build();
    }

    private <T extends AutoScalingRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
