/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a mixed instances policy for an Auto Scaling group. With mixed instances, your Auto Scaling group can
 * provision a combination of On-Demand Instances and Spot Instances across multiple instance types. For more
 * information, see <a
 * href="http://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html#asg-purchase-options">Using Multiple
 * Instance Types and Purchase Options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
 * </p>
 * <p>
 * When you create your Auto Scaling group, you can specify a launch configuration or template as a parameter for the
 * top-level object, or you can specify a mixed instances policy, but not both at the same time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MixedInstancesPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<MixedInstancesPolicy.Builder, MixedInstancesPolicy> {
    private static final SdkField<LaunchTemplate> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplate> builder(MarshallingType.SDK_POJO).getter(getter(MixedInstancesPolicy::launchTemplate))
            .setter(setter(Builder::launchTemplate)).constructor(LaunchTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<InstancesDistribution> INSTANCES_DISTRIBUTION_FIELD = SdkField
            .<InstancesDistribution> builder(MarshallingType.SDK_POJO)
            .getter(getter(MixedInstancesPolicy::instancesDistribution)).setter(setter(Builder::instancesDistribution))
            .constructor(InstancesDistribution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesDistribution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_FIELD,
            INSTANCES_DISTRIBUTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final LaunchTemplate launchTemplate;

    private final InstancesDistribution instancesDistribution;

    private MixedInstancesPolicy(BuilderImpl builder) {
        this.launchTemplate = builder.launchTemplate;
        this.instancesDistribution = builder.instancesDistribution;
    }

    /**
     * <p>
     * The launch template and overrides.
     * </p>
     * <p>
     * This parameter is required when creating an Auto Scaling group with a mixed instances policy, but is not required
     * when updating the group.
     * </p>
     * 
     * @return The launch template and overrides.</p>
     *         <p>
     *         This parameter is required when creating an Auto Scaling group with a mixed instances policy, but is not
     *         required when updating the group.
     */
    public LaunchTemplate launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * The instances distribution to use.
     * </p>
     * <p>
     * If you leave this parameter unspecified when creating the group, the default values are used.
     * </p>
     * 
     * @return The instances distribution to use. </p>
     *         <p>
     *         If you leave this parameter unspecified when creating the group, the default values are used.
     */
    public InstancesDistribution instancesDistribution() {
        return instancesDistribution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(instancesDistribution());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MixedInstancesPolicy)) {
            return false;
        }
        MixedInstancesPolicy other = (MixedInstancesPolicy) obj;
        return Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(instancesDistribution(), other.instancesDistribution());
    }

    @Override
    public String toString() {
        return ToString.builder("MixedInstancesPolicy").add("LaunchTemplate", launchTemplate())
                .add("InstancesDistribution", instancesDistribution()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "InstancesDistribution":
            return Optional.ofNullable(clazz.cast(instancesDistribution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MixedInstancesPolicy, T> g) {
        return obj -> g.apply((MixedInstancesPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MixedInstancesPolicy> {
        /**
         * <p>
         * The launch template and overrides.
         * </p>
         * <p>
         * This parameter is required when creating an Auto Scaling group with a mixed instances policy, but is not
         * required when updating the group.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template and overrides.</p>
         *        <p>
         *        This parameter is required when creating an Auto Scaling group with a mixed instances policy, but is
         *        not required when updating the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplate launchTemplate);

        /**
         * <p>
         * The launch template and overrides.
         * </p>
         * <p>
         * This parameter is required when creating an Auto Scaling group with a mixed instances policy, but is not
         * required when updating the group.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplate.Builder} avoiding the need to
         * create one manually via {@link LaunchTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #launchTemplate(LaunchTemplate)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplate)
         */
        default Builder launchTemplate(Consumer<LaunchTemplate.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplate.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The instances distribution to use.
         * </p>
         * <p>
         * If you leave this parameter unspecified when creating the group, the default values are used.
         * </p>
         * 
         * @param instancesDistribution
         *        The instances distribution to use. </p>
         *        <p>
         *        If you leave this parameter unspecified when creating the group, the default values are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesDistribution(InstancesDistribution instancesDistribution);

        /**
         * <p>
         * The instances distribution to use.
         * </p>
         * <p>
         * If you leave this parameter unspecified when creating the group, the default values are used.
         * </p>
         * This is a convenience that creates an instance of the {@link InstancesDistribution.Builder} avoiding the need
         * to create one manually via {@link InstancesDistribution#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstancesDistribution.Builder#build()} is called immediately and
         * its result is passed to {@link #instancesDistribution(InstancesDistribution)}.
         * 
         * @param instancesDistribution
         *        a consumer that will call methods on {@link InstancesDistribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instancesDistribution(InstancesDistribution)
         */
        default Builder instancesDistribution(Consumer<InstancesDistribution.Builder> instancesDistribution) {
            return instancesDistribution(InstancesDistribution.builder().applyMutation(instancesDistribution).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LaunchTemplate launchTemplate;

        private InstancesDistribution instancesDistribution;

        private BuilderImpl() {
        }

        private BuilderImpl(MixedInstancesPolicy model) {
            launchTemplate(model.launchTemplate);
            instancesDistribution(model.instancesDistribution);
        }

        public final LaunchTemplate.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplate launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplate.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final InstancesDistribution.Builder getInstancesDistribution() {
            return instancesDistribution != null ? instancesDistribution.toBuilder() : null;
        }

        @Override
        public final Builder instancesDistribution(InstancesDistribution instancesDistribution) {
            this.instancesDistribution = instancesDistribution;
            return this;
        }

        public final void setInstancesDistribution(InstancesDistribution.BuilderImpl instancesDistribution) {
            this.instancesDistribution = instancesDistribution != null ? instancesDistribution.build() : null;
        }

        @Override
        public MixedInstancesPolicy build() {
            return new MixedInstancesPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
