/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.MetricDimension;
import software.amazon.awssdk.services.autoscaling.model.MetricDimensionsCopier;
import software.amazon.awssdk.services.autoscaling.model.MetricStatistic;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomizedMetricSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomizedMetricSpecification> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomizedMetricSpecification.getter(CustomizedMetricSpecification::metricName)).setter(CustomizedMetricSpecification.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomizedMetricSpecification.getter(CustomizedMetricSpecification::namespace)).setter(CustomizedMetricSpecification.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<List<MetricDimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CustomizedMetricSpecification.getter(CustomizedMetricSpecification::dimensions)).setter(CustomizedMetricSpecification.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomizedMetricSpecification.getter(CustomizedMetricSpecification::statisticAsString)).setter(CustomizedMetricSpecification.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomizedMetricSpecification.getter(CustomizedMetricSpecification::unit)).setter(CustomizedMetricSpecification.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAMESPACE_FIELD, DIMENSIONS_FIELD, STATISTIC_FIELD, UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String namespace;
    private final List<MetricDimension> dimensions;
    private final String statistic;
    private final String unit;

    private CustomizedMetricSpecification(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.dimensions = builder.dimensions;
        this.statistic = builder.statistic;
        this.unit = builder.unit;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public List<MetricDimension> dimensions() {
        return this.dimensions;
    }

    public MetricStatistic statistic() {
        return MetricStatistic.fromValue(this.statistic);
    }

    public String statisticAsString() {
        return this.statistic;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizedMetricSpecification)) {
            return false;
        }
        CustomizedMetricSpecification other = (CustomizedMetricSpecification)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.unit(), other.unit());
    }

    public String toString() {
        return ToString.builder((String)"CustomizedMetricSpecification").add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).add("Dimensions", this.dimensions()).add("Statistic", (Object)this.statisticAsString()).add("Unit", (Object)this.unit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomizedMetricSpecification, T> g) {
        return obj -> g.apply((CustomizedMetricSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String namespace;
        private List<MetricDimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String statistic;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomizedMetricSpecification model) {
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.dimensions(model.dimensions);
            this.statistic(model.statistic);
            this.unit(model.unit);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<MetricDimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(MetricDimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<MetricDimension> dimensions) {
            this.dimensions = MetricDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(MetricDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<MetricDimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (MetricDimension)((MetricDimension.Builder)MetricDimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<MetricDimension.BuilderImpl> dimensions) {
            this.dimensions = MetricDimensionsCopier.copyFromBuilder(dimensions);
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(MetricStatistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public CustomizedMetricSpecification build() {
            return new CustomizedMetricSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomizedMetricSpecification> {
        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder dimensions(Collection<MetricDimension> var1);

        public Builder dimensions(MetricDimension ... var1);

        public Builder dimensions(Consumer<MetricDimension.Builder> ... var1);

        public Builder statistic(String var1);

        public Builder statistic(MetricStatistic var1);

        public Builder unit(String var1);
    }
}

