/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutScheduledUpdateGroupActionResponse extends AutoScalingResponse implements
        ToCopyableBuilder<BatchPutScheduledUpdateGroupActionResponse.Builder, BatchPutScheduledUpdateGroupActionResponse> {
    private static final SdkField<List<FailedScheduledUpdateGroupActionRequest>> FAILED_SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD = SdkField
            .<List<FailedScheduledUpdateGroupActionRequest>> builder(MarshallingType.LIST)
            .getter(getter(BatchPutScheduledUpdateGroupActionResponse::failedScheduledUpdateGroupActions))
            .setter(setter(Builder::failedScheduledUpdateGroupActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedScheduledUpdateGroupActions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedScheduledUpdateGroupActionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedScheduledUpdateGroupActionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD));

    private final List<FailedScheduledUpdateGroupActionRequest> failedScheduledUpdateGroupActions;

    private BatchPutScheduledUpdateGroupActionResponse(BuilderImpl builder) {
        super(builder);
        this.failedScheduledUpdateGroupActions = builder.failedScheduledUpdateGroupActions;
    }

    /**
     * <p>
     * The names of the scheduled actions that could not be created or updated, including an error message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the scheduled actions that could not be created or updated, including an error message.
     */
    public List<FailedScheduledUpdateGroupActionRequest> failedScheduledUpdateGroupActions() {
        return failedScheduledUpdateGroupActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedScheduledUpdateGroupActions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutScheduledUpdateGroupActionResponse)) {
            return false;
        }
        BatchPutScheduledUpdateGroupActionResponse other = (BatchPutScheduledUpdateGroupActionResponse) obj;
        return Objects.equals(failedScheduledUpdateGroupActions(), other.failedScheduledUpdateGroupActions());
    }

    @Override
    public String toString() {
        return ToString.builder("BatchPutScheduledUpdateGroupActionResponse")
                .add("FailedScheduledUpdateGroupActions", failedScheduledUpdateGroupActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedScheduledUpdateGroupActions":
            return Optional.ofNullable(clazz.cast(failedScheduledUpdateGroupActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutScheduledUpdateGroupActionResponse, T> g) {
        return obj -> g.apply((BatchPutScheduledUpdateGroupActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchPutScheduledUpdateGroupActionResponse> {
        /**
         * <p>
         * The names of the scheduled actions that could not be created or updated, including an error message.
         * </p>
         * 
         * @param failedScheduledUpdateGroupActions
         *        The names of the scheduled actions that could not be created or updated, including an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedScheduledUpdateGroupActions(
                Collection<FailedScheduledUpdateGroupActionRequest> failedScheduledUpdateGroupActions);

        /**
         * <p>
         * The names of the scheduled actions that could not be created or updated, including an error message.
         * </p>
         * 
         * @param failedScheduledUpdateGroupActions
         *        The names of the scheduled actions that could not be created or updated, including an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedScheduledUpdateGroupActions(FailedScheduledUpdateGroupActionRequest... failedScheduledUpdateGroupActions);

        /**
         * <p>
         * The names of the scheduled actions that could not be created or updated, including an error message.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <FailedScheduledUpdateGroupActionRequest>.Builder} avoiding the need to create one manually via {@link List
         * <FailedScheduledUpdateGroupActionRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedScheduledUpdateGroupActionRequest>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #failedScheduledUpdateGroupActions(List<FailedScheduledUpdateGroupActionRequest>)}.
         * 
         * @param failedScheduledUpdateGroupActions
         *        a consumer that will call methods on {@link List<FailedScheduledUpdateGroupActionRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedScheduledUpdateGroupActions(List<FailedScheduledUpdateGroupActionRequest>)
         */
        Builder failedScheduledUpdateGroupActions(
                Consumer<FailedScheduledUpdateGroupActionRequest.Builder>... failedScheduledUpdateGroupActions);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<FailedScheduledUpdateGroupActionRequest> failedScheduledUpdateGroupActions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutScheduledUpdateGroupActionResponse model) {
            super(model);
            failedScheduledUpdateGroupActions(model.failedScheduledUpdateGroupActions);
        }

        public final Collection<FailedScheduledUpdateGroupActionRequest.Builder> getFailedScheduledUpdateGroupActions() {
            return failedScheduledUpdateGroupActions != null ? failedScheduledUpdateGroupActions.stream()
                    .map(FailedScheduledUpdateGroupActionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedScheduledUpdateGroupActions(
                Collection<FailedScheduledUpdateGroupActionRequest> failedScheduledUpdateGroupActions) {
            this.failedScheduledUpdateGroupActions = FailedScheduledUpdateGroupActionRequestsCopier
                    .copy(failedScheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedScheduledUpdateGroupActions(
                FailedScheduledUpdateGroupActionRequest... failedScheduledUpdateGroupActions) {
            failedScheduledUpdateGroupActions(Arrays.asList(failedScheduledUpdateGroupActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedScheduledUpdateGroupActions(
                Consumer<FailedScheduledUpdateGroupActionRequest.Builder>... failedScheduledUpdateGroupActions) {
            failedScheduledUpdateGroupActions(Stream.of(failedScheduledUpdateGroupActions)
                    .map(c -> FailedScheduledUpdateGroupActionRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedScheduledUpdateGroupActions(
                Collection<FailedScheduledUpdateGroupActionRequest.BuilderImpl> failedScheduledUpdateGroupActions) {
            this.failedScheduledUpdateGroupActions = FailedScheduledUpdateGroupActionRequestsCopier
                    .copyFromBuilder(failedScheduledUpdateGroupActions);
        }

        @Override
        public BatchPutScheduledUpdateGroupActionResponse build() {
            return new BatchPutScheduledUpdateGroupActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
