/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an override for a launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateOverrides.Builder, LaunchTemplateOverrides> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchTemplateOverrides::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private LaunchTemplateOverrides(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * For information about available instance types, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
     * Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
     * </p>
     * 
     * @return The instance type. </p>
     *         <p>
     *         For information about available instance types, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
     *         >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
     */
    public String instanceType() {
        return instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateOverrides)) {
            return false;
        }
        LaunchTemplateOverrides other = (LaunchTemplateOverrides) obj;
        return Objects.equals(instanceType(), other.instanceType());
    }

    @Override
    public String toString() {
        return ToString.builder("LaunchTemplateOverrides").add("InstanceType", instanceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateOverrides, T> g) {
        return obj -> g.apply((LaunchTemplateOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateOverrides> {
        /**
         * <p>
         * The instance type.
         * </p>
         * <p>
         * For information about available instance types, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         * >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
         * </p>
         * 
         * @param instanceType
         *        The instance type. </p>
         *        <p>
         *        For information about available instance types, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         *        >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateOverrides model) {
            instanceType(model.instanceType);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public LaunchTemplateOverrides build() {
            return new LaunchTemplateOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
