/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instances distribution for an Auto Scaling group with <a>MixedInstancesPolicy</a>.
 * </p>
 * <p>
 * The instances distribution specifies the distribution of On-Demand Instances and Spot Instances, the maximum price to
 * pay for Spot Instances, and how the Auto Scaling group allocates instance types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstancesDistribution implements SdkPojo, Serializable,
        ToCopyableBuilder<InstancesDistribution.Builder, InstancesDistribution> {
    private static final SdkField<String> ON_DEMAND_ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstancesDistribution::onDemandAllocationStrategy))
            .setter(setter(Builder::onDemandAllocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandAllocationStrategy").build())
            .build();

    private static final SdkField<Integer> ON_DEMAND_BASE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstancesDistribution::onDemandBaseCapacity)).setter(setter(Builder::onDemandBaseCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandBaseCapacity").build())
            .build();

    private static final SdkField<Integer> ON_DEMAND_PERCENTAGE_ABOVE_BASE_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstancesDistribution::onDemandPercentageAboveBaseCapacity))
            .setter(setter(Builder::onDemandPercentageAboveBaseCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OnDemandPercentageAboveBaseCapacity").build()).build();

    private static final SdkField<String> SPOT_ALLOCATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstancesDistribution::spotAllocationStrategy)).setter(setter(Builder::spotAllocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotAllocationStrategy").build())
            .build();

    private static final SdkField<Integer> SPOT_INSTANCE_POOLS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstancesDistribution::spotInstancePools)).setter(setter(Builder::spotInstancePools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstancePools").build()).build();

    private static final SdkField<String> SPOT_MAX_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstancesDistribution::spotMaxPrice)).setter(setter(Builder::spotMaxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotMaxPrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ON_DEMAND_ALLOCATION_STRATEGY_FIELD, ON_DEMAND_BASE_CAPACITY_FIELD, ON_DEMAND_PERCENTAGE_ABOVE_BASE_CAPACITY_FIELD,
            SPOT_ALLOCATION_STRATEGY_FIELD, SPOT_INSTANCE_POOLS_FIELD, SPOT_MAX_PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String onDemandAllocationStrategy;

    private final Integer onDemandBaseCapacity;

    private final Integer onDemandPercentageAboveBaseCapacity;

    private final String spotAllocationStrategy;

    private final Integer spotInstancePools;

    private final String spotMaxPrice;

    private InstancesDistribution(BuilderImpl builder) {
        this.onDemandAllocationStrategy = builder.onDemandAllocationStrategy;
        this.onDemandBaseCapacity = builder.onDemandBaseCapacity;
        this.onDemandPercentageAboveBaseCapacity = builder.onDemandPercentageAboveBaseCapacity;
        this.spotAllocationStrategy = builder.spotAllocationStrategy;
        this.spotInstancePools = builder.spotInstancePools;
        this.spotMaxPrice = builder.spotMaxPrice;
    }

    /**
     * <p>
     * Indicates how to allocate instance types to fulfill On-Demand capacity.
     * </p>
     * <p>
     * The only valid value is <code>prioritized</code>, which is also the default value. This strategy uses the order
     * of instance types in the <b>Overrides</b> array of <a>LaunchTemplate</a> to define the launch priority of each
     * instance type. The first instance type in the array is prioritized higher than the last. If all your On-Demand
     * capacity cannot be fulfilled using your highest priority instance, then the Auto Scaling groups launches the
     * remaining capacity using the second priority instance type, and so on.
     * </p>
     * 
     * @return Indicates how to allocate instance types to fulfill On-Demand capacity. </p>
     *         <p>
     *         The only valid value is <code>prioritized</code>, which is also the default value. This strategy uses the
     *         order of instance types in the <b>Overrides</b> array of <a>LaunchTemplate</a> to define the launch
     *         priority of each instance type. The first instance type in the array is prioritized higher than the last.
     *         If all your On-Demand capacity cannot be fulfilled using your highest priority instance, then the Auto
     *         Scaling groups launches the remaining capacity using the second priority instance type, and so on.
     */
    public String onDemandAllocationStrategy() {
        return onDemandAllocationStrategy;
    }

    /**
     * <p>
     * The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base
     * portion is provisioned first as your group scales.
     * </p>
     * <p>
     * The default value is 0. If you leave this parameter set to 0, On-Demand Instances are launched as a percentage of
     * the Auto Scaling group's desired capacity, per the <b>OnDemandPercentageAboveBaseCapacity</b> setting.
     * </p>
     * 
     * @return The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances.
     *         This base portion is provisioned first as your group scales.</p>
     *         <p>
     *         The default value is 0. If you leave this parameter set to 0, On-Demand Instances are launched as a
     *         percentage of the Auto Scaling group's desired capacity, per the
     *         <b>OnDemandPercentageAboveBaseCapacity</b> setting.
     */
    public Integer onDemandBaseCapacity() {
        return onDemandBaseCapacity;
    }

    /**
     * <p>
     * Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond
     * <b>OnDemandBaseCapacity</b>.
     * </p>
     * <p>
     * The range is 0–100. The default value is 100. If you leave this parameter set to 100, the percentages are 100%
     * for On-Demand Instances and 0% for Spot Instances.
     * </p>
     * 
     * @return Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond
     *         <b>OnDemandBaseCapacity</b>. </p>
     *         <p>
     *         The range is 0–100. The default value is 100. If you leave this parameter set to 100, the percentages are
     *         100% for On-Demand Instances and 0% for Spot Instances.
     */
    public Integer onDemandPercentageAboveBaseCapacity() {
        return onDemandPercentageAboveBaseCapacity;
    }

    /**
     * <p>
     * Indicates how to allocate Spot capacity across Spot pools.
     * </p>
     * <p>
     * The only valid value is <code>lowest-price</code>, which is also the default value. The Auto Scaling group
     * selects the cheapest Spot pools and evenly allocates your Spot capacity across the number of Spot pools that you
     * specify.
     * </p>
     * 
     * @return Indicates how to allocate Spot capacity across Spot pools.</p>
     *         <p>
     *         The only valid value is <code>lowest-price</code>, which is also the default value. The Auto Scaling
     *         group selects the cheapest Spot pools and evenly allocates your Spot capacity across the number of Spot
     *         pools that you specify.
     */
    public String spotAllocationStrategy() {
        return spotAllocationStrategy;
    }

    /**
     * <p>
     * The number of Spot pools to use to allocate your Spot capacity. The Spot pools are determined from the different
     * instance types in the <b>Overrides</b> array of <a>LaunchTemplate</a>.
     * </p>
     * <p>
     * The range is 1–20 and the default is 2.
     * </p>
     * 
     * @return The number of Spot pools to use to allocate your Spot capacity. The Spot pools are determined from the
     *         different instance types in the <b>Overrides</b> array of <a>LaunchTemplate</a>. </p>
     *         <p>
     *         The range is 1–20 and the default is 2.
     */
    public Integer spotInstancePools() {
        return spotInstancePools;
    }

    /**
     * <p>
     * The maximum price per unit hour that you are willing to pay for a Spot Instance. If you leave this value blank
     * (which is the default), the maximum Spot price is set at the On-Demand price.
     * </p>
     * 
     * @return The maximum price per unit hour that you are willing to pay for a Spot Instance. If you leave this value
     *         blank (which is the default), the maximum Spot price is set at the On-Demand price.
     */
    public String spotMaxPrice() {
        return spotMaxPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(onDemandAllocationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandBaseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandPercentageAboveBaseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(spotAllocationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstancePools());
        hashCode = 31 * hashCode + Objects.hashCode(spotMaxPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancesDistribution)) {
            return false;
        }
        InstancesDistribution other = (InstancesDistribution) obj;
        return Objects.equals(onDemandAllocationStrategy(), other.onDemandAllocationStrategy())
                && Objects.equals(onDemandBaseCapacity(), other.onDemandBaseCapacity())
                && Objects.equals(onDemandPercentageAboveBaseCapacity(), other.onDemandPercentageAboveBaseCapacity())
                && Objects.equals(spotAllocationStrategy(), other.spotAllocationStrategy())
                && Objects.equals(spotInstancePools(), other.spotInstancePools())
                && Objects.equals(spotMaxPrice(), other.spotMaxPrice());
    }

    @Override
    public String toString() {
        return ToString.builder("InstancesDistribution").add("OnDemandAllocationStrategy", onDemandAllocationStrategy())
                .add("OnDemandBaseCapacity", onDemandBaseCapacity())
                .add("OnDemandPercentageAboveBaseCapacity", onDemandPercentageAboveBaseCapacity())
                .add("SpotAllocationStrategy", spotAllocationStrategy()).add("SpotInstancePools", spotInstancePools())
                .add("SpotMaxPrice", spotMaxPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OnDemandAllocationStrategy":
            return Optional.ofNullable(clazz.cast(onDemandAllocationStrategy()));
        case "OnDemandBaseCapacity":
            return Optional.ofNullable(clazz.cast(onDemandBaseCapacity()));
        case "OnDemandPercentageAboveBaseCapacity":
            return Optional.ofNullable(clazz.cast(onDemandPercentageAboveBaseCapacity()));
        case "SpotAllocationStrategy":
            return Optional.ofNullable(clazz.cast(spotAllocationStrategy()));
        case "SpotInstancePools":
            return Optional.ofNullable(clazz.cast(spotInstancePools()));
        case "SpotMaxPrice":
            return Optional.ofNullable(clazz.cast(spotMaxPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstancesDistribution, T> g) {
        return obj -> g.apply((InstancesDistribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstancesDistribution> {
        /**
         * <p>
         * Indicates how to allocate instance types to fulfill On-Demand capacity.
         * </p>
         * <p>
         * The only valid value is <code>prioritized</code>, which is also the default value. This strategy uses the
         * order of instance types in the <b>Overrides</b> array of <a>LaunchTemplate</a> to define the launch priority
         * of each instance type. The first instance type in the array is prioritized higher than the last. If all your
         * On-Demand capacity cannot be fulfilled using your highest priority instance, then the Auto Scaling groups
         * launches the remaining capacity using the second priority instance type, and so on.
         * </p>
         * 
         * @param onDemandAllocationStrategy
         *        Indicates how to allocate instance types to fulfill On-Demand capacity. </p>
         *        <p>
         *        The only valid value is <code>prioritized</code>, which is also the default value. This strategy uses
         *        the order of instance types in the <b>Overrides</b> array of <a>LaunchTemplate</a> to define the
         *        launch priority of each instance type. The first instance type in the array is prioritized higher than
         *        the last. If all your On-Demand capacity cannot be fulfilled using your highest priority instance,
         *        then the Auto Scaling groups launches the remaining capacity using the second priority instance type,
         *        and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandAllocationStrategy(String onDemandAllocationStrategy);

        /**
         * <p>
         * The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This
         * base portion is provisioned first as your group scales.
         * </p>
         * <p>
         * The default value is 0. If you leave this parameter set to 0, On-Demand Instances are launched as a
         * percentage of the Auto Scaling group's desired capacity, per the <b>OnDemandPercentageAboveBaseCapacity</b>
         * setting.
         * </p>
         * 
         * @param onDemandBaseCapacity
         *        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances.
         *        This base portion is provisioned first as your group scales.</p>
         *        <p>
         *        The default value is 0. If you leave this parameter set to 0, On-Demand Instances are launched as a
         *        percentage of the Auto Scaling group's desired capacity, per the
         *        <b>OnDemandPercentageAboveBaseCapacity</b> setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandBaseCapacity(Integer onDemandBaseCapacity);

        /**
         * <p>
         * Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond
         * <b>OnDemandBaseCapacity</b>.
         * </p>
         * <p>
         * The range is 0–100. The default value is 100. If you leave this parameter set to 100, the percentages are
         * 100% for On-Demand Instances and 0% for Spot Instances.
         * </p>
         * 
         * @param onDemandPercentageAboveBaseCapacity
         *        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond
         *        <b>OnDemandBaseCapacity</b>. </p>
         *        <p>
         *        The range is 0–100. The default value is 100. If you leave this parameter set to 100, the percentages
         *        are 100% for On-Demand Instances and 0% for Spot Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity);

        /**
         * <p>
         * Indicates how to allocate Spot capacity across Spot pools.
         * </p>
         * <p>
         * The only valid value is <code>lowest-price</code>, which is also the default value. The Auto Scaling group
         * selects the cheapest Spot pools and evenly allocates your Spot capacity across the number of Spot pools that
         * you specify.
         * </p>
         * 
         * @param spotAllocationStrategy
         *        Indicates how to allocate Spot capacity across Spot pools.</p>
         *        <p>
         *        The only valid value is <code>lowest-price</code>, which is also the default value. The Auto Scaling
         *        group selects the cheapest Spot pools and evenly allocates your Spot capacity across the number of
         *        Spot pools that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotAllocationStrategy(String spotAllocationStrategy);

        /**
         * <p>
         * The number of Spot pools to use to allocate your Spot capacity. The Spot pools are determined from the
         * different instance types in the <b>Overrides</b> array of <a>LaunchTemplate</a>.
         * </p>
         * <p>
         * The range is 1–20 and the default is 2.
         * </p>
         * 
         * @param spotInstancePools
         *        The number of Spot pools to use to allocate your Spot capacity. The Spot pools are determined from the
         *        different instance types in the <b>Overrides</b> array of <a>LaunchTemplate</a>. </p>
         *        <p>
         *        The range is 1–20 and the default is 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstancePools(Integer spotInstancePools);

        /**
         * <p>
         * The maximum price per unit hour that you are willing to pay for a Spot Instance. If you leave this value
         * blank (which is the default), the maximum Spot price is set at the On-Demand price.
         * </p>
         * 
         * @param spotMaxPrice
         *        The maximum price per unit hour that you are willing to pay for a Spot Instance. If you leave this
         *        value blank (which is the default), the maximum Spot price is set at the On-Demand price.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotMaxPrice(String spotMaxPrice);
    }

    static final class BuilderImpl implements Builder {
        private String onDemandAllocationStrategy;

        private Integer onDemandBaseCapacity;

        private Integer onDemandPercentageAboveBaseCapacity;

        private String spotAllocationStrategy;

        private Integer spotInstancePools;

        private String spotMaxPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancesDistribution model) {
            onDemandAllocationStrategy(model.onDemandAllocationStrategy);
            onDemandBaseCapacity(model.onDemandBaseCapacity);
            onDemandPercentageAboveBaseCapacity(model.onDemandPercentageAboveBaseCapacity);
            spotAllocationStrategy(model.spotAllocationStrategy);
            spotInstancePools(model.spotInstancePools);
            spotMaxPrice(model.spotMaxPrice);
        }

        public final String getOnDemandAllocationStrategy() {
            return onDemandAllocationStrategy;
        }

        @Override
        public final Builder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
            return this;
        }

        public final void setOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
        }

        public final Integer getOnDemandBaseCapacity() {
            return onDemandBaseCapacity;
        }

        @Override
        public final Builder onDemandBaseCapacity(Integer onDemandBaseCapacity) {
            this.onDemandBaseCapacity = onDemandBaseCapacity;
            return this;
        }

        public final void setOnDemandBaseCapacity(Integer onDemandBaseCapacity) {
            this.onDemandBaseCapacity = onDemandBaseCapacity;
        }

        public final Integer getOnDemandPercentageAboveBaseCapacity() {
            return onDemandPercentageAboveBaseCapacity;
        }

        @Override
        public final Builder onDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity) {
            this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
            return this;
        }

        public final void setOnDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity) {
            this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
        }

        public final String getSpotAllocationStrategy() {
            return spotAllocationStrategy;
        }

        @Override
        public final Builder spotAllocationStrategy(String spotAllocationStrategy) {
            this.spotAllocationStrategy = spotAllocationStrategy;
            return this;
        }

        public final void setSpotAllocationStrategy(String spotAllocationStrategy) {
            this.spotAllocationStrategy = spotAllocationStrategy;
        }

        public final Integer getSpotInstancePools() {
            return spotInstancePools;
        }

        @Override
        public final Builder spotInstancePools(Integer spotInstancePools) {
            this.spotInstancePools = spotInstancePools;
            return this;
        }

        public final void setSpotInstancePools(Integer spotInstancePools) {
            this.spotInstancePools = spotInstancePools;
        }

        public final String getSpotMaxPrice() {
            return spotMaxPrice;
        }

        @Override
        public final Builder spotMaxPrice(String spotMaxPrice) {
            this.spotMaxPrice = spotMaxPrice;
            return this;
        }

        public final void setSpotMaxPrice(String spotMaxPrice) {
            this.spotMaxPrice = spotMaxPrice;
        }

        @Override
        public InstancesDistribution build() {
            return new InstancesDistribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
