/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePoliciesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribePoliciesResponse.Builder, DescribePoliciesResponse> {
    private static final SdkField<List<ScalingPolicy>> SCALING_POLICIES_FIELD = SdkField
            .<List<ScalingPolicy>> builder(MarshallingType.LIST)
            .getter(getter(DescribePoliciesResponse::scalingPolicies))
            .setter(setter(Builder::scalingPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalingPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalingPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribePoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_POLICIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ScalingPolicy> scalingPolicies;

    private final String nextToken;

    private DescribePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.scalingPolicies = builder.scalingPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scaling policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The scaling policies.
     */
    public List<ScalingPolicy> scalingPolicies() {
        return scalingPolicies;
    }

    /**
     * <p>
     * A string that indicates that the response contains more items than can be returned in a single response. To
     * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set
     * of items. This value is null when there are no more items to return.
     * </p>
     * 
     * @return A string that indicates that the response contains more items than can be returned in a single response.
     *         To receive additional items, specify this string for the <code>NextToken</code> value when requesting the
     *         next set of items. This value is null when there are no more items to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalingPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoliciesResponse)) {
            return false;
        }
        DescribePoliciesResponse other = (DescribePoliciesResponse) obj;
        return Objects.equals(scalingPolicies(), other.scalingPolicies()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePoliciesResponse").add("ScalingPolicies", scalingPolicies())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPolicies":
            return Optional.ofNullable(clazz.cast(scalingPolicies()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePoliciesResponse, T> g) {
        return obj -> g.apply((DescribePoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePoliciesResponse> {
        /**
         * <p>
         * The scaling policies.
         * </p>
         * 
         * @param scalingPolicies
         *        The scaling policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies);

        /**
         * <p>
         * The scaling policies.
         * </p>
         * 
         * @param scalingPolicies
         *        The scaling policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(ScalingPolicy... scalingPolicies);

        /**
         * <p>
         * The scaling policies.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScalingPolicy>.Builder} avoiding the need
         * to create one manually via {@link List<ScalingPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScalingPolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingPolicies(List<ScalingPolicy>)}.
         * 
         * @param scalingPolicies
         *        a consumer that will call methods on {@link List<ScalingPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingPolicies(List<ScalingPolicy>)
         */
        Builder scalingPolicies(Consumer<ScalingPolicy.Builder>... scalingPolicies);

        /**
         * <p>
         * A string that indicates that the response contains more items than can be returned in a single response. To
         * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next
         * set of items. This value is null when there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        A string that indicates that the response contains more items than can be returned in a single
         *        response. To receive additional items, specify this string for the <code>NextToken</code> value when
         *        requesting the next set of items. This value is null when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<ScalingPolicy> scalingPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePoliciesResponse model) {
            super(model);
            scalingPolicies(model.scalingPolicies);
            nextToken(model.nextToken);
        }

        public final Collection<ScalingPolicy.Builder> getScalingPolicies() {
            return scalingPolicies != null ? scalingPolicies.stream().map(ScalingPolicy::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy... scalingPolicies) {
            scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<ScalingPolicy.Builder>... scalingPolicies) {
            scalingPolicies(Stream.of(scalingPolicies).map(c -> ScalingPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copyFromBuilder(scalingPolicies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePoliciesResponse build() {
            return new DescribePoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
