/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.autoscaling.model.EnabledMetric;
import software.amazon.awssdk.services.autoscaling.model.EnabledMetricsCopier;
import software.amazon.awssdk.services.autoscaling.model.Instance;
import software.amazon.awssdk.services.autoscaling.model.InstancesCopier;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.MixedInstancesPolicy;
import software.amazon.awssdk.services.autoscaling.model.SuspendedProcess;
import software.amazon.awssdk.services.autoscaling.model.SuspendedProcessesCopier;
import software.amazon.awssdk.services.autoscaling.model.TagDescription;
import software.amazon.awssdk.services.autoscaling.model.TagDescriptionListCopier;
import software.amazon.awssdk.services.autoscaling.model.TargetGroupARNsCopier;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroup> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroup.getter(AutoScalingGroup::autoScalingGroupName)).setter(AutoScalingGroup.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroup.getter(AutoScalingGroup::autoScalingGroupARN)).setter(AutoScalingGroup.setter(Builder::autoScalingGroupARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupARN").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroup.getter(AutoScalingGroup::launchConfigurationName)).setter(AutoScalingGroup.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AutoScalingGroup.getter(AutoScalingGroup::launchTemplate)).setter(AutoScalingGroup.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()}).build();
    private static final SdkField<MixedInstancesPolicy> MIXED_INSTANCES_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AutoScalingGroup.getter(AutoScalingGroup::mixedInstancesPolicy)).setter(AutoScalingGroup.setter(Builder::mixedInstancesPolicy)).constructor(MixedInstancesPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AutoScalingGroup.getter(AutoScalingGroup::minSize)).setter(AutoScalingGroup.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AutoScalingGroup.getter(AutoScalingGroup::maxSize)).setter(AutoScalingGroup.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()}).build();
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AutoScalingGroup.getter(AutoScalingGroup::desiredCapacity)).setter(AutoScalingGroup.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()}).build();
    private static final SdkField<Integer> DEFAULT_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AutoScalingGroup.getter(AutoScalingGroup::defaultCooldown)).setter(AutoScalingGroup.setter(Builder::defaultCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCooldown").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroup.getter(AutoScalingGroup::availabilityZones)).setter(AutoScalingGroup.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroup.getter(AutoScalingGroup::loadBalancerNames)).setter(AutoScalingGroup.setter(Builder::loadBalancerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_GROUP_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroup.getter(AutoScalingGroup::targetGroupARNs)).setter(AutoScalingGroup.setter(Builder::targetGroupARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroup.getter(AutoScalingGroup::healthCheckType)).setter(AutoScalingGroup.setter(Builder::healthCheckType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AutoScalingGroup.getter(AutoScalingGroup::healthCheckGracePeriod)).setter(AutoScalingGroup.setter(Builder::healthCheckGracePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build()}).build();
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroup.getter(AutoScalingGroup::instances)).setter(AutoScalingGroup.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutoScalingGroup.getter(AutoScalingGroup::createdTime)).setter(AutoScalingGroup.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<List<SuspendedProcess>> SUSPENDED_PROCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroup.getter(AutoScalingGroup::suspendedProcesses)).setter(AutoScalingGroup.setter(Builder::suspendedProcesses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedProcesses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuspendedProcess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroup.getter(AutoScalingGroup::placementGroup)).setter(AutoScalingGroup.setter(Builder::placementGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").build()}).build();
    private static final SdkField<String> VPC_ZONE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroup.getter(AutoScalingGroup::vpcZoneIdentifier)).setter(AutoScalingGroup.setter(Builder::vpcZoneIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCZoneIdentifier").build()}).build();
    private static final SdkField<List<EnabledMetric>> ENABLED_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroup.getter(AutoScalingGroup::enabledMetrics)).setter(AutoScalingGroup.setter(Builder::enabledMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnabledMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroup.getter(AutoScalingGroup::status)).setter(AutoScalingGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<TagDescription>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroup.getter(AutoScalingGroup::tags)).setter(AutoScalingGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TERMINATION_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroup.getter(AutoScalingGroup::terminationPolicies)).setter(AutoScalingGroup.setter(Builder::terminationPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AutoScalingGroup.getter(AutoScalingGroup::newInstancesProtectedFromScaleIn)).setter(AutoScalingGroup.setter(Builder::newInstancesProtectedFromScaleIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInstancesProtectedFromScaleIn").build()}).build();
    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroup.getter(AutoScalingGroup::serviceLinkedRoleARN)).setter(AutoScalingGroup.setter(Builder::serviceLinkedRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, AUTO_SCALING_GROUP_ARN_FIELD, LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, MIXED_INSTANCES_POLICY_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD, DEFAULT_COOLDOWN_FIELD, AVAILABILITY_ZONES_FIELD, LOAD_BALANCER_NAMES_FIELD, TARGET_GROUP_AR_NS_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD, INSTANCES_FIELD, CREATED_TIME_FIELD, SUSPENDED_PROCESSES_FIELD, PLACEMENT_GROUP_FIELD, VPC_ZONE_IDENTIFIER_FIELD, ENABLED_METRICS_FIELD, STATUS_FIELD, TAGS_FIELD, TERMINATION_POLICIES_FIELD, NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoScalingGroupName;
    private final String autoScalingGroupARN;
    private final String launchConfigurationName;
    private final LaunchTemplateSpecification launchTemplate;
    private final MixedInstancesPolicy mixedInstancesPolicy;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredCapacity;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final List<String> loadBalancerNames;
    private final List<String> targetGroupARNs;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final List<Instance> instances;
    private final Instant createdTime;
    private final List<SuspendedProcess> suspendedProcesses;
    private final String placementGroup;
    private final String vpcZoneIdentifier;
    private final List<EnabledMetric> enabledMetrics;
    private final String status;
    private final List<TagDescription> tags;
    private final List<String> terminationPolicies;
    private final Boolean newInstancesProtectedFromScaleIn;
    private final String serviceLinkedRoleARN;

    private AutoScalingGroup(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.autoScalingGroupARN = builder.autoScalingGroupARN;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.instances = builder.instances;
        this.createdTime = builder.createdTime;
        this.suspendedProcesses = builder.suspendedProcesses;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.enabledMetrics = builder.enabledMetrics;
        this.status = builder.status;
        this.tags = builder.tags;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.serviceLinkedRoleARN = builder.serviceLinkedRoleARN;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String autoScalingGroupARN() {
        return this.autoScalingGroupARN;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public MixedInstancesPolicy mixedInstancesPolicy() {
        return this.mixedInstancesPolicy;
    }

    public Integer minSize() {
        return this.minSize;
    }

    public Integer maxSize() {
        return this.maxSize;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Integer defaultCooldown() {
        return this.defaultCooldown;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public List<String> targetGroupARNs() {
        return this.targetGroupARNs;
    }

    public String healthCheckType() {
        return this.healthCheckType;
    }

    public Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public List<SuspendedProcess> suspendedProcesses() {
        return this.suspendedProcesses;
    }

    public String placementGroup() {
        return this.placementGroup;
    }

    public String vpcZoneIdentifier() {
        return this.vpcZoneIdentifier;
    }

    public List<EnabledMetric> enabledMetrics() {
        return this.enabledMetrics;
    }

    public String status() {
        return this.status;
    }

    public List<TagDescription> tags() {
        return this.tags;
    }

    public List<String> terminationPolicies() {
        return this.terminationPolicies;
    }

    public Boolean newInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public String serviceLinkedRoleARN() {
        return this.serviceLinkedRoleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupARNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspendedProcesses());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLinkedRoleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup)obj;
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.autoScalingGroupARN(), other.autoScalingGroupARN()) && Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.mixedInstancesPolicy(), other.mixedInstancesPolicy()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.defaultCooldown(), other.defaultCooldown()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.loadBalancerNames(), other.loadBalancerNames()) && Objects.equals(this.targetGroupARNs(), other.targetGroupARNs()) && Objects.equals(this.healthCheckType(), other.healthCheckType()) && Objects.equals(this.healthCheckGracePeriod(), other.healthCheckGracePeriod()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.suspendedProcesses(), other.suspendedProcesses()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.vpcZoneIdentifier(), other.vpcZoneIdentifier()) && Objects.equals(this.enabledMetrics(), other.enabledMetrics()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.terminationPolicies(), other.terminationPolicies()) && Objects.equals(this.newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn()) && Objects.equals(this.serviceLinkedRoleARN(), other.serviceLinkedRoleARN());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingGroup").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("AutoScalingGroupARN", (Object)this.autoScalingGroupARN()).add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("LaunchTemplate", (Object)this.launchTemplate()).add("MixedInstancesPolicy", (Object)this.mixedInstancesPolicy()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("DesiredCapacity", (Object)this.desiredCapacity()).add("DefaultCooldown", (Object)this.defaultCooldown()).add("AvailabilityZones", this.availabilityZones()).add("LoadBalancerNames", this.loadBalancerNames()).add("TargetGroupARNs", this.targetGroupARNs()).add("HealthCheckType", (Object)this.healthCheckType()).add("HealthCheckGracePeriod", (Object)this.healthCheckGracePeriod()).add("Instances", this.instances()).add("CreatedTime", (Object)this.createdTime()).add("SuspendedProcesses", this.suspendedProcesses()).add("PlacementGroup", (Object)this.placementGroup()).add("VPCZoneIdentifier", (Object)this.vpcZoneIdentifier()).add("EnabledMetrics", this.enabledMetrics()).add("Status", (Object)this.status()).add("Tags", this.tags()).add("TerminationPolicies", this.terminationPolicies()).add("NewInstancesProtectedFromScaleIn", (Object)this.newInstancesProtectedFromScaleIn()).add("ServiceLinkedRoleARN", (Object)this.serviceLinkedRoleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "AutoScalingGroupARN": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupARN()));
            }
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "MixedInstancesPolicy": {
                return Optional.ofNullable(clazz.cast(this.mixedInstancesPolicy()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "DesiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
            case "DefaultCooldown": {
                return Optional.ofNullable(clazz.cast(this.defaultCooldown()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "LoadBalancerNames": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerNames()));
            }
            case "TargetGroupARNs": {
                return Optional.ofNullable(clazz.cast(this.targetGroupARNs()));
            }
            case "HealthCheckType": {
                return Optional.ofNullable(clazz.cast(this.healthCheckType()));
            }
            case "HealthCheckGracePeriod": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriod()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "SuspendedProcesses": {
                return Optional.ofNullable(clazz.cast(this.suspendedProcesses()));
            }
            case "PlacementGroup": {
                return Optional.ofNullable(clazz.cast(this.placementGroup()));
            }
            case "VPCZoneIdentifier": {
                return Optional.ofNullable(clazz.cast(this.vpcZoneIdentifier()));
            }
            case "EnabledMetrics": {
                return Optional.ofNullable(clazz.cast(this.enabledMetrics()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TerminationPolicies": {
                return Optional.ofNullable(clazz.cast(this.terminationPolicies()));
            }
            case "NewInstancesProtectedFromScaleIn": {
                return Optional.ofNullable(clazz.cast(this.newInstancesProtectedFromScaleIn()));
            }
            case "ServiceLinkedRoleARN": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkedRoleARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroup, T> g) {
        return obj -> g.apply((AutoScalingGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String autoScalingGroupARN;
        private String launchConfigurationName;
        private LaunchTemplateSpecification launchTemplate;
        private MixedInstancesPolicy mixedInstancesPolicy;
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredCapacity;
        private Integer defaultCooldown;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetGroupARNs = DefaultSdkAutoConstructList.getInstance();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private List<SuspendedProcess> suspendedProcesses = DefaultSdkAutoConstructList.getInstance();
        private String placementGroup;
        private String vpcZoneIdentifier;
        private List<EnabledMetric> enabledMetrics = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private List<TagDescription> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> terminationPolicies = DefaultSdkAutoConstructList.getInstance();
        private Boolean newInstancesProtectedFromScaleIn;
        private String serviceLinkedRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.autoScalingGroupARN(model.autoScalingGroupARN);
            this.launchConfigurationName(model.launchConfigurationName);
            this.launchTemplate(model.launchTemplate);
            this.mixedInstancesPolicy(model.mixedInstancesPolicy);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.desiredCapacity(model.desiredCapacity);
            this.defaultCooldown(model.defaultCooldown);
            this.availabilityZones(model.availabilityZones);
            this.loadBalancerNames(model.loadBalancerNames);
            this.targetGroupARNs(model.targetGroupARNs);
            this.healthCheckType(model.healthCheckType);
            this.healthCheckGracePeriod(model.healthCheckGracePeriod);
            this.instances(model.instances);
            this.createdTime(model.createdTime);
            this.suspendedProcesses(model.suspendedProcesses);
            this.placementGroup(model.placementGroup);
            this.vpcZoneIdentifier(model.vpcZoneIdentifier);
            this.enabledMetrics(model.enabledMetrics);
            this.status(model.status);
            this.tags(model.tags);
            this.terminationPolicies(model.terminationPolicies);
            this.newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            this.serviceLinkedRoleARN(model.serviceLinkedRoleARN);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getAutoScalingGroupARN() {
            return this.autoScalingGroupARN;
        }

        @Override
        public final Builder autoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
            return this;
        }

        public final void setAutoScalingGroupARN(String autoScalingGroupARN) {
            this.autoScalingGroupARN = autoScalingGroupARN;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final MixedInstancesPolicy.Builder getMixedInstancesPolicy() {
            return this.mixedInstancesPolicy != null ? this.mixedInstancesPolicy.toBuilder() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final void setMixedInstancesPolicy(MixedInstancesPolicy.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return this.defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final Collection<String> getTargetGroupARNs() {
            return this.targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String ... targetGroupARNs) {
            this.targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<SuspendedProcess.Builder> getSuspendedProcesses() {
            return this.suspendedProcesses != null ? (Collection)this.suspendedProcesses.stream().map(SuspendedProcess::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
            this.suspendedProcesses = SuspendedProcessesCopier.copy(suspendedProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedProcesses(SuspendedProcess ... suspendedProcesses) {
            this.suspendedProcesses(Arrays.asList(suspendedProcesses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suspendedProcesses(Consumer<SuspendedProcess.Builder> ... suspendedProcesses) {
            this.suspendedProcesses(Stream.of(suspendedProcesses).map(c -> (SuspendedProcess)((SuspendedProcess.Builder)SuspendedProcess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuspendedProcesses(Collection<SuspendedProcess.BuilderImpl> suspendedProcesses) {
            this.suspendedProcesses = SuspendedProcessesCopier.copyFromBuilder(suspendedProcesses);
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVpcZoneIdentifier() {
            return this.vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<EnabledMetric.Builder> getEnabledMetrics() {
            return this.enabledMetrics != null ? (Collection)this.enabledMetrics.stream().map(EnabledMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enabledMetrics(Collection<EnabledMetric> enabledMetrics) {
            this.enabledMetrics = EnabledMetricsCopier.copy(enabledMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMetrics(EnabledMetric ... enabledMetrics) {
            this.enabledMetrics(Arrays.asList(enabledMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMetrics(Consumer<EnabledMetric.Builder> ... enabledMetrics) {
            this.enabledMetrics(Stream.of(enabledMetrics).map(c -> (EnabledMetric)((EnabledMetric.Builder)EnabledMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnabledMetrics(Collection<EnabledMetric.BuilderImpl> enabledMetrics) {
            this.enabledMetrics = EnabledMetricsCopier.copyFromBuilder(enabledMetrics);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<TagDescription.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(TagDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagDescription> tags) {
            this.tags = TagDescriptionListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagDescription ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagDescription.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagDescription)((TagDescription.Builder)TagDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagDescription.BuilderImpl> tags) {
            this.tags = TagDescriptionListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String ... terminationPolicies) {
            this.terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        public final String getServiceLinkedRoleARN() {
            return this.serviceLinkedRoleARN;
        }

        @Override
        public final Builder serviceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
            return this;
        }

        public final void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        }

        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroup> {
        public Builder autoScalingGroupName(String var1);

        public Builder autoScalingGroupARN(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder mixedInstancesPolicy(MixedInstancesPolicy var1);

        default public Builder mixedInstancesPolicy(Consumer<MixedInstancesPolicy.Builder> mixedInstancesPolicy) {
            return this.mixedInstancesPolicy((MixedInstancesPolicy)((MixedInstancesPolicy.Builder)MixedInstancesPolicy.builder().applyMutation(mixedInstancesPolicy)).build());
        }

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredCapacity(Integer var1);

        public Builder defaultCooldown(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder targetGroupARNs(Collection<String> var1);

        public Builder targetGroupARNs(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder createdTime(Instant var1);

        public Builder suspendedProcesses(Collection<SuspendedProcess> var1);

        public Builder suspendedProcesses(SuspendedProcess ... var1);

        public Builder suspendedProcesses(Consumer<SuspendedProcess.Builder> ... var1);

        public Builder placementGroup(String var1);

        public Builder vpcZoneIdentifier(String var1);

        public Builder enabledMetrics(Collection<EnabledMetric> var1);

        public Builder enabledMetrics(EnabledMetric ... var1);

        public Builder enabledMetrics(Consumer<EnabledMetric.Builder> ... var1);

        public Builder status(String var1);

        public Builder tags(Collection<TagDescription> var1);

        public Builder tags(TagDescription ... var1);

        public Builder tags(Consumer<TagDescription.Builder> ... var1);

        public Builder terminationPolicies(Collection<String> var1);

        public Builder terminationPolicies(String ... var1);

        public Builder newInstancesProtectedFromScaleIn(Boolean var1);

        public Builder serviceLinkedRoleARN(String var1);
    }
}

