/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a Classic Load Balancer.
 * </p>
 * <p>
 * If you specify a load balancer when creating the Auto Scaling group, the state of the load balancer is
 * <code>InService</code>.
 * </p>
 * <p>
 * If you attach a load balancer to an existing Auto Scaling group, the initial state is <code>Adding</code>. The state
 * transitions to <code>Added</code> after all instances in the group are registered with the load balancer. If Elastic
 * Load Balancing health checks are enabled for the load balancer, the state transitions to <code>InService</code> after
 * at least one instance in the group passes the health check. If EC2 health checks are enabled instead, the load
 * balancer remains in the <code>Added</code> state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerState implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerState.Builder, LoadBalancerState> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancerState::loadBalancerName)).setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancerState::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String loadBalancerName;

    private final String state;

    private LoadBalancerState(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * One of the following load balancer states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Adding</code> - The instances in the group are being registered with the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Added</code> - All instances in the group are registered with the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InService</code> - At least one instance in the group passed an ELB health check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removing</code> - The instances in the group are being deregistered from the load balancer. If connection
     * draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the
     * instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removed</code> - All instances in the group are deregistered from the load balancer.
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following load balancer states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Adding</code> - The instances in the group are being registered with the load balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Added</code> - All instances in the group are registered with the load balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InService</code> - At least one instance in the group passed an ELB health check.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removing</code> - The instances in the group are being deregistered from the load balancer. If
     *         connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
     *         deregistering the instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removed</code> - All instances in the group are deregistered from the load balancer.
     *         </p>
     *         </li>
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerState)) {
            return false;
        }
        LoadBalancerState other = (LoadBalancerState) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoadBalancerState").add("LoadBalancerName", loadBalancerName()).add("State", state()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerState, T> g) {
        return obj -> g.apply((LoadBalancerState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerState> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * One of the following load balancer states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Adding</code> - The instances in the group are being registered with the load balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Added</code> - All instances in the group are registered with the load balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InService</code> - At least one instance in the group passed an ELB health check.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removing</code> - The instances in the group are being deregistered from the load balancer. If
         * connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
         * deregistering the instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removed</code> - All instances in the group are deregistered from the load balancer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        One of the following load balancer states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Adding</code> - The instances in the group are being registered with the load balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Added</code> - All instances in the group are registered with the load balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InService</code> - At least one instance in the group passed an ELB health check.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removing</code> - The instances in the group are being deregistered from the load balancer. If
         *        connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
         *        deregistering the instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removed</code> - All instances in the group are deregistered from the load balancer.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String loadBalancerName;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerState model) {
            loadBalancerName(model.loadBalancerName);
            state(model.state);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public LoadBalancerState build() {
            return new LoadBalancerState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
