/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordLifecycleActionHeartbeatRequest extends AutoScalingRequest implements
        ToCopyableBuilder<RecordLifecycleActionHeartbeatRequest.Builder, RecordLifecycleActionHeartbeatRequest> {
    private static final SdkField<String> LIFECYCLE_HOOK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecordLifecycleActionHeartbeatRequest::lifecycleHookName)).setter(setter(Builder::lifecycleHookName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookName").build()).build();

    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecordLifecycleActionHeartbeatRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> LIFECYCLE_ACTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecordLifecycleActionHeartbeatRequest::lifecycleActionToken))
            .setter(setter(Builder::lifecycleActionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleActionToken").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecordLifecycleActionHeartbeatRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOK_NAME_FIELD,
            AUTO_SCALING_GROUP_NAME_FIELD, LIFECYCLE_ACTION_TOKEN_FIELD, INSTANCE_ID_FIELD));

    private final String lifecycleHookName;

    private final String autoScalingGroupName;

    private final String lifecycleActionToken;

    private final String instanceId;

    private RecordLifecycleActionHeartbeatRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleActionToken = builder.lifecycleActionToken;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The name of the lifecycle hook.
     * </p>
     * 
     * @return The name of the lifecycle hook.
     */
    public String lifecycleHookName() {
        return lifecycleHookName;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling
     * sends this token to the notification target that you specified when you created the lifecycle hook.
     * </p>
     * 
     * @return A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto
     *         Scaling sends this token to the notification target that you specified when you created the lifecycle
     *         hook.
     */
    public String lifecycleActionToken() {
        return lifecycleActionToken;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleActionToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordLifecycleActionHeartbeatRequest)) {
            return false;
        }
        RecordLifecycleActionHeartbeatRequest other = (RecordLifecycleActionHeartbeatRequest) obj;
        return Objects.equals(lifecycleHookName(), other.lifecycleHookName())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(lifecycleActionToken(), other.lifecycleActionToken())
                && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecordLifecycleActionHeartbeatRequest").add("LifecycleHookName", lifecycleHookName())
                .add("AutoScalingGroupName", autoScalingGroupName()).add("LifecycleActionToken", lifecycleActionToken())
                .add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleHookName":
            return Optional.ofNullable(clazz.cast(lifecycleHookName()));
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "LifecycleActionToken":
            return Optional.ofNullable(clazz.cast(lifecycleActionToken()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordLifecycleActionHeartbeatRequest, T> g) {
        return obj -> g.apply((RecordLifecycleActionHeartbeatRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RecordLifecycleActionHeartbeatRequest> {
        /**
         * <p>
         * The name of the lifecycle hook.
         * </p>
         * 
         * @param lifecycleHookName
         *        The name of the lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookName(String lifecycleHookName);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto
         * Scaling sends this token to the notification target that you specified when you created the lifecycle hook.
         * </p>
         * 
         * @param lifecycleActionToken
         *        A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2
         *        Auto Scaling sends this token to the notification target that you specified when you created the
         *        lifecycle hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleActionToken(String lifecycleActionToken);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String lifecycleHookName;

        private String autoScalingGroupName;

        private String lifecycleActionToken;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordLifecycleActionHeartbeatRequest model) {
            super(model);
            lifecycleHookName(model.lifecycleHookName);
            autoScalingGroupName(model.autoScalingGroupName);
            lifecycleActionToken(model.lifecycleActionToken);
            instanceId(model.instanceId);
        }

        public final String getLifecycleHookName() {
            return lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleActionToken() {
            return lifecycleActionToken;
        }

        @Override
        public final Builder lifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
            return this;
        }

        public final void setLifecycleActionToken(String lifecycleActionToken) {
            this.lifecycleActionToken = lifecycleActionToken;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RecordLifecycleActionHeartbeatRequest build() {
            return new RecordLifecycleActionHeartbeatRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
