/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachInstancesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DetachInstancesRequest.Builder, DetachInstancesRequest> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DetachInstancesRequest::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetachInstancesRequest::autoScalingGroupName)).setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<Boolean> SHOULD_DECREMENT_DESIRED_CAPACITY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DetachInstancesRequest::shouldDecrementDesiredCapacity))
            .setter(setter(Builder::shouldDecrementDesiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShouldDecrementDesiredCapacity")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD,
            AUTO_SCALING_GROUP_NAME_FIELD, SHOULD_DECREMENT_DESIRED_CAPACITY_FIELD));

    private final List<String> instanceIds;

    private final String autoScalingGroupName;

    private final Boolean shouldDecrementDesiredCapacity;

    private DetachInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.shouldDecrementDesiredCapacity = builder.shouldDecrementDesiredCapacity;
    }

    /**
     * <p>
     * The IDs of the instances. You can specify up to 20 instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the instances. You can specify up to 20 instances.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances
     * detached.
     * </p>
     * 
     * @return Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances
     *         detached.
     */
    public Boolean shouldDecrementDesiredCapacity() {
        return shouldDecrementDesiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(shouldDecrementDesiredCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachInstancesRequest)) {
            return false;
        }
        DetachInstancesRequest other = (DetachInstancesRequest) obj;
        return Objects.equals(instanceIds(), other.instanceIds())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(shouldDecrementDesiredCapacity(), other.shouldDecrementDesiredCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetachInstancesRequest").add("InstanceIds", instanceIds())
                .add("AutoScalingGroupName", autoScalingGroupName())
                .add("ShouldDecrementDesiredCapacity", shouldDecrementDesiredCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "ShouldDecrementDesiredCapacity":
            return Optional.ofNullable(clazz.cast(shouldDecrementDesiredCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachInstancesRequest, T> g) {
        return obj -> g.apply((DetachInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetachInstancesRequest> {
        /**
         * <p>
         * The IDs of the instances. You can specify up to 20 instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances. You can specify up to 20 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The IDs of the instances. You can specify up to 20 instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances. You can specify up to 20 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances
         * detached.
         * </p>
         * 
         * @param shouldDecrementDesiredCapacity
         *        Indicates whether the Auto Scaling group decrements the desired capacity value by the number of
         *        instances detached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private String autoScalingGroupName;

        private Boolean shouldDecrementDesiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachInstancesRequest model) {
            super(model);
            instanceIds(model.instanceIds);
            autoScalingGroupName(model.autoScalingGroupName);
            shouldDecrementDesiredCapacity(model.shouldDecrementDesiredCapacity);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Boolean getShouldDecrementDesiredCapacity() {
            return shouldDecrementDesiredCapacity;
        }

        @Override
        public final Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
            return this;
        }

        public final void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachInstancesRequest build() {
            return new DetachInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
