/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutScalingPolicyRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutScalingPolicyRequest.Builder, PutScalingPolicyRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::autoScalingGroupName)).setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::policyType)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<String> ADJUSTMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::adjustmentType)).setter(setter(Builder::adjustmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentType").build()).build();

    private static final SdkField<Integer> MIN_ADJUSTMENT_STEP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScalingPolicyRequest::minAdjustmentStep)).setter(setter(Builder::minAdjustmentStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentStep").build()).build();

    private static final SdkField<Integer> MIN_ADJUSTMENT_MAGNITUDE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScalingPolicyRequest::minAdjustmentMagnitude)).setter(setter(Builder::minAdjustmentMagnitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentMagnitude").build())
            .build();

    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScalingPolicyRequest::scalingAdjustment)).setter(setter(Builder::scalingAdjustment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()).build();

    private static final SdkField<Integer> COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScalingPolicyRequest::cooldown)).setter(setter(Builder::cooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cooldown").build()).build();

    private static final SdkField<String> METRIC_AGGREGATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScalingPolicyRequest::metricAggregationType)).setter(setter(Builder::metricAggregationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAggregationType").build())
            .build();

    private static final SdkField<List<StepAdjustment>> STEP_ADJUSTMENTS_FIELD = SdkField
            .<List<StepAdjustment>> builder(MarshallingType.LIST)
            .getter(getter(PutScalingPolicyRequest::stepAdjustments))
            .setter(setter(Builder::stepAdjustments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepAdjustments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepAdjustment> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepAdjustment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> ESTIMATED_INSTANCE_WARMUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScalingPolicyRequest::estimatedInstanceWarmup)).setter(setter(Builder::estimatedInstanceWarmup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedInstanceWarmup").build())
            .build();

    private static final SdkField<TargetTrackingConfiguration> TARGET_TRACKING_CONFIGURATION_FIELD = SdkField
            .<TargetTrackingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutScalingPolicyRequest::targetTrackingConfiguration))
            .setter(setter(Builder::targetTrackingConfiguration))
            .constructor(TargetTrackingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            POLICY_NAME_FIELD, POLICY_TYPE_FIELD, ADJUSTMENT_TYPE_FIELD, MIN_ADJUSTMENT_STEP_FIELD,
            MIN_ADJUSTMENT_MAGNITUDE_FIELD, SCALING_ADJUSTMENT_FIELD, COOLDOWN_FIELD, METRIC_AGGREGATION_TYPE_FIELD,
            STEP_ADJUSTMENTS_FIELD, ESTIMATED_INSTANCE_WARMUP_FIELD, TARGET_TRACKING_CONFIGURATION_FIELD));

    private final String autoScalingGroupName;

    private final String policyName;

    private final String policyType;

    private final String adjustmentType;

    private final Integer minAdjustmentStep;

    private final Integer minAdjustmentMagnitude;

    private final Integer scalingAdjustment;

    private final Integer cooldown;

    private final String metricAggregationType;

    private final List<StepAdjustment> stepAdjustments;

    private final Integer estimatedInstanceWarmup;

    private final TargetTrackingConfiguration targetTrackingConfiguration;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.metricAggregationType = builder.metricAggregationType;
        this.stepAdjustments = builder.stepAdjustments;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and
     * <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as
     * <code>SimpleScaling</code>.
     * </p>
     * 
     * @return The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and
     *         <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as
     *         <code>SimpleScaling</code>.
     */
    public String policyType() {
        return policyType;
    }

    /**
     * <p>
     * Specifies whether the <code>ScalingAdjustment</code> parameter is an absolute number or a percentage of the
     * current capacity. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     * <code>PercentChangeInCapacity</code>.
     * </p>
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
     * >Scaling Adjustment Types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the <code>ScalingAdjustment</code> parameter is an absolute number or a percentage of
     *         the current capacity. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     *         <code>PercentChangeInCapacity</code>.</p>
     *         <p>
     *         Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
     *         >Scaling Adjustment Types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public String adjustmentType() {
        return adjustmentType;
    }

    /**
     * <p>
     * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     * </p>
     * 
     * @return Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     */
    public Integer minAdjustmentStep() {
        return minAdjustmentStep;
    }

    /**
     * <p>
     * The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
     * <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto
     * Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
     * </p>
     * <p>
     * This property replaces the <code>MinAdjustmentStep</code> property. For example, suppose that you create a step
     * scaling policy to scale out an Auto Scaling group by 25 percent and you specify a
     * <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25
     * percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto
     * Scaling scales out the group by 2 instances.
     * </p>
     * <p>
     * Valid only if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
     * </p>
     * 
     * @return The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
     *         <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the
     *         Auto Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>
     *         .</p>
     *         <p>
     *         This property replaces the <code>MinAdjustmentStep</code> property. For example, suppose that you create
     *         a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a
     *         <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is
     *         performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of
     *         2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
     *         </p>
     *         <p>
     *         Valid only if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
     */
    public Integer minAdjustmentMagnitude() {
        return minAdjustmentMagnitude;
    }

    /**
     * <p>
     * The amount by which a simple scaling policy scales the Auto Scaling group in response to an alarm breach. The
     * adjustment is based on the value that you specified in the <code>AdjustmentType</code> parameter (either an
     * absolute number or a percentage). A positive value adds to the current capacity and a negative value subtracts
     * from the current capacity. For exact capacity, you must specify a positive value.
     * </p>
     * <p>
     * Conditional: If you specify <code>SimpleScaling</code> for the policy type, you must specify this parameter. (Not
     * used with any other policy type.)
     * </p>
     * 
     * @return The amount by which a simple scaling policy scales the Auto Scaling group in response to an alarm breach.
     *         The adjustment is based on the value that you specified in the <code>AdjustmentType</code> parameter
     *         (either an absolute number or a percentage). A positive value adds to the current capacity and a negative
     *         value subtracts from the current capacity. For exact capacity, you must specify a positive value.</p>
     *         <p>
     *         Conditional: If you specify <code>SimpleScaling</code> for the policy type, you must specify this
     *         parameter. (Not used with any other policy type.)
     */
    public Integer scalingAdjustment() {
        return scalingAdjustment;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scaling activity completes before any further dynamic scaling activities
     * can start. If this parameter is not specified, the default cooldown period for the group applies.
     * </p>
     * <p>
     * Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling Cooldowns</a> in the <i>Amazon
     * EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scaling activity completes before any further dynamic scaling
     *         activities can start. If this parameter is not specified, the default cooldown period for the group
     *         applies.</p>
     *         <p>
     *         Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling Cooldowns</a> in the
     *         <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public Integer cooldown() {
        return cooldown;
    }

    /**
     * <p>
     * The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>,
     * and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.
     * </p>
     * <p>
     * Valid only if the policy type is <code>StepScaling</code>.
     * </p>
     * 
     * @return The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as
     *         <code>Average</code>.</p>
     *         <p>
     *         Valid only if the policy type is <code>StepScaling</code>.
     */
    public String metricAggregationType() {
        return metricAggregationType;
    }

    /**
     * <p>
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * </p>
     * <p>
     * Conditional: If you specify <code>StepScaling</code> for the policy type, you must specify this parameter. (Not
     * used with any other policy type.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
     *         <p>
     *         Conditional: If you specify <code>StepScaling</code> for the policy type, you must specify this
     *         parameter. (Not used with any other policy type.)
     */
    public List<StepAdjustment> stepAdjustments() {
        return stepAdjustments;
    }

    /**
     * <p>
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. The
     * default is to use the value specified for the default cooldown period for the group.
     * </p>
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> or <code>TargetTrackingScaling</code>.
     * </p>
     * 
     * @return The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     *         The default is to use the value specified for the default cooldown period for the group.</p>
     *         <p>
     *         Valid only if the policy type is <code>StepScaling</code> or <code>TargetTrackingScaling</code>.
     */
    public Integer estimatedInstanceWarmup() {
        return estimatedInstanceWarmup;
    }

    /**
     * <p>
     * A target tracking scaling policy. Includes support for predefined or customized metrics.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
     * >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     * </p>
     * <p>
     * Conditional: If you specify <code>TargetTrackingScaling</code> for the policy type, you must specify this
     * parameter. (Not used with any other policy type.)
     * </p>
     * 
     * @return A target tracking scaling policy. Includes support for predefined or customized metrics.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
     *         >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
     *         </p>
     *         <p>
     *         Conditional: If you specify <code>TargetTrackingScaling</code> for the policy type, you must specify this
     *         parameter. (Not used with any other policy type.)
     */
    public TargetTrackingConfiguration targetTrackingConfiguration() {
        return targetTrackingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyType());
        hashCode = 31 * hashCode + Objects.hashCode(adjustmentType());
        hashCode = 31 * hashCode + Objects.hashCode(minAdjustmentStep());
        hashCode = 31 * hashCode + Objects.hashCode(minAdjustmentMagnitude());
        hashCode = 31 * hashCode + Objects.hashCode(scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(cooldown());
        hashCode = 31 * hashCode + Objects.hashCode(metricAggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(stepAdjustments());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(targetTrackingConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(policyType(), other.policyType())
                && Objects.equals(adjustmentType(), other.adjustmentType())
                && Objects.equals(minAdjustmentStep(), other.minAdjustmentStep())
                && Objects.equals(minAdjustmentMagnitude(), other.minAdjustmentMagnitude())
                && Objects.equals(scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(cooldown(), other.cooldown())
                && Objects.equals(metricAggregationType(), other.metricAggregationType())
                && Objects.equals(stepAdjustments(), other.stepAdjustments())
                && Objects.equals(estimatedInstanceWarmup(), other.estimatedInstanceWarmup())
                && Objects.equals(targetTrackingConfiguration(), other.targetTrackingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutScalingPolicyRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("PolicyName", policyName()).add("PolicyType", policyType()).add("AdjustmentType", adjustmentType())
                .add("MinAdjustmentStep", minAdjustmentStep()).add("MinAdjustmentMagnitude", minAdjustmentMagnitude())
                .add("ScalingAdjustment", scalingAdjustment()).add("Cooldown", cooldown())
                .add("MetricAggregationType", metricAggregationType()).add("StepAdjustments", stepAdjustments())
                .add("EstimatedInstanceWarmup", estimatedInstanceWarmup())
                .add("TargetTrackingConfiguration", targetTrackingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyType()));
        case "AdjustmentType":
            return Optional.ofNullable(clazz.cast(adjustmentType()));
        case "MinAdjustmentStep":
            return Optional.ofNullable(clazz.cast(minAdjustmentStep()));
        case "MinAdjustmentMagnitude":
            return Optional.ofNullable(clazz.cast(minAdjustmentMagnitude()));
        case "ScalingAdjustment":
            return Optional.ofNullable(clazz.cast(scalingAdjustment()));
        case "Cooldown":
            return Optional.ofNullable(clazz.cast(cooldown()));
        case "MetricAggregationType":
            return Optional.ofNullable(clazz.cast(metricAggregationType()));
        case "StepAdjustments":
            return Optional.ofNullable(clazz.cast(stepAdjustments()));
        case "EstimatedInstanceWarmup":
            return Optional.ofNullable(clazz.cast(estimatedInstanceWarmup()));
        case "TargetTrackingConfiguration":
            return Optional.ofNullable(clazz.cast(targetTrackingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutScalingPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutScalingPolicyRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and
         * <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as
         * <code>SimpleScaling</code>.
         * </p>
         * 
         * @param policyType
         *        The policy type. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, and
         *        <code>TargetTrackingScaling</code>. If the policy type is null, the value is treated as
         *        <code>SimpleScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * Specifies whether the <code>ScalingAdjustment</code> parameter is an absolute number or a percentage of the
         * current capacity. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
         * <code>PercentChangeInCapacity</code>.
         * </p>
         * <p>
         * Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
         * >Scaling Adjustment Types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param adjustmentType
         *        Specifies whether the <code>ScalingAdjustment</code> parameter is an absolute number or a percentage
         *        of the current capacity. The valid values are <code>ChangeInCapacity</code>,
         *        <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
         *        <p>
         *        Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment"
         *        >Scaling Adjustment Types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentType(String adjustmentType);

        /**
         * <p>
         * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * </p>
         * 
         * @param minAdjustmentStep
         *        Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentStep(Integer minAdjustmentStep);

        /**
         * <p>
         * The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
         * <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto
         * Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
         * </p>
         * <p>
         * This property replaces the <code>MinAdjustmentStep</code> property. For example, suppose that you create a
         * step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a
         * <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed,
         * 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2
         * Auto Scaling scales out the group by 2 instances.
         * </p>
         * <p>
         * Valid only if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
         * </p>
         * 
         * @param minAdjustmentMagnitude
         *        The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
         *        <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of
         *        the Auto Scaling group by at least this many instances. Otherwise, the error is
         *        <code>ValidationError</code>.</p>
         *        <p>
         *        This property replaces the <code>MinAdjustmentStep</code> property. For example, suppose that you
         *        create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a
         *        <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is
         *        performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code>
         *        of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
         *        </p>
         *        <p>
         *        Valid only if the policy type is <code>SimpleScaling</code> or <code>StepScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude);

        /**
         * <p>
         * The amount by which a simple scaling policy scales the Auto Scaling group in response to an alarm breach. The
         * adjustment is based on the value that you specified in the <code>AdjustmentType</code> parameter (either an
         * absolute number or a percentage). A positive value adds to the current capacity and a negative value
         * subtracts from the current capacity. For exact capacity, you must specify a positive value.
         * </p>
         * <p>
         * Conditional: If you specify <code>SimpleScaling</code> for the policy type, you must specify this parameter.
         * (Not used with any other policy type.)
         * </p>
         * 
         * @param scalingAdjustment
         *        The amount by which a simple scaling policy scales the Auto Scaling group in response to an alarm
         *        breach. The adjustment is based on the value that you specified in the <code>AdjustmentType</code>
         *        parameter (either an absolute number or a percentage). A positive value adds to the current capacity
         *        and a negative value subtracts from the current capacity. For exact capacity, you must specify a
         *        positive value.</p>
         *        <p>
         *        Conditional: If you specify <code>SimpleScaling</code> for the policy type, you must specify this
         *        parameter. (Not used with any other policy type.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingAdjustment(Integer scalingAdjustment);

        /**
         * <p>
         * The amount of time, in seconds, after a scaling activity completes before any further dynamic scaling
         * activities can start. If this parameter is not specified, the default cooldown period for the group applies.
         * </p>
         * <p>
         * Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling Cooldowns</a> in the
         * <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param cooldown
         *        The amount of time, in seconds, after a scaling activity completes before any further dynamic scaling
         *        activities can start. If this parameter is not specified, the default cooldown period for the group
         *        applies.</p>
         *        <p>
         *        Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling Cooldowns</a> in
         *        the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cooldown(Integer cooldown);

        /**
         * <p>
         * The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
         * <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as
         * <code>Average</code>.
         * </p>
         * <p>
         * Valid only if the policy type is <code>StepScaling</code>.
         * </p>
         * 
         * @param metricAggregationType
         *        The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
         *        <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated
         *        as <code>Average</code>.</p>
         *        <p>
         *        Valid only if the policy type is <code>StepScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAggregationType(String metricAggregationType);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * Conditional: If you specify <code>StepScaling</code> for the policy type, you must specify this parameter.
         * (Not used with any other policy type.)
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
         *        <p>
         *        Conditional: If you specify <code>StepScaling</code> for the policy type, you must specify this
         *        parameter. (Not used with any other policy type.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * Conditional: If you specify <code>StepScaling</code> for the policy type, you must specify this parameter.
         * (Not used with any other policy type.)
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
         *        <p>
         *        Conditional: If you specify <code>StepScaling</code> for the policy type, you must specify this
         *        parameter. (Not used with any other policy type.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(StepAdjustment... stepAdjustments);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * Conditional: If you specify <code>StepScaling</code> for the policy type, you must specify this parameter.
         * (Not used with any other policy type.)
         * </p>
         * This is a convenience that creates an instance of the {@link List<StepAdjustment>.Builder} avoiding the need
         * to create one manually via {@link List<StepAdjustment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StepAdjustment>.Builder#build()} is called immediately and
         * its result is passed to {@link #stepAdjustments(List<StepAdjustment>)}.
         * 
         * @param stepAdjustments
         *        a consumer that will call methods on {@link List<StepAdjustment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepAdjustments(List<StepAdjustment>)
         */
        Builder stepAdjustments(Consumer<StepAdjustment.Builder>... stepAdjustments);

        /**
         * <p>
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. The
         * default is to use the value specified for the default cooldown period for the group.
         * </p>
         * <p>
         * Valid only if the policy type is <code>StepScaling</code> or <code>TargetTrackingScaling</code>.
         * </p>
         * 
         * @param estimatedInstanceWarmup
         *        The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch
         *        metrics. The default is to use the value specified for the default cooldown period for the group.</p>
         *        <p>
         *        Valid only if the policy type is <code>StepScaling</code> or <code>TargetTrackingScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup);

        /**
         * <p>
         * A target tracking scaling policy. Includes support for predefined or customized metrics.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
         * >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         * </p>
         * <p>
         * Conditional: If you specify <code>TargetTrackingScaling</code> for the policy type, you must specify this
         * parameter. (Not used with any other policy type.)
         * </p>
         * 
         * @param targetTrackingConfiguration
         *        A target tracking scaling policy. Includes support for predefined or customized metrics.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
         *        >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         *        </p>
         *        <p>
         *        Conditional: If you specify <code>TargetTrackingScaling</code> for the policy type, you must specify
         *        this parameter. (Not used with any other policy type.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration);

        /**
         * <p>
         * A target tracking scaling policy. Includes support for predefined or customized metrics.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html"
         * >TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.
         * </p>
         * <p>
         * Conditional: If you specify <code>TargetTrackingScaling</code> for the policy type, you must specify this
         * parameter. (Not used with any other policy type.)
         * </p>
         * This is a convenience that creates an instance of the {@link TargetTrackingConfiguration.Builder} avoiding
         * the need to create one manually via {@link TargetTrackingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetTrackingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetTrackingConfiguration(TargetTrackingConfiguration)}.
         * 
         * @param targetTrackingConfiguration
         *        a consumer that will call methods on {@link TargetTrackingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingConfiguration(TargetTrackingConfiguration)
         */
        default Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return targetTrackingConfiguration(TargetTrackingConfiguration.builder().applyMutation(targetTrackingConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private String policyType;

        private String adjustmentType;

        private Integer minAdjustmentStep;

        private Integer minAdjustmentMagnitude;

        private Integer scalingAdjustment;

        private Integer cooldown;

        private String metricAggregationType;

        private List<StepAdjustment> stepAdjustments = DefaultSdkAutoConstructList.getInstance();

        private Integer estimatedInstanceWarmup;

        private TargetTrackingConfiguration targetTrackingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            policyName(model.policyName);
            policyType(model.policyType);
            adjustmentType(model.adjustmentType);
            minAdjustmentStep(model.minAdjustmentStep);
            minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            scalingAdjustment(model.scalingAdjustment);
            cooldown(model.cooldown);
            metricAggregationType(model.metricAggregationType);
            stepAdjustments(model.stepAdjustments);
            estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            targetTrackingConfiguration(model.targetTrackingConfiguration);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyType() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getAdjustmentType() {
            return adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Integer getMinAdjustmentStep() {
            return minAdjustmentStep;
        }

        @Override
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        public final Integer getScalingAdjustment() {
            return scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCooldown() {
            return cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        public final String getMetricAggregationType() {
            return metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        public final Collection<StepAdjustment.Builder> getStepAdjustments() {
            return stepAdjustments != null ? stepAdjustments.stream().map(StepAdjustment::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment... stepAdjustments) {
            stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(Consumer<StepAdjustment.Builder>... stepAdjustments) {
            stepAdjustments(Stream.of(stepAdjustments).map(c -> StepAdjustment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        public final Integer getEstimatedInstanceWarmup() {
            return estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return targetTrackingConfiguration != null ? targetTrackingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
