/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutScheduledUpdateGroupActionRequest extends AutoScalingRequest implements
        ToCopyableBuilder<PutScheduledUpdateGroupActionRequest.Builder, PutScheduledUpdateGroupActionRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScheduledUpdateGroupActionRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScheduledUpdateGroupActionRequest::scheduledActionName))
            .setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build())
            .build();

    private static final SdkField<Instant> TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PutScheduledUpdateGroupActionRequest::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PutScheduledUpdateGroupActionRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PutScheduledUpdateGroupActionRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> RECURRENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutScheduledUpdateGroupActionRequest::recurrence)).setter(setter(Builder::recurrence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScheduledUpdateGroupActionRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScheduledUpdateGroupActionRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutScheduledUpdateGroupActionRequest::desiredCapacity)).setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            SCHEDULED_ACTION_NAME_FIELD, TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, RECURRENCE_FIELD, MIN_SIZE_FIELD,
            MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD));

    private final String autoScalingGroupName;

    private final String scheduledActionName;

    private final Instant time;

    private final Instant startTime;

    private final Instant endTime;

    private final String recurrence;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private PutScheduledUpdateGroupActionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionName = builder.scheduledActionName;
        this.time = builder.time;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recurrence = builder.recurrence;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of this scaling action.
     * </p>
     * 
     * @return The name of this scaling action.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * This parameter is no longer used.
     * </p>
     * 
     * @return This parameter is no longer used.
     */
    public Instant time() {
        return time;
    }

    /**
     * <p>
     * The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for
     * example, <code>"2019-06-01T00:00:00Z"</code>).
     * </p>
     * <p>
     * If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at
     * this time, and then performs the action based on the specified recurrence.
     * </p>
     * <p>
     * If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
     * </p>
     * 
     * @return The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes
     *         (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
     *         <p>
     *         If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the
     *         action at this time, and then performs the action based on the specified recurrence.
     *         </p>
     *         <p>
     *         If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time for the recurring schedule to end. Amazon EC2 Auto Scaling does not perform the action after
     * this time.
     * </p>
     * 
     * @return The date and time for the recurring schedule to end. Amazon EC2 Auto Scaling does not perform the action
     *         after this time.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The recurring schedule for this action, in Unix cron syntax format. This format consists of five fields separated
     * by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for
     * example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a
     * href="http://crontab.org">Crontab</a>.
     * </p>
     * <p>
     * When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the
     * boundaries of when the recurring action starts and stops.
     * </p>
     * 
     * @return The recurring schedule for this action, in Unix cron syntax format. This format consists of five fields
     *         separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must
     *         be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see
     *         <a href="http://crontab.org">Crontab</a>.</p>
     *         <p>
     *         When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they
     *         form the boundaries of when the recurring action starts and stops.
     */
    public String recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The minimum number of instances in the Auto Scaling group.
     * </p>
     * 
     * @return The minimum number of instances in the Auto Scaling group.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum number of instances in the Auto Scaling group.
     * </p>
     * 
     * @return The maximum number of instances in the Auto Scaling group.
     */
    public Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The number of EC2 instances that should be running in the Auto Scaling group.
     * </p>
     * 
     * @return The number of EC2 instances that should be running in the Auto Scaling group.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScheduledUpdateGroupActionRequest)) {
            return false;
        }
        PutScheduledUpdateGroupActionRequest other = (PutScheduledUpdateGroupActionRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(scheduledActionName(), other.scheduledActionName()) && Objects.equals(time(), other.time())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(recurrence(), other.recurrence()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(desiredCapacity(), other.desiredCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutScheduledUpdateGroupActionRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("ScheduledActionName", scheduledActionName()).add("Time", time()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Recurrence", recurrence()).add("MinSize", minSize()).add("MaxSize", maxSize())
                .add("DesiredCapacity", desiredCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "ScheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutScheduledUpdateGroupActionRequest, T> g) {
        return obj -> g.apply((PutScheduledUpdateGroupActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutScheduledUpdateGroupActionRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of this scaling action.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of this scaling action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * This parameter is no longer used.
         * </p>
         * 
         * @param time
         *        This parameter is no longer used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for
         * example, <code>"2019-06-01T00:00:00Z"</code>).
         * </p>
         * <p>
         * If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the
         * action at this time, and then performs the action based on the specified recurrence.
         * </p>
         * <p>
         * If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
         * </p>
         * 
         * @param startTime
         *        The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in
         *        quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
         *        <p>
         *        If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs
         *        the action at this time, and then performs the action based on the specified recurrence.
         *        </p>
         *        <p>
         *        If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time for the recurring schedule to end. Amazon EC2 Auto Scaling does not perform the action
         * after this time.
         * </p>
         * 
         * @param endTime
         *        The date and time for the recurring schedule to end. Amazon EC2 Auto Scaling does not perform the
         *        action after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The recurring schedule for this action, in Unix cron syntax format. This format consists of five fields
         * separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in
         * quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a
         * href="http://crontab.org">Crontab</a>.
         * </p>
         * <p>
         * When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form
         * the boundaries of when the recurring action starts and stops.
         * </p>
         * 
         * @param recurrence
         *        The recurring schedule for this action, in Unix cron syntax format. This format consists of five
         *        fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The
         *        value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this
         *        format, see <a href="http://crontab.org">Crontab</a>.</p>
         *        <p>
         *        When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they
         *        form the boundaries of when the recurring action starts and stops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(String recurrence);

        /**
         * <p>
         * The minimum number of instances in the Auto Scaling group.
         * </p>
         * 
         * @param minSize
         *        The minimum number of instances in the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum number of instances in the Auto Scaling group.
         * </p>
         * 
         * @param maxSize
         *        The maximum number of instances in the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The number of EC2 instances that should be running in the Auto Scaling group.
         * </p>
         * 
         * @param desiredCapacity
         *        The number of EC2 instances that should be running in the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String scheduledActionName;

        private Instant time;

        private Instant startTime;

        private Instant endTime;

        private String recurrence;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScheduledUpdateGroupActionRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            scheduledActionName(model.scheduledActionName);
            time(model.time);
            startTime(model.startTime);
            endTime(model.endTime);
            recurrence(model.recurrence);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final Instant getTime() {
            return time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getRecurrence() {
            return recurrence;
        }

        @Override
        public final Builder recurrence(String recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScheduledUpdateGroupActionRequest build() {
            return new PutScheduledUpdateGroupActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
