/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.TargetGroupARNsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachLoadBalancerTargetGroupsRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, AttachLoadBalancerTargetGroupsRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AttachLoadBalancerTargetGroupsRequest.getter(AttachLoadBalancerTargetGroupsRequest::autoScalingGroupName)).setter(AttachLoadBalancerTargetGroupsRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<List<String>> TARGET_GROUP_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AttachLoadBalancerTargetGroupsRequest.getter(AttachLoadBalancerTargetGroupsRequest::targetGroupARNs)).setter(AttachLoadBalancerTargetGroupsRequest.setter(Builder::targetGroupARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, TARGET_GROUP_AR_NS_FIELD));
    private final String autoScalingGroupName;
    private final List<String> targetGroupARNs;

    private AttachLoadBalancerTargetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.targetGroupARNs = builder.targetGroupARNs;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public boolean hasTargetGroupARNs() {
        return this.targetGroupARNs != null && !(this.targetGroupARNs instanceof SdkAutoConstructList);
    }

    public List<String> targetGroupARNs() {
        return this.targetGroupARNs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupARNs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachLoadBalancerTargetGroupsRequest)) {
            return false;
        }
        AttachLoadBalancerTargetGroupsRequest other = (AttachLoadBalancerTargetGroupsRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.targetGroupARNs(), other.targetGroupARNs());
    }

    public String toString() {
        return ToString.builder((String)"AttachLoadBalancerTargetGroupsRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("TargetGroupARNs", this.targetGroupARNs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "TargetGroupARNs": {
                return Optional.ofNullable(clazz.cast(this.targetGroupARNs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachLoadBalancerTargetGroupsRequest, T> g) {
        return obj -> g.apply((AttachLoadBalancerTargetGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> targetGroupARNs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttachLoadBalancerTargetGroupsRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.targetGroupARNs(model.targetGroupARNs);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getTargetGroupARNs() {
            return this.targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String ... targetGroupARNs) {
            this.targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachLoadBalancerTargetGroupsRequest build() {
            return new AttachLoadBalancerTargetGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachLoadBalancerTargetGroupsRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder targetGroupARNs(Collection<String> var1);

        public Builder targetGroupARNs(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

