/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutScheduledUpdateGroupActionRequest extends AutoScalingRequest implements
        ToCopyableBuilder<BatchPutScheduledUpdateGroupActionRequest.Builder, BatchPutScheduledUpdateGroupActionRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchPutScheduledUpdateGroupActionRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<List<ScheduledUpdateGroupActionRequest>> SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD = SdkField
            .<List<ScheduledUpdateGroupActionRequest>> builder(MarshallingType.LIST)
            .getter(getter(BatchPutScheduledUpdateGroupActionRequest::scheduledUpdateGroupActions))
            .setter(setter(Builder::scheduledUpdateGroupActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledUpdateGroupActions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledUpdateGroupActionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledUpdateGroupActionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD));

    private final String autoScalingGroupName;

    private final List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions;

    private BatchPutScheduledUpdateGroupActionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * Returns true if the ScheduledUpdateGroupActions property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasScheduledUpdateGroupActions() {
        return scheduledUpdateGroupActions != null && !(scheduledUpdateGroupActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more scheduled actions. The maximum number allowed is 50.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScheduledUpdateGroupActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more scheduled actions. The maximum number allowed is 50.
     */
    public List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions() {
        return scheduledUpdateGroupActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledUpdateGroupActions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutScheduledUpdateGroupActionRequest)) {
            return false;
        }
        BatchPutScheduledUpdateGroupActionRequest other = (BatchPutScheduledUpdateGroupActionRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(scheduledUpdateGroupActions(), other.scheduledUpdateGroupActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchPutScheduledUpdateGroupActionRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("ScheduledUpdateGroupActions", scheduledUpdateGroupActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "ScheduledUpdateGroupActions":
            return Optional.ofNullable(clazz.cast(scheduledUpdateGroupActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutScheduledUpdateGroupActionRequest, T> g) {
        return obj -> g.apply((BatchPutScheduledUpdateGroupActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchPutScheduledUpdateGroupActionRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * One or more scheduled actions. The maximum number allowed is 50.
         * </p>
         * 
         * @param scheduledUpdateGroupActions
         *        One or more scheduled actions. The maximum number allowed is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions);

        /**
         * <p>
         * One or more scheduled actions. The maximum number allowed is 50.
         * </p>
         * 
         * @param scheduledUpdateGroupActions
         *        One or more scheduled actions. The maximum number allowed is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledUpdateGroupActions(ScheduledUpdateGroupActionRequest... scheduledUpdateGroupActions);

        /**
         * <p>
         * One or more scheduled actions. The maximum number allowed is 50.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledUpdateGroupActionRequest>.Builder}
         * avoiding the need to create one manually via {@link List<ScheduledUpdateGroupActionRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledUpdateGroupActionRequest>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #scheduledUpdateGroupActions(List<ScheduledUpdateGroupActionRequest>)}.
         * 
         * @param scheduledUpdateGroupActions
         *        a consumer that will call methods on {@link List<ScheduledUpdateGroupActionRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledUpdateGroupActions(List<ScheduledUpdateGroupActionRequest>)
         */
        Builder scheduledUpdateGroupActions(Consumer<ScheduledUpdateGroupActionRequest.Builder>... scheduledUpdateGroupActions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutScheduledUpdateGroupActionRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            scheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<ScheduledUpdateGroupActionRequest.Builder> getScheduledUpdateGroupActions() {
            return scheduledUpdateGroupActions != null ? scheduledUpdateGroupActions.stream()
                    .map(ScheduledUpdateGroupActionRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionRequestsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupActionRequest... scheduledUpdateGroupActions) {
            scheduledUpdateGroupActions(Arrays.asList(scheduledUpdateGroupActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(
                Consumer<ScheduledUpdateGroupActionRequest.Builder>... scheduledUpdateGroupActions) {
            scheduledUpdateGroupActions(Stream.of(scheduledUpdateGroupActions)
                    .map(c -> ScheduledUpdateGroupActionRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledUpdateGroupActions(
                Collection<ScheduledUpdateGroupActionRequest.BuilderImpl> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionRequestsCopier
                    .copyFromBuilder(scheduledUpdateGroupActions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutScheduledUpdateGroupActionRequest build() {
            return new BatchPutScheduledUpdateGroupActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
