/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchConfiguration.Builder, LaunchConfiguration> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::launchConfigurationName)).setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::launchConfigurationARN)).setter(setter(Builder::launchConfigurationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationARN").build())
            .build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(LaunchConfiguration::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLASSIC_LINK_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::classicLinkVPCId)).setter(setter(Builder::classicLinkVPCId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVPCId").build()).build();

    private static final SdkField<List<String>> CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(LaunchConfiguration::classicLinkVPCSecurityGroups))
            .setter(setter(Builder::classicLinkVPCSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVPCSecurityGroups")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::userData)).setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::kernelId)).setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::ramdiskId)).setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .getter(getter(LaunchConfiguration::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceMonitoring> INSTANCE_MONITORING_FIELD = SdkField
            .<InstanceMonitoring> builder(MarshallingType.SDK_POJO).getter(getter(LaunchConfiguration::instanceMonitoring))
            .setter(setter(Builder::instanceMonitoring)).constructor(InstanceMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMonitoring").build())
            .build();

    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::spotPrice)).setter(setter(Builder::spotPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").build()).build();

    private static final SdkField<String> IAM_INSTANCE_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::iamInstanceProfile)).setter(setter(Builder::iamInstanceProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LaunchConfiguration::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LaunchConfiguration::ebsOptimized)).setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(LaunchConfiguration::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build())
            .build();

    private static final SdkField<String> PLACEMENT_TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchConfiguration::placementTenancy)).setter(setter(Builder::placementTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementTenancy").build()).build();

    private static final SdkField<InstanceMetadataOptions> METADATA_OPTIONS_FIELD = SdkField
            .<InstanceMetadataOptions> builder(MarshallingType.SDK_POJO).getter(getter(LaunchConfiguration::metadataOptions))
            .setter(setter(Builder::metadataOptions)).constructor(InstanceMetadataOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_CONFIGURATION_ARN_FIELD, IMAGE_ID_FIELD, KEY_NAME_FIELD,
            SECURITY_GROUPS_FIELD, CLASSIC_LINK_VPC_ID_FIELD, CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD, USER_DATA_FIELD,
            INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, RAMDISK_ID_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, INSTANCE_MONITORING_FIELD,
            SPOT_PRICE_FIELD, IAM_INSTANCE_PROFILE_FIELD, CREATED_TIME_FIELD, EBS_OPTIMIZED_FIELD,
            ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, PLACEMENT_TENANCY_FIELD, METADATA_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchConfigurationName;

    private final String launchConfigurationARN;

    private final String imageId;

    private final String keyName;

    private final List<String> securityGroups;

    private final String classicLinkVPCId;

    private final List<String> classicLinkVPCSecurityGroups;

    private final String userData;

    private final String instanceType;

    private final String kernelId;

    private final String ramdiskId;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final InstanceMonitoring instanceMonitoring;

    private final String spotPrice;

    private final String iamInstanceProfile;

    private final Instant createdTime;

    private final Boolean ebsOptimized;

    private final Boolean associatePublicIpAddress;

    private final String placementTenancy;

    private final InstanceMetadataOptions metadataOptions;

    private LaunchConfiguration(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchConfigurationARN = builder.launchConfigurationARN;
        this.imageId = builder.imageId;
        this.keyName = builder.keyName;
        this.securityGroups = builder.securityGroups;
        this.classicLinkVPCId = builder.classicLinkVPCId;
        this.classicLinkVPCSecurityGroups = builder.classicLinkVPCSecurityGroups;
        this.userData = builder.userData;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.spotPrice = builder.spotPrice;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.createdTime = builder.createdTime;
        this.ebsOptimized = builder.ebsOptimized;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.placementTenancy = builder.placementTenancy;
        this.metadataOptions = builder.metadataOptions;
    }

    /**
     * <p>
     * The name of the launch configuration.
     * </p>
     * 
     * @return The name of the launch configuration.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the launch configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the launch configuration.
     */
    public String launchConfigurationARN() {
        return launchConfigurationARN;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
     * <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
     *         <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 Key Pairs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return The name of the key pair.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in
     *         the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the security groups to assign to the instances in the Auto Scaling group.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains the security groups to assign to the instances in the Auto Scaling group.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for
     *         Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * EC2 User Guide for Linux Instances</i> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
     * Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     *         <i>Amazon EC2 User Guide for Linux Instances</i> and <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking
     *         EC2-Classic Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public String classicLinkVPCId() {
        return classicLinkVPCId;
    }

    /**
     * Returns true if the ClassicLinkVPCSecurityGroups property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasClassicLinkVPCSecurityGroups() {
        return classicLinkVPCSecurityGroups != null && !(classicLinkVPCSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon
     * EC2 User Guide for Linux Instances</i> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
     * Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClassicLinkVPCSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
     *         <i>Amazon EC2 User Guide for Linux Instances</i> and <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking
     *         EC2-Classic Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public List<String> classicLinkVPCSecurityGroups() {
        return classicLinkVPCSecurityGroups;
    }

    /**
     * <p>
     * The Base64-encoded user data to make available to the launched EC2 instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User
     * Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return The Base64-encoded user data to make available to the launched EC2 instances.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata
     *         and User Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * The instance type for the instances.
     * </p>
     * <p>
     * For information about available instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
     * Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances.</i>
     * </p>
     * 
     * @return The instance type for the instances.</p>
     *         <p>
     *         For information about available instance types, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
     *         >Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances.</i>
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel associated with the AMI.
     * </p>
     * 
     * @return The ID of the kernel associated with the AMI.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The ID of the RAM disk associated with the AMI.
     * </p>
     * 
     * @return The ID of the RAM disk associated with the AMI.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * Returns true if the BlockDeviceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A block device mapping, which specifies the block devices for the instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
     * Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlockDeviceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A block device mapping, which specifies the block devices for the instance.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
     *         Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
     * <code>false</code>) monitoring.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics"
     * >Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
     *         <code>false</code>) monitoring.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics"
     *         >Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public InstanceMonitoring instanceMonitoring() {
        return instanceMonitoring;
    }

    /**
     * <p>
     * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are
     * launched when the price you specify exceeds the current Spot price.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Launching Spot
     * Instances in Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances
     *         are launched when the price you specify exceeds the current Spot price.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Launching
     *         Spot Instances in Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.
     * The instance profile contains the IAM role.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM
     * Role for Applications That Run on Amazon EC2 Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
     *         instance. The instance profile contains the IAM role.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM Role for Applications
     *         That Run on Amazon EC2 Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public String iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The creation date and time for the launch configuration.
     * </p>
     * 
     * @return The creation date and time for the launch configuration.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (
     * <code>false</code>).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon
     * EBS-Optimized Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (
     *         <code>false</code>).</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
     *         Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP address to the group's
     * instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling Instances in
     * a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP address to the
     *         group's instances.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling
     *         Instances in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
     * <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-vpc-tenancy">Instance Placement
     * Tenancy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
     *         <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a
     *         VPC.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-vpc-tenancy">Instance
     *         Placement Tenancy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public String placementTenancy() {
        return placementTenancy;
    }

    /**
     * <p>
     * The metadata options for the instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User
     * Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return The metadata options for the instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata
     *         and User Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public InstanceMetadataOptions metadataOptions() {
        return metadataOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationARN());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(classicLinkVPCId());
        hashCode = 31 * hashCode + Objects.hashCode(classicLinkVPCSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(placementTenancy());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfiguration)) {
            return false;
        }
        LaunchConfiguration other = (LaunchConfiguration) obj;
        return Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(launchConfigurationARN(), other.launchConfigurationARN())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(classicLinkVPCId(), other.classicLinkVPCId())
                && Objects.equals(classicLinkVPCSecurityGroups(), other.classicLinkVPCSecurityGroups())
                && Objects.equals(userData(), other.userData()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(kernelId(), other.kernelId()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(instanceMonitoring(), other.instanceMonitoring())
                && Objects.equals(spotPrice(), other.spotPrice())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(placementTenancy(), other.placementTenancy())
                && Objects.equals(metadataOptions(), other.metadataOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LaunchConfiguration").add("LaunchConfigurationName", launchConfigurationName())
                .add("LaunchConfigurationARN", launchConfigurationARN()).add("ImageId", imageId()).add("KeyName", keyName())
                .add("SecurityGroups", securityGroups()).add("ClassicLinkVPCId", classicLinkVPCId())
                .add("ClassicLinkVPCSecurityGroups", classicLinkVPCSecurityGroups()).add("UserData", userData())
                .add("InstanceType", instanceType()).add("KernelId", kernelId()).add("RamdiskId", ramdiskId())
                .add("BlockDeviceMappings", blockDeviceMappings()).add("InstanceMonitoring", instanceMonitoring())
                .add("SpotPrice", spotPrice()).add("IamInstanceProfile", iamInstanceProfile()).add("CreatedTime", createdTime())
                .add("EbsOptimized", ebsOptimized()).add("AssociatePublicIpAddress", associatePublicIpAddress())
                .add("PlacementTenancy", placementTenancy()).add("MetadataOptions", metadataOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LaunchConfigurationARN":
            return Optional.ofNullable(clazz.cast(launchConfigurationARN()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "ClassicLinkVPCId":
            return Optional.ofNullable(clazz.cast(classicLinkVPCId()));
        case "ClassicLinkVPCSecurityGroups":
            return Optional.ofNullable(clazz.cast(classicLinkVPCSecurityGroups()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "InstanceMonitoring":
            return Optional.ofNullable(clazz.cast(instanceMonitoring()));
        case "SpotPrice":
            return Optional.ofNullable(clazz.cast(spotPrice()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "PlacementTenancy":
            return Optional.ofNullable(clazz.cast(placementTenancy()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchConfiguration, T> g) {
        return obj -> g.apply((LaunchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchConfiguration> {
        /**
         * <p>
         * The name of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationARN
         *        The Amazon Resource Name (ARN) of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationARN(String launchConfigurationARN);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in
         *        the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a>
         *        in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * A list that contains the security groups to assign to the instances in the Auto Scaling group.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for
         * Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param securityGroups
         *        A list that contains the security groups to assign to the instances in the Auto Scaling group.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups
         *        for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * A list that contains the security groups to assign to the instances in the Auto Scaling group.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for
         * Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * </p>
         * 
         * @param securityGroups
         *        A list that contains the security groups to assign to the instances in the Auto Scaling group.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups
         *        for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i> and <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking
         * EC2-Classic Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCId
         *        The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon EC2 User Guide for Linux Instances</i> and <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking
         *        EC2-Classic Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCId(String classicLinkVPCId);

        /**
         * <p>
         * The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i> and <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking
         * EC2-Classic Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon EC2 User Guide for Linux Instances</i> and <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking
         *        EC2-Classic Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i> and <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking
         * EC2-Classic Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param classicLinkVPCSecurityGroups
         *        The IDs of one or more security groups for the VPC specified in <code>ClassicLinkVPCId</code>.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
         *        <i>Amazon EC2 User Guide for Linux Instances</i> and <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking
         *        EC2-Classic Instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups);

        /**
         * <p>
         * The Base64-encoded user data to make available to the launched EC2 instances.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param userData
         *        The Base64-encoded user data to make available to the launched EC2 instances.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance
         *        Metadata and User Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The instance type for the instances.
         * </p>
         * <p>
         * For information about available instance types, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         * >Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances.</i>
         * </p>
         * 
         * @param instanceType
         *        The instance type for the instances.</p>
         *        <p>
         *        For information about available instance types, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         *        >Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel associated with the AMI.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The ID of the RAM disk associated with the AMI.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * A block device mapping, which specifies the block devices for the instance.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        A block device mapping, which specifies the block devices for the instance.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * A block device mapping, which specifies the block devices for the instance.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param blockDeviceMappings
         *        A block device mapping, which specifies the block devices for the instance.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * A block device mapping, which specifies the block devices for the instance.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BlockDeviceMapping>.Builder} avoiding the
         * need to create one manually via {@link List<BlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockDeviceMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<BlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
         * <code>false</code>) monitoring.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics"
         * >Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param instanceMonitoring
         *        Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
         *        <code>false</code>) monitoring.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics"
         *        >Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitoring(InstanceMonitoring instanceMonitoring);

        /**
         * <p>
         * Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (
         * <code>false</code>) monitoring.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics"
         * >Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceMonitoring.Builder} avoiding the need to
         * create one manually via {@link InstanceMonitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceMonitoring.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceMonitoring(InstanceMonitoring)}.
         * 
         * @param instanceMonitoring
         *        a consumer that will call methods on {@link InstanceMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMonitoring(InstanceMonitoring)
         */
        default Builder instanceMonitoring(Consumer<InstanceMonitoring.Builder> instanceMonitoring) {
            return instanceMonitoring(InstanceMonitoring.builder().applyMutation(instanceMonitoring).build());
        }

        /**
         * <p>
         * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are
         * launched when the price you specify exceeds the current Spot price.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Launching Spot
         * Instances in Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param spotPrice
         *        The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot
         *        Instances are launched when the price you specify exceeds the current Spot price.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Launching
         *        Spot Instances in Your Auto Scaling Group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the
         * instance. The instance profile contains the IAM role.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM Role for Applications That
         * Run on Amazon EC2 Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for
         *        the instance. The instance profile contains the IAM role.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM Role for
         *        Applications That Run on Amazon EC2 Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(String iamInstanceProfile);

        /**
         * <p>
         * The creation date and time for the launch configuration.
         * </p>
         * 
         * @param createdTime
         *        The creation date and time for the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (
         * <code>false</code>).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         * Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param ebsOptimized
         *        Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (
         *        <code>false</code>).</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized
         *        Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP address to the
         * group's instances.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling Instances
         * in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP address to
         *        the group's instances.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling
         *        Instances in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
         * <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-vpc-tenancy">Instance
         * Placement Tenancy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param placementTenancy
         *        The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An instance with
         *        <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into
         *        a VPC.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-vpc-tenancy">Instance
         *        Placement Tenancy</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTenancy(String placementTenancy);

        /**
         * <p>
         * The metadata options for the instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance
         *        Metadata and User Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(InstanceMetadataOptions metadataOptions);

        /**
         * <p>
         * The metadata options for the instances. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and
         * User Data</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceMetadataOptions.Builder} avoiding the
         * need to create one manually via {@link InstanceMetadataOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceMetadataOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #metadataOptions(InstanceMetadataOptions)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link InstanceMetadataOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(InstanceMetadataOptions)
         */
        default Builder metadataOptions(Consumer<InstanceMetadataOptions.Builder> metadataOptions) {
            return metadataOptions(InstanceMetadataOptions.builder().applyMutation(metadataOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String launchConfigurationName;

        private String launchConfigurationARN;

        private String imageId;

        private String keyName;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String classicLinkVPCId;

        private List<String> classicLinkVPCSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String userData;

        private String instanceType;

        private String kernelId;

        private String ramdiskId;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private InstanceMonitoring instanceMonitoring;

        private String spotPrice;

        private String iamInstanceProfile;

        private Instant createdTime;

        private Boolean ebsOptimized;

        private Boolean associatePublicIpAddress;

        private String placementTenancy;

        private InstanceMetadataOptions metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfiguration model) {
            launchConfigurationName(model.launchConfigurationName);
            launchConfigurationARN(model.launchConfigurationARN);
            imageId(model.imageId);
            keyName(model.keyName);
            securityGroups(model.securityGroups);
            classicLinkVPCId(model.classicLinkVPCId);
            classicLinkVPCSecurityGroups(model.classicLinkVPCSecurityGroups);
            userData(model.userData);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            ramdiskId(model.ramdiskId);
            blockDeviceMappings(model.blockDeviceMappings);
            instanceMonitoring(model.instanceMonitoring);
            spotPrice(model.spotPrice);
            iamInstanceProfile(model.iamInstanceProfile);
            createdTime(model.createdTime);
            ebsOptimized(model.ebsOptimized);
            associatePublicIpAddress(model.associatePublicIpAddress);
            placementTenancy(model.placementTenancy);
            metadataOptions(model.metadataOptions);
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getLaunchConfigurationARN() {
            return launchConfigurationARN;
        }

        @Override
        public final Builder launchConfigurationARN(String launchConfigurationARN) {
            this.launchConfigurationARN = launchConfigurationARN;
            return this;
        }

        public final void setLaunchConfigurationARN(String launchConfigurationARN) {
            this.launchConfigurationARN = launchConfigurationARN;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getClassicLinkVPCId() {
            return classicLinkVPCId;
        }

        @Override
        public final Builder classicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
            return this;
        }

        public final void setClassicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
        }

        public final Collection<String> getClassicLinkVPCSecurityGroups() {
            return classicLinkVPCSecurityGroups;
        }

        @Override
        public final Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVPCSecurityGroups(String... classicLinkVPCSecurityGroups) {
            classicLinkVPCSecurityGroups(Arrays.asList(classicLinkVPCSecurityGroups));
            return this;
        }

        public final void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final InstanceMonitoring.Builder getInstanceMonitoring() {
            return instanceMonitoring != null ? instanceMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder instanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final void setInstanceMonitoring(InstanceMonitoring.BuilderImpl instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring != null ? instanceMonitoring.build() : null;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getIamInstanceProfile() {
            return iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final String getPlacementTenancy() {
            return placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        public final InstanceMetadataOptions.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final void setMetadataOptions(InstanceMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public LaunchConfiguration build() {
            return new LaunchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
