/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLaunchConfigurationsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeLaunchConfigurationsResponse.Builder, DescribeLaunchConfigurationsResponse> {
    private static final SdkField<List<LaunchConfiguration>> LAUNCH_CONFIGURATIONS_FIELD = SdkField
            .<List<LaunchConfiguration>> builder(MarshallingType.LIST)
            .memberName("LaunchConfigurations")
            .getter(getter(DescribeLaunchConfigurationsResponse::launchConfigurations))
            .setter(setter(Builder::launchConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeLaunchConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_CONFIGURATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LaunchConfiguration> launchConfigurations;

    private final String nextToken;

    private DescribeLaunchConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.launchConfigurations = builder.launchConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LaunchConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLaunchConfigurations() {
        return launchConfigurations != null && !(launchConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The launch configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The launch configurations.
     */
    public List<LaunchConfiguration> launchConfigurations() {
        return launchConfigurations;
    }

    /**
     * <p>
     * A string that indicates that the response contains more items than can be returned in a single response. To
     * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set
     * of items. This value is null when there are no more items to return.
     * </p>
     * 
     * @return A string that indicates that the response contains more items than can be returned in a single response.
     *         To receive additional items, specify this string for the <code>NextToken</code> value when requesting the
     *         next set of items. This value is null when there are no more items to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchConfigurations() ? launchConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsResponse)) {
            return false;
        }
        DescribeLaunchConfigurationsResponse other = (DescribeLaunchConfigurationsResponse) obj;
        return hasLaunchConfigurations() == other.hasLaunchConfigurations()
                && Objects.equals(launchConfigurations(), other.launchConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLaunchConfigurationsResponse")
                .add("LaunchConfigurations", hasLaunchConfigurations() ? launchConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchConfigurations":
            return Optional.ofNullable(clazz.cast(launchConfigurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeLaunchConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLaunchConfigurationsResponse> {
        /**
         * <p>
         * The launch configurations.
         * </p>
         * 
         * @param launchConfigurations
         *        The launch configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations);

        /**
         * <p>
         * The launch configurations.
         * </p>
         * 
         * @param launchConfigurations
         *        The launch configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurations(LaunchConfiguration... launchConfigurations);

        /**
         * <p>
         * The launch configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<LaunchConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #launchConfigurations(List<LaunchConfiguration>)}.
         * 
         * @param launchConfigurations
         *        a consumer that will call methods on {@link List<LaunchConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchConfigurations(List<LaunchConfiguration>)
         */
        Builder launchConfigurations(Consumer<LaunchConfiguration.Builder>... launchConfigurations);

        /**
         * <p>
         * A string that indicates that the response contains more items than can be returned in a single response. To
         * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next
         * set of items. This value is null when there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        A string that indicates that the response contains more items than can be returned in a single
         *        response. To receive additional items, specify this string for the <code>NextToken</code> value when
         *        requesting the next set of items. This value is null when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<LaunchConfiguration> launchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsResponse model) {
            super(model);
            launchConfigurations(model.launchConfigurations);
            nextToken(model.nextToken);
        }

        public final Collection<LaunchConfiguration.Builder> getLaunchConfigurations() {
            if (launchConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return launchConfigurations != null ? launchConfigurations.stream().map(LaunchConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration... launchConfigurations) {
            launchConfigurations(Arrays.asList(launchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(Consumer<LaunchConfiguration.Builder>... launchConfigurations) {
            launchConfigurations(Stream.of(launchConfigurations).map(c -> LaunchConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration.BuilderImpl> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copyFromBuilder(launchConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLaunchConfigurationsResponse build() {
            return new DescribeLaunchConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
