/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.InstanceRefreshIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceRefreshesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeInstanceRefreshesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(DescribeInstanceRefreshesRequest.getter(DescribeInstanceRefreshesRequest::autoScalingGroupName)).setter(DescribeInstanceRefreshesRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<List<String>> INSTANCE_REFRESH_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceRefreshIds").getter(DescribeInstanceRefreshesRequest.getter(DescribeInstanceRefreshesRequest::instanceRefreshIds)).setter(DescribeInstanceRefreshesRequest.setter(Builder::instanceRefreshIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRefreshIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceRefreshesRequest.getter(DescribeInstanceRefreshesRequest::nextToken)).setter(DescribeInstanceRefreshesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeInstanceRefreshesRequest.getter(DescribeInstanceRefreshesRequest::maxRecords)).setter(DescribeInstanceRefreshesRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, INSTANCE_REFRESH_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RECORDS_FIELD));
    private final String autoScalingGroupName;
    private final List<String> instanceRefreshIds;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeInstanceRefreshesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.instanceRefreshIds = builder.instanceRefreshIds;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public boolean hasInstanceRefreshIds() {
        return this.instanceRefreshIds != null && !(this.instanceRefreshIds instanceof SdkAutoConstructList);
    }

    public List<String> instanceRefreshIds() {
        return this.instanceRefreshIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceRefreshIds() ? this.instanceRefreshIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceRefreshesRequest)) {
            return false;
        }
        DescribeInstanceRefreshesRequest other = (DescribeInstanceRefreshesRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && this.hasInstanceRefreshIds() == other.hasInstanceRefreshIds() && Objects.equals(this.instanceRefreshIds(), other.instanceRefreshIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstanceRefreshesRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("InstanceRefreshIds", this.hasInstanceRefreshIds() ? this.instanceRefreshIds() : null).add("NextToken", (Object)this.nextToken()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "InstanceRefreshIds": {
                return Optional.ofNullable(clazz.cast(this.instanceRefreshIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceRefreshesRequest, T> g) {
        return obj -> g.apply((DescribeInstanceRefreshesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> instanceRefreshIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceRefreshesRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.instanceRefreshIds(model.instanceRefreshIds);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getInstanceRefreshIds() {
            if (this.instanceRefreshIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceRefreshIds;
        }

        @Override
        public final Builder instanceRefreshIds(Collection<String> instanceRefreshIds) {
            this.instanceRefreshIds = InstanceRefreshIdsCopier.copy(instanceRefreshIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRefreshIds(String ... instanceRefreshIds) {
            this.instanceRefreshIds(Arrays.asList(instanceRefreshIds));
            return this;
        }

        public final void setInstanceRefreshIds(Collection<String> instanceRefreshIds) {
            this.instanceRefreshIds = InstanceRefreshIdsCopier.copy(instanceRefreshIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstanceRefreshesRequest build() {
            return new DescribeInstanceRefreshesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceRefreshesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder instanceRefreshIds(Collection<String> var1);

        public Builder instanceRefreshIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

