/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfiguration;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLaunchConfigurationsResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeLaunchConfigurationsResponse> {
    private static final SdkField<List<LaunchConfiguration>> LAUNCH_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchConfigurations").getter(DescribeLaunchConfigurationsResponse.getter(DescribeLaunchConfigurationsResponse::launchConfigurations)).setter(DescribeLaunchConfigurationsResponse.setter(Builder::launchConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLaunchConfigurationsResponse.getter(DescribeLaunchConfigurationsResponse::nextToken)).setter(DescribeLaunchConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<LaunchConfiguration> launchConfigurations;
    private final String nextToken;

    private DescribeLaunchConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.launchConfigurations = builder.launchConfigurations;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLaunchConfigurations() {
        return this.launchConfigurations != null && !(this.launchConfigurations instanceof SdkAutoConstructList);
    }

    public List<LaunchConfiguration> launchConfigurations() {
        return this.launchConfigurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchConfigurations() ? this.launchConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsResponse)) {
            return false;
        }
        DescribeLaunchConfigurationsResponse other = (DescribeLaunchConfigurationsResponse)((Object)obj);
        return this.hasLaunchConfigurations() == other.hasLaunchConfigurations() && Objects.equals(this.launchConfigurations(), other.launchConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLaunchConfigurationsResponse").add("LaunchConfigurations", this.hasLaunchConfigurations() ? this.launchConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchConfigurations": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeLaunchConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<LaunchConfiguration> launchConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsResponse model) {
            super(model);
            this.launchConfigurations(model.launchConfigurations);
            this.nextToken(model.nextToken);
        }

        public final Collection<LaunchConfiguration.Builder> getLaunchConfigurations() {
            if (this.launchConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.launchConfigurations != null ? (Collection)this.launchConfigurations.stream().map(LaunchConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration ... launchConfigurations) {
            this.launchConfigurations(Arrays.asList(launchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(Consumer<LaunchConfiguration.Builder> ... launchConfigurations) {
            this.launchConfigurations(Stream.of(launchConfigurations).map(c -> (LaunchConfiguration)((LaunchConfiguration.Builder)LaunchConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration.BuilderImpl> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copyFromBuilder(launchConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLaunchConfigurationsResponse build() {
            return new DescribeLaunchConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLaunchConfigurationsResponse> {
        public Builder launchConfigurations(Collection<LaunchConfiguration> var1);

        public Builder launchConfigurations(LaunchConfiguration ... var1);

        public Builder launchConfigurations(Consumer<LaunchConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

