/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceRefreshesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeInstanceRefreshesResponse.Builder, DescribeInstanceRefreshesResponse> {
    private static final SdkField<List<InstanceRefresh>> INSTANCE_REFRESHES_FIELD = SdkField
            .<List<InstanceRefresh>> builder(MarshallingType.LIST)
            .memberName("InstanceRefreshes")
            .getter(getter(DescribeInstanceRefreshesResponse::instanceRefreshes))
            .setter(setter(Builder::instanceRefreshes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRefreshes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceRefresh> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceRefresh::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInstanceRefreshesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_REFRESHES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InstanceRefresh> instanceRefreshes;

    private final String nextToken;

    private DescribeInstanceRefreshesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceRefreshes = builder.instanceRefreshes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the InstanceRefreshes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInstanceRefreshes() {
        return instanceRefreshes != null && !(instanceRefreshes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance refreshes for the specified group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceRefreshes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instance refreshes for the specified group.
     */
    public List<InstanceRefresh> instanceRefreshes() {
        return instanceRefreshes;
    }

    /**
     * <p>
     * A string that indicates that the response contains more items than can be returned in a single response. To
     * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set
     * of items. This value is null when there are no more items to return.
     * </p>
     * 
     * @return A string that indicates that the response contains more items than can be returned in a single response.
     *         To receive additional items, specify this string for the <code>NextToken</code> value when requesting the
     *         next set of items. This value is null when there are no more items to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceRefreshes() ? instanceRefreshes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceRefreshesResponse)) {
            return false;
        }
        DescribeInstanceRefreshesResponse other = (DescribeInstanceRefreshesResponse) obj;
        return hasInstanceRefreshes() == other.hasInstanceRefreshes()
                && Objects.equals(instanceRefreshes(), other.instanceRefreshes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInstanceRefreshesResponse")
                .add("InstanceRefreshes", hasInstanceRefreshes() ? instanceRefreshes() : null).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceRefreshes":
            return Optional.ofNullable(clazz.cast(instanceRefreshes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceRefreshesResponse, T> g) {
        return obj -> g.apply((DescribeInstanceRefreshesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceRefreshesResponse> {
        /**
         * <p>
         * The instance refreshes for the specified group.
         * </p>
         * 
         * @param instanceRefreshes
         *        The instance refreshes for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRefreshes(Collection<InstanceRefresh> instanceRefreshes);

        /**
         * <p>
         * The instance refreshes for the specified group.
         * </p>
         * 
         * @param instanceRefreshes
         *        The instance refreshes for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRefreshes(InstanceRefresh... instanceRefreshes);

        /**
         * <p>
         * The instance refreshes for the specified group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceRefresh>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceRefresh>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceRefresh>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceRefreshes(List<InstanceRefresh>)}.
         * 
         * @param instanceRefreshes
         *        a consumer that will call methods on {@link List<InstanceRefresh>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRefreshes(List<InstanceRefresh>)
         */
        Builder instanceRefreshes(Consumer<InstanceRefresh.Builder>... instanceRefreshes);

        /**
         * <p>
         * A string that indicates that the response contains more items than can be returned in a single response. To
         * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next
         * set of items. This value is null when there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        A string that indicates that the response contains more items than can be returned in a single
         *        response. To receive additional items, specify this string for the <code>NextToken</code> value when
         *        requesting the next set of items. This value is null when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<InstanceRefresh> instanceRefreshes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceRefreshesResponse model) {
            super(model);
            instanceRefreshes(model.instanceRefreshes);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceRefresh.Builder> getInstanceRefreshes() {
            if (instanceRefreshes instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceRefreshes != null ? instanceRefreshes.stream().map(InstanceRefresh::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceRefreshes(Collection<InstanceRefresh> instanceRefreshes) {
            this.instanceRefreshes = InstanceRefreshesCopier.copy(instanceRefreshes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRefreshes(InstanceRefresh... instanceRefreshes) {
            instanceRefreshes(Arrays.asList(instanceRefreshes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRefreshes(Consumer<InstanceRefresh.Builder>... instanceRefreshes) {
            instanceRefreshes(Stream.of(instanceRefreshes).map(c -> InstanceRefresh.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceRefreshes(Collection<InstanceRefresh.BuilderImpl> instanceRefreshes) {
            this.instanceRefreshes = InstanceRefreshesCopier.copyFromBuilder(instanceRefreshes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceRefreshesResponse build() {
            return new DescribeInstanceRefreshesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
