/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotificationConfigurationsRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DescribeNotificationConfigurationsRequest.Builder, DescribeNotificationConfigurationsRequest> {
    private static final SdkField<List<String>> AUTO_SCALING_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AutoScalingGroupNames")
            .getter(getter(DescribeNotificationConfigurationsRequest::autoScalingGroupNames))
            .setter(setter(Builder::autoScalingGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeNotificationConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeNotificationConfigurationsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_SCALING_GROUP_NAMES_FIELD, NEXT_TOKEN_FIELD, MAX_RECORDS_FIELD));

    private final List<String> autoScalingGroupNames;

    private final String nextToken;

    private final Integer maxRecords;

    private DescribeNotificationConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupNames = builder.autoScalingGroupNames;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * Returns true if the AutoScalingGroupNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAutoScalingGroupNames() {
        return autoScalingGroupNames != null && !(autoScalingGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoScalingGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public List<String> autoScalingGroupNames() {
        return autoScalingGroupNames;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value
     * is <code>100</code>.
     * </p>
     * 
     * @return The maximum number of items to return with this call. The default value is <code>50</code> and the
     *         maximum value is <code>100</code>.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoScalingGroupNames() ? autoScalingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationConfigurationsRequest)) {
            return false;
        }
        DescribeNotificationConfigurationsRequest other = (DescribeNotificationConfigurationsRequest) obj;
        return hasAutoScalingGroupNames() == other.hasAutoScalingGroupNames()
                && Objects.equals(autoScalingGroupNames(), other.autoScalingGroupNames())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxRecords(), other.maxRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNotificationConfigurationsRequest")
                .add("AutoScalingGroupNames", hasAutoScalingGroupNames() ? autoScalingGroupNames() : null)
                .add("NextToken", nextToken()).add("MaxRecords", maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupNames":
            return Optional.ofNullable(clazz.cast(autoScalingGroupNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotificationConfigurationsRequest, T> g) {
        return obj -> g.apply((DescribeNotificationConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotificationConfigurationsRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupNames
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupNames(Collection<String> autoScalingGroupNames);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupNames
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupNames(String... autoScalingGroupNames);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return with this call. The default value is <code>50</code> and the maximum
         * value is <code>100</code>.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to return with this call. The default value is <code>50</code> and the
         *        maximum value is <code>100</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private List<String> autoScalingGroupNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationConfigurationsRequest model) {
            super(model);
            autoScalingGroupNames(model.autoScalingGroupNames);
            nextToken(model.nextToken);
            maxRecords(model.maxRecords);
        }

        public final Collection<String> getAutoScalingGroupNames() {
            if (autoScalingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return autoScalingGroupNames;
        }

        @Override
        public final Builder autoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNamesCopier.copy(autoScalingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupNames(String... autoScalingGroupNames) {
            autoScalingGroupNames(Arrays.asList(autoScalingGroupNames));
            return this;
        }

        public final void setAutoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNamesCopier.copy(autoScalingGroupNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNotificationConfigurationsRequest build() {
            return new DescribeNotificationConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
