/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalingProcessTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeScalingProcessTypesResponse.Builder, DescribeScalingProcessTypesResponse> {
    private static final SdkField<List<ProcessType>> PROCESSES_FIELD = SdkField
            .<List<ProcessType>> builder(MarshallingType.LIST)
            .memberName("Processes")
            .getter(getter(DescribeScalingProcessTypesResponse::processes))
            .setter(setter(Builder::processes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProcessType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSES_FIELD));

    private final List<ProcessType> processes;

    private DescribeScalingProcessTypesResponse(BuilderImpl builder) {
        super(builder);
        this.processes = builder.processes;
    }

    /**
     * Returns true if the Processes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProcesses() {
        return processes != null && !(processes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the process types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcesses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the process types.
     */
    public List<ProcessType> processes() {
        return processes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProcesses() ? processes() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingProcessTypesResponse)) {
            return false;
        }
        DescribeScalingProcessTypesResponse other = (DescribeScalingProcessTypesResponse) obj;
        return hasProcesses() == other.hasProcesses() && Objects.equals(processes(), other.processes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeScalingProcessTypesResponse").add("Processes", hasProcesses() ? processes() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Processes":
            return Optional.ofNullable(clazz.cast(processes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingProcessTypesResponse, T> g) {
        return obj -> g.apply((DescribeScalingProcessTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScalingProcessTypesResponse> {
        /**
         * <p>
         * The names of the process types.
         * </p>
         * 
         * @param processes
         *        The names of the process types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processes(Collection<ProcessType> processes);

        /**
         * <p>
         * The names of the process types.
         * </p>
         * 
         * @param processes
         *        The names of the process types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processes(ProcessType... processes);

        /**
         * <p>
         * The names of the process types.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProcessType>.Builder} avoiding the need to
         * create one manually via {@link List<ProcessType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessType>.Builder#build()} is called immediately and its
         * result is passed to {@link #processes(List<ProcessType>)}.
         * 
         * @param processes
         *        a consumer that will call methods on {@link List<ProcessType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processes(List<ProcessType>)
         */
        Builder processes(Consumer<ProcessType.Builder>... processes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<ProcessType> processes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingProcessTypesResponse model) {
            super(model);
            processes(model.processes);
        }

        public final Collection<ProcessType.Builder> getProcesses() {
            if (processes instanceof SdkAutoConstructList) {
                return null;
            }
            return processes != null ? processes.stream().map(ProcessType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processes(Collection<ProcessType> processes) {
            this.processes = ProcessesCopier.copy(processes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processes(ProcessType... processes) {
            processes(Arrays.asList(processes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processes(Consumer<ProcessType.Builder>... processes) {
            processes(Stream.of(processes).map(c -> ProcessType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcesses(Collection<ProcessType.BuilderImpl> processes) {
            this.processes = ProcessesCopier.copyFromBuilder(processes);
        }

        @Override
        public DescribeScalingProcessTypesResponse build() {
            return new DescribeScalingProcessTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
