/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a tag for an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tag implements SdkPojo, Serializable, ToCopyableBuilder<Tag.Builder, Tag> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(Tag::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(Tag::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(Tag::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Tag::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Boolean> PROPAGATE_AT_LAUNCH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PropagateAtLaunch").getter(getter(Tag::propagateAtLaunch)).setter(setter(Builder::propagateAtLaunch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagateAtLaunch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, KEY_FIELD, VALUE_FIELD, PROPAGATE_AT_LAUNCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String resourceType;

    private final String key;

    private final String value;

    private final Boolean propagateAtLaunch;

    private Tag(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.key = builder.key;
        this.value = builder.value;
        this.propagateAtLaunch = builder.propagateAtLaunch;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource. The only supported value is <code>auto-scaling-group</code>.
     * </p>
     * 
     * @return The type of resource. The only supported value is <code>auto-scaling-group</code>.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The tag key.
     * </p>
     * 
     * @return The tag key.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The tag value.
     * </p>
     * 
     * @return The tag value.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * Determines whether the tag is added to new instances as they are launched in the group.
     * </p>
     * 
     * @return Determines whether the tag is added to new instances as they are launched in the group.
     */
    public Boolean propagateAtLaunch() {
        return propagateAtLaunch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(propagateAtLaunch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(propagateAtLaunch(), other.propagateAtLaunch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Tag").add("ResourceId", resourceId()).add("ResourceType", resourceType()).add("Key", key())
                .add("Value", value()).add("PropagateAtLaunch", propagateAtLaunch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "PropagateAtLaunch":
            return Optional.ofNullable(clazz.cast(propagateAtLaunch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tag, T> g) {
        return obj -> g.apply((Tag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tag> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param resourceId
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource. The only supported value is <code>auto-scaling-group</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource. The only supported value is <code>auto-scaling-group</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The tag key.
         * </p>
         * 
         * @param key
         *        The tag key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The tag value.
         * </p>
         * 
         * @param value
         *        The tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Determines whether the tag is added to new instances as they are launched in the group.
         * </p>
         * 
         * @param propagateAtLaunch
         *        Determines whether the tag is added to new instances as they are launched in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagateAtLaunch(Boolean propagateAtLaunch);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private String key;

        private String value;

        private Boolean propagateAtLaunch;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            key(model.key);
            value(model.value);
            propagateAtLaunch(model.propagateAtLaunch);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getPropagateAtLaunch() {
            return propagateAtLaunch;
        }

        @Override
        public final Builder propagateAtLaunch(Boolean propagateAtLaunch) {
            this.propagateAtLaunch = propagateAtLaunch;
            return this;
        }

        public final void setPropagateAtLaunch(Boolean propagateAtLaunch) {
            this.propagateAtLaunch = propagateAtLaunch;
        }

        @Override
        public Tag build() {
            return new Tag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
