/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLifecycleHooksResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeLifecycleHooksResponse.Builder, DescribeLifecycleHooksResponse> {
    private static final SdkField<List<LifecycleHook>> LIFECYCLE_HOOKS_FIELD = SdkField
            .<List<LifecycleHook>> builder(MarshallingType.LIST)
            .memberName("LifecycleHooks")
            .getter(getter(DescribeLifecycleHooksResponse::lifecycleHooks))
            .setter(setter(Builder::lifecycleHooks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHooks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecycleHook> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecycleHook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOKS_FIELD));

    private final List<LifecycleHook> lifecycleHooks;

    private DescribeLifecycleHooksResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleHooks = builder.lifecycleHooks;
    }

    /**
     * Returns true if the LifecycleHooks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLifecycleHooks() {
        return lifecycleHooks != null && !(lifecycleHooks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The lifecycle hooks for the specified group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLifecycleHooks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The lifecycle hooks for the specified group.
     */
    public final List<LifecycleHook> lifecycleHooks() {
        return lifecycleHooks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecycleHooks() ? lifecycleHooks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksResponse)) {
            return false;
        }
        DescribeLifecycleHooksResponse other = (DescribeLifecycleHooksResponse) obj;
        return hasLifecycleHooks() == other.hasLifecycleHooks() && Objects.equals(lifecycleHooks(), other.lifecycleHooks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLifecycleHooksResponse")
                .add("LifecycleHooks", hasLifecycleHooks() ? lifecycleHooks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecycleHooks":
            return Optional.ofNullable(clazz.cast(lifecycleHooks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLifecycleHooksResponse, T> g) {
        return obj -> g.apply((DescribeLifecycleHooksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLifecycleHooksResponse> {
        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * 
         * @param lifecycleHooks
         *        The lifecycle hooks for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks);

        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * 
         * @param lifecycleHooks
         *        The lifecycle hooks for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHooks(LifecycleHook... lifecycleHooks);

        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LifecycleHook>.Builder} avoiding the need
         * to create one manually via {@link List<LifecycleHook>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LifecycleHook>.Builder#build()} is called immediately and
         * its result is passed to {@link #lifecycleHooks(List<LifecycleHook>)}.
         * 
         * @param lifecycleHooks
         *        a consumer that will call methods on {@link List<LifecycleHook>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleHooks(List<LifecycleHook>)
         */
        Builder lifecycleHooks(Consumer<LifecycleHook.Builder>... lifecycleHooks);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<LifecycleHook> lifecycleHooks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksResponse model) {
            super(model);
            lifecycleHooks(model.lifecycleHooks);
        }

        public final Collection<LifecycleHook.Builder> getLifecycleHooks() {
            if (lifecycleHooks instanceof SdkAutoConstructList) {
                return null;
            }
            return lifecycleHooks != null ? lifecycleHooks.stream().map(LifecycleHook::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copy(lifecycleHooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(LifecycleHook... lifecycleHooks) {
            lifecycleHooks(Arrays.asList(lifecycleHooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(Consumer<LifecycleHook.Builder>... lifecycleHooks) {
            lifecycleHooks(Stream.of(lifecycleHooks).map(c -> LifecycleHook.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLifecycleHooks(Collection<LifecycleHook.BuilderImpl> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copyFromBuilder(lifecycleHooks);
        }

        @Override
        public DescribeLifecycleHooksResponse build() {
            return new DescribeLifecycleHooksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
