/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWarmPoolResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeWarmPoolResponse.Builder, DescribeWarmPoolResponse> {
    private static final SdkField<WarmPoolConfiguration> WARM_POOL_CONFIGURATION_FIELD = SdkField
            .<WarmPoolConfiguration> builder(MarshallingType.SDK_POJO).memberName("WarmPoolConfiguration")
            .getter(getter(DescribeWarmPoolResponse::warmPoolConfiguration)).setter(setter(Builder::warmPoolConfiguration))
            .constructor(WarmPoolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolConfiguration").build())
            .build();

    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField
            .<List<Instance>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(DescribeWarmPoolResponse::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instance> builder(MarshallingType.SDK_POJO)
                                            .constructor(Instance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWarmPoolResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WARM_POOL_CONFIGURATION_FIELD,
            INSTANCES_FIELD, NEXT_TOKEN_FIELD));

    private final WarmPoolConfiguration warmPoolConfiguration;

    private final List<Instance> instances;

    private final String nextToken;

    private DescribeWarmPoolResponse(BuilderImpl builder) {
        super(builder);
        this.warmPoolConfiguration = builder.warmPoolConfiguration;
        this.instances = builder.instances;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The warm pool configuration details.
     * </p>
     * 
     * @return The warm pool configuration details.
     */
    public final WarmPoolConfiguration warmPoolConfiguration() {
        return warmPoolConfiguration;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instances that are currently in the warm pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instances that are currently in the warm pool.
     */
    public final List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(warmPoolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWarmPoolResponse)) {
            return false;
        }
        DescribeWarmPoolResponse other = (DescribeWarmPoolResponse) obj;
        return Objects.equals(warmPoolConfiguration(), other.warmPoolConfiguration()) && hasInstances() == other.hasInstances()
                && Objects.equals(instances(), other.instances()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWarmPoolResponse").add("WarmPoolConfiguration", warmPoolConfiguration())
                .add("Instances", hasInstances() ? instances() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WarmPoolConfiguration":
            return Optional.ofNullable(clazz.cast(warmPoolConfiguration()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWarmPoolResponse, T> g) {
        return obj -> g.apply((DescribeWarmPoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWarmPoolResponse> {
        /**
         * <p>
         * The warm pool configuration details.
         * </p>
         * 
         * @param warmPoolConfiguration
         *        The warm pool configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmPoolConfiguration(WarmPoolConfiguration warmPoolConfiguration);

        /**
         * <p>
         * The warm pool configuration details.
         * </p>
         * This is a convenience that creates an instance of the {@link WarmPoolConfiguration.Builder} avoiding the need
         * to create one manually via {@link WarmPoolConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link WarmPoolConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #warmPoolConfiguration(WarmPoolConfiguration)}.
         * 
         * @param warmPoolConfiguration
         *        a consumer that will call methods on {@link WarmPoolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmPoolConfiguration(WarmPoolConfiguration)
         */
        default Builder warmPoolConfiguration(Consumer<WarmPoolConfiguration.Builder> warmPoolConfiguration) {
            return warmPoolConfiguration(WarmPoolConfiguration.builder().applyMutation(warmPoolConfiguration).build());
        }

        /**
         * <p>
         * The instances that are currently in the warm pool.
         * </p>
         * 
         * @param instances
         *        The instances that are currently in the warm pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * The instances that are currently in the warm pool.
         * </p>
         * 
         * @param instances
         *        The instances that are currently in the warm pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * The instances that are currently in the warm pool.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Instance>.Builder} avoiding the need to
         * create one manually via {@link List<Instance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Instance>.Builder#build()} is called immediately and its
         * result is passed to {@link #instances(List<Instance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<Instance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<Instance>)
         */
        Builder instances(Consumer<Instance.Builder>... instances);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private WarmPoolConfiguration warmPoolConfiguration;

        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWarmPoolResponse model) {
            super(model);
            warmPoolConfiguration(model.warmPoolConfiguration);
            instances(model.instances);
            nextToken(model.nextToken);
        }

        public final WarmPoolConfiguration.Builder getWarmPoolConfiguration() {
            return warmPoolConfiguration != null ? warmPoolConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder warmPoolConfiguration(WarmPoolConfiguration warmPoolConfiguration) {
            this.warmPoolConfiguration = warmPoolConfiguration;
            return this;
        }

        public final void setWarmPoolConfiguration(WarmPoolConfiguration.BuilderImpl warmPoolConfiguration) {
            this.warmPoolConfiguration = warmPoolConfiguration != null ? warmPoolConfiguration.build() : null;
        }

        public final Collection<Instance.Builder> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances != null ? instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> Instance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeWarmPoolResponse build() {
            return new DescribeWarmPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
