/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance refresh for an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceRefresh implements SdkPojo, Serializable, ToCopyableBuilder<InstanceRefresh.Builder, InstanceRefresh> {
    private static final SdkField<String> INSTANCE_REFRESH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceRefreshId").getter(getter(InstanceRefresh::instanceRefreshId))
            .setter(setter(Builder::instanceRefreshId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRefreshId").build()).build();

    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(InstanceRefresh::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InstanceRefresh::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(InstanceRefresh::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(InstanceRefresh::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(InstanceRefresh::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Integer> PERCENTAGE_COMPLETE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentageComplete").getter(getter(InstanceRefresh::percentageComplete))
            .setter(setter(Builder::percentageComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageComplete").build())
            .build();

    private static final SdkField<Integer> INSTANCES_TO_UPDATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstancesToUpdate").getter(getter(InstanceRefresh::instancesToUpdate))
            .setter(setter(Builder::instancesToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToUpdate").build()).build();

    private static final SdkField<InstanceRefreshProgressDetails> PROGRESS_DETAILS_FIELD = SdkField
            .<InstanceRefreshProgressDetails> builder(MarshallingType.SDK_POJO).memberName("ProgressDetails")
            .getter(getter(InstanceRefresh::progressDetails)).setter(setter(Builder::progressDetails))
            .constructor(InstanceRefreshProgressDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_REFRESH_ID_FIELD,
            AUTO_SCALING_GROUP_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            PERCENTAGE_COMPLETE_FIELD, INSTANCES_TO_UPDATE_FIELD, PROGRESS_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceRefreshId;

    private final String autoScalingGroupName;

    private final String status;

    private final String statusReason;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer percentageComplete;

    private final Integer instancesToUpdate;

    private final InstanceRefreshProgressDetails progressDetails;

    private InstanceRefresh(BuilderImpl builder) {
        this.instanceRefreshId = builder.instanceRefreshId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.percentageComplete = builder.percentageComplete;
        this.instancesToUpdate = builder.instancesToUpdate;
        this.progressDetails = builder.progressDetails;
    }

    /**
     * <p>
     * The instance refresh ID.
     * </p>
     * 
     * @return The instance refresh ID.
     */
    public final String instanceRefreshId() {
        return instanceRefreshId;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The current status for the instance refresh operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Pending</code> - The request was created, but the operation has not started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InProgress</code> - The operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Successful</code> - The operation completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason and the
     * scaling activities.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any
     * replacements that have already been completed, but it prevents new replacements from being started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelled</code> - The operation is cancelled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceRefreshStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the instance refresh operation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Pending</code> - The request was created, but the operation has not started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InProgress</code> - The operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Successful</code> - The operation completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason and
     *         the scaling activities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any
     *         replacements that have already been completed, but it prevents new replacements from being started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelled</code> - The operation is cancelled.
     *         </p>
     *         </li>
     * @see InstanceRefreshStatus
     */
    public final InstanceRefreshStatus status() {
        return InstanceRefreshStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status for the instance refresh operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Pending</code> - The request was created, but the operation has not started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InProgress</code> - The operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Successful</code> - The operation completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason and the
     * scaling activities.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any
     * replacements that have already been completed, but it prevents new replacements from being started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelled</code> - The operation is cancelled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InstanceRefreshStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the instance refresh operation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Pending</code> - The request was created, but the operation has not started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InProgress</code> - The operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Successful</code> - The operation completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason and
     *         the scaling activities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any
     *         replacements that have already been completed, but it prevents new replacements from being started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelled</code> - The operation is cancelled.
     *         </p>
     *         </li>
     * @see InstanceRefreshStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides more details about the current status of the instance refresh.
     * </p>
     * 
     * @return Provides more details about the current status of the instance refresh.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The date and time at which the instance refresh began.
     * </p>
     * 
     * @return The date and time at which the instance refresh began.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time at which the instance refresh ended.
     * </p>
     * 
     * @return The date and time at which the instance refresh ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The percentage of the instance refresh that is complete. For each instance replacement, Amazon EC2 Auto Scaling
     * tracks the instance's health status and warm-up time. When the instance's health status changes to healthy and
     * the specified warm-up time passes, the instance is considered updated and added to the percentage complete.
     * </p>
     * 
     * @return The percentage of the instance refresh that is complete. For each instance replacement, Amazon EC2 Auto
     *         Scaling tracks the instance's health status and warm-up time. When the instance's health status changes
     *         to healthy and the specified warm-up time passes, the instance is considered updated and added to the
     *         percentage complete.
     */
    public final Integer percentageComplete() {
        return percentageComplete;
    }

    /**
     * <p>
     * The number of instances remaining to update before the instance refresh is complete.
     * </p>
     * 
     * @return The number of instances remaining to update before the instance refresh is complete.
     */
    public final Integer instancesToUpdate() {
        return instancesToUpdate;
    }

    /**
     * <p>
     * Additional progress details for an Auto Scaling group that has a warm pool.
     * </p>
     * 
     * @return Additional progress details for an Auto Scaling group that has a warm pool.
     */
    public final InstanceRefreshProgressDetails progressDetails() {
        return progressDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceRefreshId());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(instancesToUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(progressDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRefresh)) {
            return false;
        }
        InstanceRefresh other = (InstanceRefresh) obj;
        return Objects.equals(instanceRefreshId(), other.instanceRefreshId())
                && Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(percentageComplete(), other.percentageComplete())
                && Objects.equals(instancesToUpdate(), other.instancesToUpdate())
                && Objects.equals(progressDetails(), other.progressDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceRefresh").add("InstanceRefreshId", instanceRefreshId())
                .add("AutoScalingGroupName", autoScalingGroupName()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("PercentageComplete", percentageComplete()).add("InstancesToUpdate", instancesToUpdate())
                .add("ProgressDetails", progressDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceRefreshId":
            return Optional.ofNullable(clazz.cast(instanceRefreshId()));
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "PercentageComplete":
            return Optional.ofNullable(clazz.cast(percentageComplete()));
        case "InstancesToUpdate":
            return Optional.ofNullable(clazz.cast(instancesToUpdate()));
        case "ProgressDetails":
            return Optional.ofNullable(clazz.cast(progressDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRefresh, T> g) {
        return obj -> g.apply((InstanceRefresh) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceRefresh> {
        /**
         * <p>
         * The instance refresh ID.
         * </p>
         * 
         * @param instanceRefreshId
         *        The instance refresh ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRefreshId(String instanceRefreshId);

        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The current status for the instance refresh operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Pending</code> - The request was created, but the operation has not started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code> - The operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Successful</code> - The operation completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason and the
         * scaling activities.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any
         * replacements that have already been completed, but it prevents new replacements from being started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelled</code> - The operation is cancelled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status for the instance refresh operation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Pending</code> - The request was created, but the operation has not started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code> - The operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Successful</code> - The operation completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason
         *        and the scaling activities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any
         *        replacements that have already been completed, but it prevents new replacements from being started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelled</code> - The operation is cancelled.
         *        </p>
         *        </li>
         * @see InstanceRefreshStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceRefreshStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status for the instance refresh operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Pending</code> - The request was created, but the operation has not started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code> - The operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Successful</code> - The operation completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason and the
         * scaling activities.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any
         * replacements that have already been completed, but it prevents new replacements from being started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelled</code> - The operation is cancelled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status for the instance refresh operation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Pending</code> - The request was created, but the operation has not started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code> - The operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Successful</code> - The operation completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The operation failed to complete. You can troubleshoot using the status reason
         *        and the scaling activities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelling</code> - An ongoing operation is being cancelled. Cancellation does not roll back any
         *        replacements that have already been completed, but it prevents new replacements from being started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelled</code> - The operation is cancelled.
         *        </p>
         *        </li>
         * @see InstanceRefreshStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceRefreshStatus
         */
        Builder status(InstanceRefreshStatus status);

        /**
         * <p>
         * Provides more details about the current status of the instance refresh.
         * </p>
         * 
         * @param statusReason
         *        Provides more details about the current status of the instance refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The date and time at which the instance refresh began.
         * </p>
         * 
         * @param startTime
         *        The date and time at which the instance refresh began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time at which the instance refresh ended.
         * </p>
         * 
         * @param endTime
         *        The date and time at which the instance refresh ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The percentage of the instance refresh that is complete. For each instance replacement, Amazon EC2 Auto
         * Scaling tracks the instance's health status and warm-up time. When the instance's health status changes to
         * healthy and the specified warm-up time passes, the instance is considered updated and added to the percentage
         * complete.
         * </p>
         * 
         * @param percentageComplete
         *        The percentage of the instance refresh that is complete. For each instance replacement, Amazon EC2
         *        Auto Scaling tracks the instance's health status and warm-up time. When the instance's health status
         *        changes to healthy and the specified warm-up time passes, the instance is considered updated and added
         *        to the percentage complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageComplete(Integer percentageComplete);

        /**
         * <p>
         * The number of instances remaining to update before the instance refresh is complete.
         * </p>
         * 
         * @param instancesToUpdate
         *        The number of instances remaining to update before the instance refresh is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesToUpdate(Integer instancesToUpdate);

        /**
         * <p>
         * Additional progress details for an Auto Scaling group that has a warm pool.
         * </p>
         * 
         * @param progressDetails
         *        Additional progress details for an Auto Scaling group that has a warm pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressDetails(InstanceRefreshProgressDetails progressDetails);

        /**
         * <p>
         * Additional progress details for an Auto Scaling group that has a warm pool.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceRefreshProgressDetails.Builder} avoiding
         * the need to create one manually via {@link InstanceRefreshProgressDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceRefreshProgressDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #progressDetails(InstanceRefreshProgressDetails)}.
         * 
         * @param progressDetails
         *        a consumer that will call methods on {@link InstanceRefreshProgressDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressDetails(InstanceRefreshProgressDetails)
         */
        default Builder progressDetails(Consumer<InstanceRefreshProgressDetails.Builder> progressDetails) {
            return progressDetails(InstanceRefreshProgressDetails.builder().applyMutation(progressDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceRefreshId;

        private String autoScalingGroupName;

        private String status;

        private String statusReason;

        private Instant startTime;

        private Instant endTime;

        private Integer percentageComplete;

        private Integer instancesToUpdate;

        private InstanceRefreshProgressDetails progressDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRefresh model) {
            instanceRefreshId(model.instanceRefreshId);
            autoScalingGroupName(model.autoScalingGroupName);
            status(model.status);
            statusReason(model.statusReason);
            startTime(model.startTime);
            endTime(model.endTime);
            percentageComplete(model.percentageComplete);
            instancesToUpdate(model.instancesToUpdate);
            progressDetails(model.progressDetails);
        }

        public final String getInstanceRefreshId() {
            return instanceRefreshId;
        }

        @Override
        public final Builder instanceRefreshId(String instanceRefreshId) {
            this.instanceRefreshId = instanceRefreshId;
            return this;
        }

        public final void setInstanceRefreshId(String instanceRefreshId) {
            this.instanceRefreshId = instanceRefreshId;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceRefreshStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getPercentageComplete() {
            return percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final void setPercentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        public final Integer getInstancesToUpdate() {
            return instancesToUpdate;
        }

        @Override
        public final Builder instancesToUpdate(Integer instancesToUpdate) {
            this.instancesToUpdate = instancesToUpdate;
            return this;
        }

        public final void setInstancesToUpdate(Integer instancesToUpdate) {
            this.instancesToUpdate = instancesToUpdate;
        }

        public final InstanceRefreshProgressDetails.Builder getProgressDetails() {
            return progressDetails != null ? progressDetails.toBuilder() : null;
        }

        @Override
        public final Builder progressDetails(InstanceRefreshProgressDetails progressDetails) {
            this.progressDetails = progressDetails;
            return this;
        }

        public final void setProgressDetails(InstanceRefreshProgressDetails.BuilderImpl progressDetails) {
            this.progressDetails = progressDetails != null ? progressDetails.build() : null;
        }

        @Override
        public InstanceRefresh build() {
            return new InstanceRefresh(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
