/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutoScalingGroupRequest extends AutoScalingRequest implements
        ToCopyableBuilder<CreateAutoScalingGroupRequest.Builder, CreateAutoScalingGroupRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(CreateAutoScalingGroupRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName").getter(getter(CreateAutoScalingGroupRequest::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("LaunchTemplate")
            .getter(getter(CreateAutoScalingGroupRequest::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<MixedInstancesPolicy> MIXED_INSTANCES_POLICY_FIELD = SdkField
            .<MixedInstancesPolicy> builder(MarshallingType.SDK_POJO).memberName("MixedInstancesPolicy")
            .getter(getter(CreateAutoScalingGroupRequest::mixedInstancesPolicy)).setter(setter(Builder::mixedInstancesPolicy))
            .constructor(MixedInstancesPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateAutoScalingGroupRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(CreateAutoScalingGroupRequest::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(CreateAutoScalingGroupRequest::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredCapacity").getter(getter(CreateAutoScalingGroupRequest::desiredCapacity))
            .setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()).build();

    private static final SdkField<Integer> DEFAULT_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultCooldown").getter(getter(CreateAutoScalingGroupRequest::defaultCooldown))
            .setter(setter(Builder::defaultCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCooldown").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(CreateAutoScalingGroupRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerNames")
            .getter(getter(CreateAutoScalingGroupRequest::loadBalancerNames))
            .setter(setter(Builder::loadBalancerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_GROUP_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetGroupARNs")
            .getter(getter(CreateAutoScalingGroupRequest::targetGroupARNs))
            .setter(setter(Builder::targetGroupARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckType").getter(getter(CreateAutoScalingGroupRequest::healthCheckType))
            .setter(setter(Builder::healthCheckType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthCheckGracePeriod").getter(getter(CreateAutoScalingGroupRequest::healthCheckGracePeriod))
            .setter(setter(Builder::healthCheckGracePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build())
            .build();

    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementGroup").getter(getter(CreateAutoScalingGroupRequest::placementGroup))
            .setter(setter(Builder::placementGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").build()).build();

    private static final SdkField<String> VPC_ZONE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VPCZoneIdentifier").getter(getter(CreateAutoScalingGroupRequest::vpcZoneIdentifier))
            .setter(setter(Builder::vpcZoneIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCZoneIdentifier").build()).build();

    private static final SdkField<List<String>> TERMINATION_POLICIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TerminationPolicies")
            .getter(getter(CreateAutoScalingGroupRequest::terminationPolicies))
            .setter(setter(Builder::terminationPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NewInstancesProtectedFromScaleIn")
            .getter(getter(CreateAutoScalingGroupRequest::newInstancesProtectedFromScaleIn))
            .setter(setter(Builder::newInstancesProtectedFromScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInstancesProtectedFromScaleIn")
                    .build()).build();

    private static final SdkField<Boolean> CAPACITY_REBALANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CapacityRebalance").getter(getter(CreateAutoScalingGroupRequest::capacityRebalance))
            .setter(setter(Builder::capacityRebalance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance").build()).build();

    private static final SdkField<List<LifecycleHookSpecification>> LIFECYCLE_HOOK_SPECIFICATION_LIST_FIELD = SdkField
            .<List<LifecycleHookSpecification>> builder(MarshallingType.LIST)
            .memberName("LifecycleHookSpecificationList")
            .getter(getter(CreateAutoScalingGroupRequest::lifecycleHookSpecificationList))
            .setter(setter(Builder::lifecycleHookSpecificationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookSpecificationList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecycleHookSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecycleHookSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAutoScalingGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceLinkedRoleARN").getter(getter(CreateAutoScalingGroupRequest::serviceLinkedRoleARN))
            .setter(setter(Builder::serviceLinkedRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRoleARN").build())
            .build();

    private static final SdkField<Integer> MAX_INSTANCE_LIFETIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInstanceLifetime").getter(getter(CreateAutoScalingGroupRequest::maxInstanceLifetime))
            .setter(setter(Builder::maxInstanceLifetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceLifetime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, MIXED_INSTANCES_POLICY_FIELD, INSTANCE_ID_FIELD,
            MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD, DEFAULT_COOLDOWN_FIELD, AVAILABILITY_ZONES_FIELD,
            LOAD_BALANCER_NAMES_FIELD, TARGET_GROUP_AR_NS_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD,
            PLACEMENT_GROUP_FIELD, VPC_ZONE_IDENTIFIER_FIELD, TERMINATION_POLICIES_FIELD,
            NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD, CAPACITY_REBALANCE_FIELD, LIFECYCLE_HOOK_SPECIFICATION_LIST_FIELD,
            TAGS_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD, MAX_INSTANCE_LIFETIME_FIELD));

    private final String autoScalingGroupName;

    private final String launchConfigurationName;

    private final LaunchTemplateSpecification launchTemplate;

    private final MixedInstancesPolicy mixedInstancesPolicy;

    private final String instanceId;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private final Integer defaultCooldown;

    private final List<String> availabilityZones;

    private final List<String> loadBalancerNames;

    private final List<String> targetGroupARNs;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final String placementGroup;

    private final String vpcZoneIdentifier;

    private final List<String> terminationPolicies;

    private final Boolean newInstancesProtectedFromScaleIn;

    private final Boolean capacityRebalance;

    private final List<LifecycleHookSpecification> lifecycleHookSpecificationList;

    private final List<Tag> tags;

    private final String serviceLinkedRoleARN;

    private final Integer maxInstanceLifetime;

    private CreateAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.instanceId = builder.instanceId;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.targetGroupARNs = builder.targetGroupARNs;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.capacityRebalance = builder.capacityRebalance;
        this.lifecycleHookSpecificationList = builder.lifecycleHookSpecificationList;
        this.tags = builder.tags;
        this.serviceLinkedRoleARN = builder.serviceLinkedRoleARN;
        this.maxInstanceLifetime = builder.maxInstanceLifetime;
    }

    /**
     * <p>
     * The name of the Auto Scaling group. This name must be unique per Region per account.
     * </p>
     * 
     * @return The name of the Auto Scaling group. This name must be unique per Region per account.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the launch configuration to use to launch instances.
     * </p>
     * <p>
     * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
     * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
     * <code>InstanceId</code>).
     * </p>
     * 
     * @return The name of the launch configuration to use to launch instances. </p>
     *         <p>
     *         Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
     *         <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
     *         <code>InstanceId</code>).
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * Parameters used to specify the launch template and version to use to launch instances.
     * </p>
     * <p>
     * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
     * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
     * <code>InstanceId</code>).
     * </p>
     * <note>
     * <p>
     * The launch template that is specified must be configured for use with an Auto Scaling group. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a launch
     * template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * </note>
     * 
     * @return Parameters used to specify the launch template and version to use to launch instances. </p>
     *         <p>
     *         Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
     *         <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
     *         <code>InstanceId</code>).
     *         </p>
     *         <note>
     *         <p>
     *         The launch template that is specified must be configured for use with an Auto Scaling group. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a
     *         launch template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         </p>
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * An embedded object that specifies a mixed instances policy. The required properties must be specified. If
     * optional properties are unspecified, their default values are used.
     * </p>
     * <p>
     * The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances,
     * the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates instance types to fulfill
     * On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the
     * launch template and instance types. The policy can also include a weight for each instance type and different
     * launch templates for individual instance types. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling groups with
     * multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return An embedded object that specifies a mixed instances policy. The required properties must be specified. If
     *         optional properties are unspecified, their default values are used.</p>
     *         <p>
     *         The policy includes properties that not only define the distribution of On-Demand Instances and Spot
     *         Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates instance
     *         types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance
     *         configuration information—the launch template and instance types. The policy can also include a weight
     *         for each instance type and different launch templates for individual instance types. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling
     *         groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final MixedInstancesPolicy mixedInstancesPolicy() {
        return mixedInstancesPolicy;
    }

    /**
     * <p>
     * The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the
     * configuration values from the specified instance to create a new launch configuration. To get the instance ID,
     * use the Amazon EC2 <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a>
     * API operation. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto
     * Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling
     *         uses the configuration values from the specified instance to create a new launch configuration. To get
     *         the instance ID, use the Amazon EC2 <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
     *         >DescribeInstances</a> API operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an
     *         Auto Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The minimum size of the group.
     * </p>
     * 
     * @return The minimum size of the group.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the group.
     * </p>
     * <note>
     * <p>
     * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
     * <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go
     * above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each
     * instance contributes to the desired capacity of the group).
     * </p>
     * </note>
     * 
     * @return The maximum size of the group.</p> <note>
     *         <p>
     *         With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
     *         <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will
     *         never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how
     *         many units each instance contributes to the desired capacity of the group).
     *         </p>
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the
     * capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number
     * must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the
     * group. If you do not specify a desired capacity, the default is the minimum size of the group.
     * </p>
     * 
     * @return The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and
     *         the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling.
     *         This number must be greater than or equal to the minimum size of the group and less than or equal to the
     *         maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of
     *         the group.
     */
    public final Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The
     * default value is <code>300</code>. This setting applies when using simple scaling policies, but not when using
     * other scaling policies or scheduled scaling. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto
     * Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scaling activity completes before another scaling activity can
     *         start. The default value is <code>300</code>. This setting applies when using simple scaling policies,
     *         but not when using other scaling policies or scheduled scaling. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon
     *         EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Integer defaultCooldown() {
        return defaultCooldown;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is optional
     * if you specify one or more subnets for <code>VPCZoneIdentifier</code>.
     * </p>
     * <p>
     * Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into
     * EC2-Classic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is
     *         optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.</p>
     *         <p>
     *         Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances
     *         into EC2-Classic.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * Returns true if the LoadBalancerNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLoadBalancerNames() {
        return loadBalancerNames != null && !(loadBalancerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network
     * Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoadBalancerNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers,
     *         Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property
     *         instead.
     */
    public final List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * Returns true if the TargetGroupARNs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTargetGroupARNs() {
        return targetGroupARNs != null && !(targetGroupARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are
     * registered as targets in a target group, and traffic is routed to the target group. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load
     * Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetGroupARNs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances
     *         are registered as targets in a target group, and traffic is routed to the target group. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load
     *         Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final List<String> targetGroupARNs() {
        return targetGroupARNs;
    }

    /**
     * <p>
     * The service to use for the health checks. The valid values are <code>EC2</code> (default) and <code>ELB</code>.
     * If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance
     * unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see
     * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling
     * instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The service to use for the health checks. The valid values are <code>EC2</code> (default) and
     *         <code>ELB</code>. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it
     *         considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health
     *         checks. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto
     *         Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2
     * instance that has come into service. During this time, any health check failures for the instance are ignored.
     * The default value is <code>0</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health
     * check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Conditional: Required if you are adding an <code>ELB</code> health check.
     * </p>
     * 
     * @return The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of
     *         an EC2 instance that has come into service. During this time, any health check failures for the instance
     *         are ignored. The default value is <code>0</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period"
     *         >Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
     *         <p>
     *         Conditional: Required if you are adding an <code>ELB</code> health check.
     */
    public final Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * <p>
     * The name of an existing placement group into which to launch your instances, if any. A placement group is a
     * logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones
     * and a placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
     * <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @return The name of an existing placement group into which to launch your instances, if any. A placement group is
     *         a logical grouping of instances within a single Availability Zone. You cannot specify multiple
     *         Availability Zones and a placement group. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in
     *         the <i>Amazon EC2 User Guide for Linux Instances</i>.
     */
    public final String placementGroup() {
        return placementGroup;
    }

    /**
     * <p>
     * A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group
     * can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets
     * that you specify for this parameter must reside in those Availability Zones.
     * </p>
     * <p>
     * Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into a
     * VPC.
     * </p>
     * 
     * @return A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto
     *         Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with
     *         <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those
     *         Availability Zones.</p>
     *         <p>
     *         Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances
     *         into a VPC.
     */
    public final String vpcZoneIdentifier() {
        return vpcZoneIdentifier;
    }

    /**
     * Returns true if the TerminationPolicies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTerminationPolicies() {
        return terminationPolicies != null && !(terminationPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A policy or a list of policies that are used to select the instance to terminate. These policies are executed in
     * the order that you list them. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto
     * Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTerminationPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A policy or a list of policies that are used to select the instance to terminate. These policies are
     *         executed in the order that you list them. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling
     *         which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final List<String> terminationPolicies() {
        return terminationPolicies;
    }

    /**
     * <p>
     * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling
     * in. For more information about preventing instances from terminating on scale in, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     * >Instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when
     *         scaling in. For more information about preventing instances from terminating on scale in, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     *         >Instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Boolean newInstancesProtectedFromScaleIn() {
        return newInstancesProtectedFromScaleIn;
    }

    /**
     * <p>
     * Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on
     * Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies
     * that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates
     * an old instance. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/capacity-rebalance.html">Amazon EC2 Auto Scaling
     * Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you
     *         turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon
     *         EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance,
     *         it then terminates an old instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/capacity-rebalance.html">Amazon EC2 Auto
     *         Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final Boolean capacityRebalance() {
        return capacityRebalance;
    }

    /**
     * Returns true if the LifecycleHookSpecificationList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasLifecycleHookSpecificationList() {
        return lifecycleHookSpecificationList != null && !(lifecycleHookSpecificationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches
     * or terminates instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLifecycleHookSpecificationList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling
     *         launches or terminates instances.
     */
    public final List<LifecycleHookSpecification> lifecycleHookSpecificationList() {
        return lifecycleHookSpecificationList;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it
     * launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a
     * launch template but use caution. If the launch template specifies an instance tag with a key that is also
     * specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the
     * value specified by the Auto Scaling group. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups
     * and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances
     *         it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify
     *         the tags in a launch template but use caution. If the launch template specifies an instance tag with a
     *         key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of
     *         that instance tag with the value specified by the Auto Scaling group. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto
     *         Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS
     * services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named
     * AWSServiceRoleForAutoScaling, which it creates if it does not exist. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked
     * roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other
     *         AWS services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named
     *         AWSServiceRoleForAutoScaling, which it creates if it does not exist. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html"
     *         >Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final String serviceLinkedRoleARN() {
        return serviceLinkedRoleARN;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified,
     * the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see
     * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto
     * Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
     *         specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing
     *         Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final Integer maxInstanceLifetime() {
        return maxInstanceLifetime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerNames() ? loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetGroupARNs() ? targetGroupARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTerminationPolicies() ? terminationPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(capacityRebalance());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLifecycleHookSpecificationList() ? lifecycleHookSpecificationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceLinkedRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(maxInstanceLifetime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoScalingGroupRequest)) {
            return false;
        }
        CreateAutoScalingGroupRequest other = (CreateAutoScalingGroupRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(mixedInstancesPolicy(), other.mixedInstancesPolicy())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(desiredCapacity(), other.desiredCapacity())
                && Objects.equals(defaultCooldown(), other.defaultCooldown())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && hasLoadBalancerNames() == other.hasLoadBalancerNames()
                && Objects.equals(loadBalancerNames(), other.loadBalancerNames())
                && hasTargetGroupARNs() == other.hasTargetGroupARNs()
                && Objects.equals(targetGroupARNs(), other.targetGroupARNs())
                && Objects.equals(healthCheckType(), other.healthCheckType())
                && Objects.equals(healthCheckGracePeriod(), other.healthCheckGracePeriod())
                && Objects.equals(placementGroup(), other.placementGroup())
                && Objects.equals(vpcZoneIdentifier(), other.vpcZoneIdentifier())
                && hasTerminationPolicies() == other.hasTerminationPolicies()
                && Objects.equals(terminationPolicies(), other.terminationPolicies())
                && Objects.equals(newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn())
                && Objects.equals(capacityRebalance(), other.capacityRebalance())
                && hasLifecycleHookSpecificationList() == other.hasLifecycleHookSpecificationList()
                && Objects.equals(lifecycleHookSpecificationList(), other.lifecycleHookSpecificationList())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(serviceLinkedRoleARN(), other.serviceLinkedRoleARN())
                && Objects.equals(maxInstanceLifetime(), other.maxInstanceLifetime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateAutoScalingGroupRequest")
                .add("AutoScalingGroupName", autoScalingGroupName())
                .add("LaunchConfigurationName", launchConfigurationName())
                .add("LaunchTemplate", launchTemplate())
                .add("MixedInstancesPolicy", mixedInstancesPolicy())
                .add("InstanceId", instanceId())
                .add("MinSize", minSize())
                .add("MaxSize", maxSize())
                .add("DesiredCapacity", desiredCapacity())
                .add("DefaultCooldown", defaultCooldown())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("LoadBalancerNames", hasLoadBalancerNames() ? loadBalancerNames() : null)
                .add("TargetGroupARNs", hasTargetGroupARNs() ? targetGroupARNs() : null)
                .add("HealthCheckType", healthCheckType())
                .add("HealthCheckGracePeriod", healthCheckGracePeriod())
                .add("PlacementGroup", placementGroup())
                .add("VPCZoneIdentifier", vpcZoneIdentifier())
                .add("TerminationPolicies", hasTerminationPolicies() ? terminationPolicies() : null)
                .add("NewInstancesProtectedFromScaleIn", newInstancesProtectedFromScaleIn())
                .add("CapacityRebalance", capacityRebalance())
                .add("LifecycleHookSpecificationList",
                        hasLifecycleHookSpecificationList() ? lifecycleHookSpecificationList() : null)
                .add("Tags", hasTags() ? tags() : null).add("ServiceLinkedRoleARN", serviceLinkedRoleARN())
                .add("MaxInstanceLifetime", maxInstanceLifetime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "MixedInstancesPolicy":
            return Optional.ofNullable(clazz.cast(mixedInstancesPolicy()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "DesiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        case "DefaultCooldown":
            return Optional.ofNullable(clazz.cast(defaultCooldown()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "LoadBalancerNames":
            return Optional.ofNullable(clazz.cast(loadBalancerNames()));
        case "TargetGroupARNs":
            return Optional.ofNullable(clazz.cast(targetGroupARNs()));
        case "HealthCheckType":
            return Optional.ofNullable(clazz.cast(healthCheckType()));
        case "HealthCheckGracePeriod":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriod()));
        case "PlacementGroup":
            return Optional.ofNullable(clazz.cast(placementGroup()));
        case "VPCZoneIdentifier":
            return Optional.ofNullable(clazz.cast(vpcZoneIdentifier()));
        case "TerminationPolicies":
            return Optional.ofNullable(clazz.cast(terminationPolicies()));
        case "NewInstancesProtectedFromScaleIn":
            return Optional.ofNullable(clazz.cast(newInstancesProtectedFromScaleIn()));
        case "CapacityRebalance":
            return Optional.ofNullable(clazz.cast(capacityRebalance()));
        case "LifecycleHookSpecificationList":
            return Optional.ofNullable(clazz.cast(lifecycleHookSpecificationList()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ServiceLinkedRoleARN":
            return Optional.ofNullable(clazz.cast(serviceLinkedRoleARN()));
        case "MaxInstanceLifetime":
            return Optional.ofNullable(clazz.cast(maxInstanceLifetime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoScalingGroupRequest, T> g) {
        return obj -> g.apply((CreateAutoScalingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAutoScalingGroupRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group. This name must be unique per Region per account.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group. This name must be unique per Region per account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the launch configuration to use to launch instances.
         * </p>
         * <p>
         * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         * <code>InstanceId</code>).
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration to use to launch instances. </p>
         *        <p>
         *        Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         *        <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         *        <code>InstanceId</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * Parameters used to specify the launch template and version to use to launch instances.
         * </p>
         * <p>
         * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         * <code>InstanceId</code>).
         * </p>
         * <note>
         * <p>
         * The launch template that is specified must be configured for use with an Auto Scaling group. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a launch
         * template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * </note>
         * 
         * @param launchTemplate
         *        Parameters used to specify the launch template and version to use to launch instances. </p>
         *        <p>
         *        Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         *        <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         *        <code>InstanceId</code>).
         *        </p>
         *        <note>
         *        <p>
         *        The launch template that is specified must be configured for use with an Auto Scaling group. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a
         *        launch template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * Parameters used to specify the launch template and version to use to launch instances.
         * </p>
         * <p>
         * Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or
         * <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or
         * <code>InstanceId</code>).
         * </p>
         * <note>
         * <p>
         * The launch template that is specified must be configured for use with an Auto Scaling group. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a launch
         * template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link LaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * An embedded object that specifies a mixed instances policy. The required properties must be specified. If
         * optional properties are unspecified, their default values are used.
         * </p>
         * <p>
         * The policy includes properties that not only define the distribution of On-Demand Instances and Spot
         * Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates instance
         * types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance
         * configuration information—the launch template and instance types. The policy can also include a weight for
         * each instance type and different launch templates for individual instance types. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling groups
         * with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param mixedInstancesPolicy
         *        An embedded object that specifies a mixed instances policy. The required properties must be specified.
         *        If optional properties are unspecified, their default values are used.</p>
         *        <p>
         *        The policy includes properties that not only define the distribution of On-Demand Instances and Spot
         *        Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates
         *        instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the
         *        instance configuration information—the launch template and instance types. The policy can also include
         *        a weight for each instance type and different launch templates for individual instance types. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling
         *        groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy);

        /**
         * <p>
         * An embedded object that specifies a mixed instances policy. The required properties must be specified. If
         * optional properties are unspecified, their default values are used.
         * </p>
         * <p>
         * The policy includes properties that not only define the distribution of On-Demand Instances and Spot
         * Instances, the maximum price to pay for Spot Instances, and how the Auto Scaling group allocates instance
         * types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance
         * configuration information—the launch template and instance types. The policy can also include a weight for
         * each instance type and different launch templates for individual instance types. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling groups
         * with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link MixedInstancesPolicy.Builder} avoiding the need
         * to create one manually via {@link MixedInstancesPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link MixedInstancesPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #mixedInstancesPolicy(MixedInstancesPolicy)}.
         * 
         * @param mixedInstancesPolicy
         *        a consumer that will call methods on {@link MixedInstancesPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedInstancesPolicy(MixedInstancesPolicy)
         */
        default Builder mixedInstancesPolicy(Consumer<MixedInstancesPolicy.Builder> mixedInstancesPolicy) {
            return mixedInstancesPolicy(MixedInstancesPolicy.builder().applyMutation(mixedInstancesPolicy).build());
        }

        /**
         * <p>
         * The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses
         * the configuration values from the specified instance to create a new launch configuration. To get the
         * instance ID, use the Amazon EC2 <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
         * >DescribeInstances</a> API operation. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto
         * Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling
         *        uses the configuration values from the specified instance to create a new launch configuration. To get
         *        the instance ID, use the Amazon EC2 <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html"
         *        >DescribeInstances</a> API operation. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an
         *        Auto Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The minimum size of the group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the group.
         * </p>
         * <note>
         * <p>
         * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above
         * <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go
         * above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each
         * instance contributes to the desired capacity of the group).
         * </p>
         * </note>
         * 
         * @param maxSize
         *        The maximum size of the group.</p> <note>
         *        <p>
         *        With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go
         *        above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling
         *        will never go above <code>MaxSize</code> by more than your largest instance weight (weights that
         *        define how many units each instance contributes to the desired capacity of the group).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the
         * capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This
         * number must be greater than or equal to the minimum size of the group and less than or equal to the maximum
         * size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and
         *        the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling.
         *        This number must be greater than or equal to the minimum size of the group and less than or equal to
         *        the maximum size of the group. If you do not specify a desired capacity, the default is the minimum
         *        size of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
         * The default value is <code>300</code>. This setting applies when using simple scaling policies, but not when
         * using other scaling policies or scheduled scaling. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2
         * Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param defaultCooldown
         *        The amount of time, in seconds, after a scaling activity completes before another scaling activity can
         *        start. The default value is <code>300</code>. This setting applies when using simple scaling policies,
         *        but not when using other scaling policies or scheduled scaling. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for
         *        Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCooldown(Integer defaultCooldown);

        /**
         * <p>
         * A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is
         * optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.
         * </p>
         * <p>
         * Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances
         * into EC2-Classic.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter
         *        is optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.</p>
         *        <p>
         *        Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch
         *        instances into EC2-Classic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is
         * optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.
         * </p>
         * <p>
         * Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances
         * into EC2-Classic.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter
         *        is optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.</p>
         *        <p>
         *        Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch
         *        instances into EC2-Classic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers,
         * Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property
         * instead.
         * </p>
         * 
         * @param loadBalancerNames
         *        A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load
         *        Balancers, Network Load Balancers, and Gateway Load Balancers, specify the
         *        <code>TargetGroupARNs</code> property instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers,
         * Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property
         * instead.
         * </p>
         * 
         * @param loadBalancerNames
         *        A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load
         *        Balancers, Network Load Balancers, and Gateway Load Balancers, specify the
         *        <code>TargetGroupARNs</code> property instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are
         * registered as targets in a target group, and traffic is routed to the target group. For more information, see
         * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load
         * Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group.
         *        Instances are registered as targets in a target group, and traffic is routed to the target group. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic
         *        Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(Collection<String> targetGroupARNs);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are
         * registered as targets in a target group, and traffic is routed to the target group. For more information, see
         * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load
         * Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param targetGroupARNs
         *        The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group.
         *        Instances are registered as targets in a target group, and traffic is routed to the target group. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic
         *        Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupARNs(String... targetGroupARNs);

        /**
         * <p>
         * The service to use for the health checks. The valid values are <code>EC2</code> (default) and
         * <code>ELB</code>. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it
         * considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling
         * instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param healthCheckType
         *        The service to use for the health checks. The valid values are <code>EC2</code> (default) and
         *        <code>ELB</code>. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it
         *        considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health
         *        checks. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto
         *        Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an
         * EC2 instance that has come into service. During this time, any health check failures for the instance are
         * ignored. The default value is <code>0</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period"
         * >Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * Conditional: Required if you are adding an <code>ELB</code> health check.
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status
         *        of an EC2 instance that has come into service. During this time, any health check failures for the
         *        instance are ignored. The default value is <code>0</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period"
         *        >Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
         *        <p>
         *        Conditional: Required if you are adding an <code>ELB</code> health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * The name of an existing placement group into which to launch your instances, if any. A placement group is a
         * logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability
         * Zones and a placement group. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * 
         * @param placementGroup
         *        The name of an existing placement group into which to launch your instances, if any. A placement group
         *        is a logical grouping of instances within a single Availability Zone. You cannot specify multiple
         *        Availability Zones and a placement group. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a>
         *        in the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(String placementGroup);

        /**
         * <p>
         * A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling
         * group can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the
         * subnets that you specify for this parameter must reside in those Availability Zones.
         * </p>
         * <p>
         * Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances
         * into a VPC.
         * </p>
         * 
         * @param vpcZoneIdentifier
         *        A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto
         *        Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with
         *        <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those
         *        Availability Zones.</p>
         *        <p>
         *        Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch
         *        instances into a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcZoneIdentifier(String vpcZoneIdentifier);

        /**
         * <p>
         * A policy or a list of policies that are used to select the instance to terminate. These policies are executed
         * in the order that you list them. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which
         * Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param terminationPolicies
         *        A policy or a list of policies that are used to select the instance to terminate. These policies are
         *        executed in the order that you list them. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling
         *        which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(Collection<String> terminationPolicies);

        /**
         * <p>
         * A policy or a list of policies that are used to select the instance to terminate. These policies are executed
         * in the order that you list them. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which
         * Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param terminationPolicies
         *        A policy or a list of policies that are used to select the instance to terminate. These policies are
         *        executed in the order that you list them. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling
         *        which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(String... terminationPolicies);

        /**
         * <p>
         * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when
         * scaling in. For more information about preventing instances from terminating on scale in, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
         * >Instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param newInstancesProtectedFromScaleIn
         *        Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling
         *        when scaling in. For more information about preventing instances from terminating on scale in, see <a
         *        href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
         *        >Instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn);

        /**
         * <p>
         * Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn
         * on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2
         * notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then
         * terminates an old instance. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/capacity-rebalance.html">Amazon EC2 Auto Scaling
         * Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param capacityRebalance
         *        Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When
         *        you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever
         *        Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new
         *        instance, it then terminates an old instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/capacity-rebalance.html">Amazon EC2 Auto
         *        Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityRebalance(Boolean capacityRebalance);

        /**
         * <p>
         * One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling
         * launches or terminates instances.
         * </p>
         * 
         * @param lifecycleHookSpecificationList
         *        One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto
         *        Scaling launches or terminates instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> lifecycleHookSpecificationList);

        /**
         * <p>
         * One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling
         * launches or terminates instances.
         * </p>
         * 
         * @param lifecycleHookSpecificationList
         *        One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto
         *        Scaling launches or terminates instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookSpecificationList(LifecycleHookSpecification... lifecycleHookSpecificationList);

        /**
         * <p>
         * One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling
         * launches or terminates instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LifecycleHookSpecification>.Builder}
         * avoiding the need to create one manually via {@link List<LifecycleHookSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LifecycleHookSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #lifecycleHookSpecificationList(List<LifecycleHookSpecification>)}.
         * 
         * @param lifecycleHookSpecificationList
         *        a consumer that will call methods on {@link List<LifecycleHookSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleHookSpecificationList(List<LifecycleHookSpecification>)
         */
        Builder lifecycleHookSpecificationList(Consumer<LifecycleHookSpecification.Builder>... lifecycleHookSpecificationList);

        /**
         * <p>
         * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it
         * launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags
         * in a launch template but use caution. If the launch template specifies an instance tag with a key that is
         * also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag
         * with the value specified by the Auto Scaling group. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling
         * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param tags
         *        One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2
         *        instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS
         *        volumes, specify the tags in a launch template but use caution. If the launch template specifies an
         *        instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling
         *        overrides the value of that instance tag with the value specified by the Auto Scaling group. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto
         *        Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it
         * launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags
         * in a launch template but use caution. If the launch template specifies an instance tag with a key that is
         * also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag
         * with the value specified by the Auto Scaling group. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling
         * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param tags
         *        One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2
         *        instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS
         *        volumes, specify the tags in a launch template but use caution. If the launch template specifies an
         *        instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling
         *        overrides the value of that instance tag with the value specified by the Auto Scaling group. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto
         *        Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it
         * launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags
         * in a launch template but use caution. If the launch template specifies an instance tag with a key that is
         * also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag
         * with the value specified by the Auto Scaling group. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling
         * groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS
         * services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named
         * AWSServiceRoleForAutoScaling, which it creates if it does not exist. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html"
         * >Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param serviceLinkedRoleARN
         *        The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call
         *        other AWS services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role
         *        named AWSServiceRoleForAutoScaling, which it creates if it does not exist. For more information, see
         *        <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">
         *        Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkedRoleARN(String serviceLinkedRoleARN);

        /**
         * <p>
         * The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
         * specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more
         * information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto
         * Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param maxInstanceLifetime
         *        The maximum amount of time, in seconds, that an instance can be in service. The default is null. If
         *        specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing
         *        Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInstanceLifetime(Integer maxInstanceLifetime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String launchConfigurationName;

        private LaunchTemplateSpecification launchTemplate;

        private MixedInstancesPolicy mixedInstancesPolicy;

        private String instanceId;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private Integer defaultCooldown;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetGroupARNs = DefaultSdkAutoConstructList.getInstance();

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private String placementGroup;

        private String vpcZoneIdentifier;

        private List<String> terminationPolicies = DefaultSdkAutoConstructList.getInstance();

        private Boolean newInstancesProtectedFromScaleIn;

        private Boolean capacityRebalance;

        private List<LifecycleHookSpecification> lifecycleHookSpecificationList = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String serviceLinkedRoleARN;

        private Integer maxInstanceLifetime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoScalingGroupRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            launchConfigurationName(model.launchConfigurationName);
            launchTemplate(model.launchTemplate);
            mixedInstancesPolicy(model.mixedInstancesPolicy);
            instanceId(model.instanceId);
            minSize(model.minSize);
            maxSize(model.maxSize);
            desiredCapacity(model.desiredCapacity);
            defaultCooldown(model.defaultCooldown);
            availabilityZones(model.availabilityZones);
            loadBalancerNames(model.loadBalancerNames);
            targetGroupARNs(model.targetGroupARNs);
            healthCheckType(model.healthCheckType);
            healthCheckGracePeriod(model.healthCheckGracePeriod);
            placementGroup(model.placementGroup);
            vpcZoneIdentifier(model.vpcZoneIdentifier);
            terminationPolicies(model.terminationPolicies);
            newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            capacityRebalance(model.capacityRebalance);
            lifecycleHookSpecificationList(model.lifecycleHookSpecificationList);
            tags(model.tags);
            serviceLinkedRoleARN(model.serviceLinkedRoleARN);
            maxInstanceLifetime(model.maxInstanceLifetime);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final MixedInstancesPolicy.Builder getMixedInstancesPolicy() {
            return mixedInstancesPolicy != null ? mixedInstancesPolicy.toBuilder() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final void setMixedInstancesPolicy(MixedInstancesPolicy.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<String> getLoadBalancerNames() {
            if (loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final Collection<String> getTargetGroupARNs() {
            if (targetGroupARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String... targetGroupARNs) {
            targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getPlacementGroup() {
            return placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVpcZoneIdentifier() {
            return vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<String> getTerminationPolicies() {
            if (terminationPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String... terminationPolicies) {
            terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        public final Boolean getCapacityRebalance() {
            return capacityRebalance;
        }

        @Override
        public final Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public final void setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
        }

        public final List<LifecycleHookSpecification.Builder> getLifecycleHookSpecificationList() {
            List<LifecycleHookSpecification.Builder> result = LifecycleHookSpecificationsCopier
                    .copyToBuilder(this.lifecycleHookSpecificationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder lifecycleHookSpecificationList(Collection<LifecycleHookSpecification> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier.copy(lifecycleHookSpecificationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookSpecificationList(LifecycleHookSpecification... lifecycleHookSpecificationList) {
            lifecycleHookSpecificationList(Arrays.asList(lifecycleHookSpecificationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookSpecificationList(
                Consumer<LifecycleHookSpecification.Builder>... lifecycleHookSpecificationList) {
            lifecycleHookSpecificationList(Stream.of(lifecycleHookSpecificationList)
                    .map(c -> LifecycleHookSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLifecycleHookSpecificationList(
                Collection<LifecycleHookSpecification.BuilderImpl> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = LifecycleHookSpecificationsCopier
                    .copyFromBuilder(lifecycleHookSpecificationList);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getServiceLinkedRoleARN() {
            return serviceLinkedRoleARN;
        }

        @Override
        public final Builder serviceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
            return this;
        }

        public final void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        }

        public final Integer getMaxInstanceLifetime() {
            return maxInstanceLifetime;
        }

        @Override
        public final Builder maxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public final void setMaxInstanceLifetime(Integer maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoScalingGroupRequest build() {
            return new CreateAutoScalingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
