/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a target group.
 * </p>
 * <p>
 * If you attach a target group to an existing Auto Scaling group, the initial state is <code>Adding</code>. The state
 * transitions to <code>Added</code> after all Auto Scaling instances are registered with the target group. If Elastic
 * Load Balancing health checks are enabled, the state transitions to <code>InService</code> after at least one Auto
 * Scaling instance passes the health check. If EC2 health checks are enabled instead, the target group remains in the
 * <code>Added</code> state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTargetGroupState implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerTargetGroupState.Builder, LoadBalancerTargetGroupState> {
    private static final SdkField<String> LOAD_BALANCER_TARGET_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerTargetGroupARN")
            .getter(getter(LoadBalancerTargetGroupState::loadBalancerTargetGroupARN))
            .setter(setter(Builder::loadBalancerTargetGroupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTargetGroupARN").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(LoadBalancerTargetGroupState::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOAD_BALANCER_TARGET_GROUP_ARN_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String loadBalancerTargetGroupARN;

    private final String state;

    private LoadBalancerTargetGroupState(BuilderImpl builder) {
        this.loadBalancerTargetGroupARN = builder.loadBalancerTargetGroupARN;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target group.
     */
    public final String loadBalancerTargetGroupARN() {
        return loadBalancerTargetGroupARN;
    }

    /**
     * <p>
     * The state of the target group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Added</code> - All Auto Scaling instances are registered with the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If connection
     * draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before deregistering the
     * instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The state of the target group.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Added</code> - All Auto Scaling instances are registered with the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
     *         connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
     *         deregistering the instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
     *         </p>
     *         </li>
     */
    public final String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerTargetGroupARN());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTargetGroupState)) {
            return false;
        }
        LoadBalancerTargetGroupState other = (LoadBalancerTargetGroupState) obj;
        return Objects.equals(loadBalancerTargetGroupARN(), other.loadBalancerTargetGroupARN())
                && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancerTargetGroupState").add("LoadBalancerTargetGroupARN", loadBalancerTargetGroupARN())
                .add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerTargetGroupARN":
            return Optional.ofNullable(clazz.cast(loadBalancerTargetGroupARN()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTargetGroupState, T> g) {
        return obj -> g.apply((LoadBalancerTargetGroupState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerTargetGroupState> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target group.
         * </p>
         * 
         * @param loadBalancerTargetGroupARN
         *        The Amazon Resource Name (ARN) of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroupARN(String loadBalancerTargetGroupARN);

        /**
         * <p>
         * The state of the target group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Added</code> - All Auto Scaling instances are registered with the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
         * connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
         * deregistering the instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The state of the target group.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Adding</code> - The Auto Scaling instances are being registered with the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Added</code> - All Auto Scaling instances are registered with the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InService</code> - At least one Auto Scaling instance passed an ELB health check.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removing</code> - The Auto Scaling instances are being deregistered from the target group. If
         *        connection draining is enabled, Elastic Load Balancing waits for in-flight requests to complete before
         *        deregistering the instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Removed</code> - All Auto Scaling instances are deregistered from the target group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String loadBalancerTargetGroupARN;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTargetGroupState model) {
            loadBalancerTargetGroupARN(model.loadBalancerTargetGroupARN);
            state(model.state);
        }

        public final String getLoadBalancerTargetGroupARN() {
            return loadBalancerTargetGroupARN;
        }

        @Override
        public final Builder loadBalancerTargetGroupARN(String loadBalancerTargetGroupARN) {
            this.loadBalancerTargetGroupARN = loadBalancerTargetGroupARN;
            return this;
        }

        public final void setLoadBalancerTargetGroupARN(String loadBalancerTargetGroupARN) {
            this.loadBalancerTargetGroupARN = loadBalancerTargetGroupARN;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public LoadBalancerTargetGroupState build() {
            return new LoadBalancerTargetGroupState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
