/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.ActivityIdsCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingActivitiesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
    private static final SdkField<List<String>> ACTIVITY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActivityIds").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::activityIds)).setter(DescribeScalingActivitiesRequest.setter(Builder::activityIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::autoScalingGroupName)).setter(DescribeScalingActivitiesRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<Boolean> INCLUDE_DELETED_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeDeletedGroups").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::includeDeletedGroups)).setter(DescribeScalingActivitiesRequest.setter(Builder::includeDeletedGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDeletedGroups").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::maxRecords)).setter(DescribeScalingActivitiesRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScalingActivitiesRequest.getter(DescribeScalingActivitiesRequest::nextToken)).setter(DescribeScalingActivitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_IDS_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, INCLUDE_DELETED_GROUPS_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> activityIds;
    private final String autoScalingGroupName;
    private final Boolean includeDeletedGroups;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeScalingActivitiesRequest(BuilderImpl builder) {
        super(builder);
        this.activityIds = builder.activityIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.includeDeletedGroups = builder.includeDeletedGroups;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActivityIds() {
        return this.activityIds != null && !(this.activityIds instanceof SdkAutoConstructList);
    }

    public final List<String> activityIds() {
        return this.activityIds;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final Boolean includeDeletedGroups() {
        return this.includeDeletedGroups;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActivityIds() ? this.activityIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeDeletedGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesRequest)) {
            return false;
        }
        DescribeScalingActivitiesRequest other = (DescribeScalingActivitiesRequest)((Object)obj);
        return this.hasActivityIds() == other.hasActivityIds() && Objects.equals(this.activityIds(), other.activityIds()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.includeDeletedGroups(), other.includeDeletedGroups()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalingActivitiesRequest").add("ActivityIds", this.hasActivityIds() ? this.activityIds() : null).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("IncludeDeletedGroups", (Object)this.includeDeletedGroups()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityIds": {
                return Optional.ofNullable(clazz.cast(this.activityIds()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "IncludeDeletedGroups": {
                return Optional.ofNullable(clazz.cast(this.includeDeletedGroups()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingActivitiesRequest, T> g) {
        return obj -> g.apply((DescribeScalingActivitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private List<String> activityIds = DefaultSdkAutoConstructList.getInstance();
        private String autoScalingGroupName;
        private Boolean includeDeletedGroups;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesRequest model) {
            super(model);
            this.activityIds(model.activityIds);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.includeDeletedGroups(model.includeDeletedGroups);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getActivityIds() {
            if (this.activityIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.activityIds;
        }

        @Override
        public final Builder activityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activityIds(String ... activityIds) {
            this.activityIds(Arrays.asList(activityIds));
            return this;
        }

        public final void setActivityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Boolean getIncludeDeletedGroups() {
            return this.includeDeletedGroups;
        }

        @Override
        public final Builder includeDeletedGroups(Boolean includeDeletedGroups) {
            this.includeDeletedGroups = includeDeletedGroups;
            return this;
        }

        public final void setIncludeDeletedGroups(Boolean includeDeletedGroups) {
            this.includeDeletedGroups = includeDeletedGroups;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingActivitiesRequest build() {
            return new DescribeScalingActivitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
        public Builder activityIds(Collection<String> var1);

        public Builder activityIds(String ... var1);

        public Builder autoScalingGroupName(String var1);

        public Builder includeDeletedGroups(Boolean var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

