/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteScheduledActionResponse extends AutoScalingResponse implements
        ToCopyableBuilder<BatchDeleteScheduledActionResponse.Builder, BatchDeleteScheduledActionResponse> {
    private static final SdkField<List<FailedScheduledUpdateGroupActionRequest>> FAILED_SCHEDULED_ACTIONS_FIELD = SdkField
            .<List<FailedScheduledUpdateGroupActionRequest>> builder(MarshallingType.LIST)
            .memberName("FailedScheduledActions")
            .getter(getter(BatchDeleteScheduledActionResponse::failedScheduledActions))
            .setter(setter(Builder::failedScheduledActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedScheduledActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedScheduledUpdateGroupActionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedScheduledUpdateGroupActionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_SCHEDULED_ACTIONS_FIELD));

    private final List<FailedScheduledUpdateGroupActionRequest> failedScheduledActions;

    private BatchDeleteScheduledActionResponse(BuilderImpl builder) {
        super(builder);
        this.failedScheduledActions = builder.failedScheduledActions;
    }

    /**
     * Returns true if the FailedScheduledActions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFailedScheduledActions() {
        return failedScheduledActions != null && !(failedScheduledActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the scheduled actions that could not be deleted, including an error message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedScheduledActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the scheduled actions that could not be deleted, including an error message.
     */
    public final List<FailedScheduledUpdateGroupActionRequest> failedScheduledActions() {
        return failedScheduledActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedScheduledActions() ? failedScheduledActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteScheduledActionResponse)) {
            return false;
        }
        BatchDeleteScheduledActionResponse other = (BatchDeleteScheduledActionResponse) obj;
        return hasFailedScheduledActions() == other.hasFailedScheduledActions()
                && Objects.equals(failedScheduledActions(), other.failedScheduledActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteScheduledActionResponse")
                .add("FailedScheduledActions", hasFailedScheduledActions() ? failedScheduledActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedScheduledActions":
            return Optional.ofNullable(clazz.cast(failedScheduledActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteScheduledActionResponse, T> g) {
        return obj -> g.apply((BatchDeleteScheduledActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteScheduledActionResponse> {
        /**
         * <p>
         * The names of the scheduled actions that could not be deleted, including an error message.
         * </p>
         * 
         * @param failedScheduledActions
         *        The names of the scheduled actions that could not be deleted, including an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedScheduledActions(Collection<FailedScheduledUpdateGroupActionRequest> failedScheduledActions);

        /**
         * <p>
         * The names of the scheduled actions that could not be deleted, including an error message.
         * </p>
         * 
         * @param failedScheduledActions
         *        The names of the scheduled actions that could not be deleted, including an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedScheduledActions(FailedScheduledUpdateGroupActionRequest... failedScheduledActions);

        /**
         * <p>
         * The names of the scheduled actions that could not be deleted, including an error message.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <FailedScheduledUpdateGroupActionRequest>.Builder} avoiding the need to create one manually via {@link List
         * <FailedScheduledUpdateGroupActionRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedScheduledUpdateGroupActionRequest>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #failedScheduledActions(List<FailedScheduledUpdateGroupActionRequest>)}.
         * 
         * @param failedScheduledActions
         *        a consumer that will call methods on {@link List<FailedScheduledUpdateGroupActionRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedScheduledActions(List<FailedScheduledUpdateGroupActionRequest>)
         */
        Builder failedScheduledActions(Consumer<FailedScheduledUpdateGroupActionRequest.Builder>... failedScheduledActions);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<FailedScheduledUpdateGroupActionRequest> failedScheduledActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteScheduledActionResponse model) {
            super(model);
            failedScheduledActions(model.failedScheduledActions);
        }

        public final List<FailedScheduledUpdateGroupActionRequest.Builder> getFailedScheduledActions() {
            List<FailedScheduledUpdateGroupActionRequest.Builder> result = FailedScheduledUpdateGroupActionRequestsCopier
                    .copyToBuilder(this.failedScheduledActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failedScheduledActions(Collection<FailedScheduledUpdateGroupActionRequest> failedScheduledActions) {
            this.failedScheduledActions = FailedScheduledUpdateGroupActionRequestsCopier.copy(failedScheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedScheduledActions(FailedScheduledUpdateGroupActionRequest... failedScheduledActions) {
            failedScheduledActions(Arrays.asList(failedScheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedScheduledActions(
                Consumer<FailedScheduledUpdateGroupActionRequest.Builder>... failedScheduledActions) {
            failedScheduledActions(Stream.of(failedScheduledActions)
                    .map(c -> FailedScheduledUpdateGroupActionRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedScheduledActions(
                Collection<FailedScheduledUpdateGroupActionRequest.BuilderImpl> failedScheduledActions) {
            this.failedScheduledActions = FailedScheduledUpdateGroupActionRequestsCopier.copyFromBuilder(failedScheduledActions);
        }

        @Override
        public BatchDeleteScheduledActionResponse build() {
            return new BatchDeleteScheduledActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
