/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information used to set up an Amazon EBS volume specified in a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ebs implements SdkPojo, Serializable, ToCopyableBuilder<Ebs.Builder, Ebs> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(Ebs::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize").getter(getter(Ebs::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(Ebs::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination").getter(getter(Ebs::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(Ebs::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(Ebs::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput").getter(getter(Ebs::throughput)).setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            VOLUME_SIZE_FIELD, VOLUME_TYPE_FIELD, DELETE_ON_TERMINATION_FIELD, IOPS_FIELD, ENCRYPTED_FIELD, THROUGHPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final Integer volumeSize;

    private final String volumeType;

    private final Boolean deleteOnTermination;

    private final Integer iops;

    private final Boolean encrypted;

    private final Integer throughput;

    private Ebs(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.iops = builder.iops;
        this.encrypted = builder.encrypted;
        this.throughput = builder.throughput;
    }

    /**
     * <p>
     * The snapshot ID of the volume to use.
     * </p>
     * <p>
     * You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.
     * </p>
     * 
     * @return The snapshot ID of the volume to use.</p>
     *         <p>
     *         You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The volume size, in GiBs. The following are the supported volumes sizes for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp2</code> and <code>gp3</code>: 1-16,384
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>: 4-16,384
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>st1</code> and <code>sc1</code>: 125-16,384
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>standard</code>: 1-1,024
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you specify both
     * <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size of
     * the snapshot.
     * </p>
     * 
     * @return The volume size, in GiBs. The following are the supported volumes sizes for each volume type: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp2</code> and <code>gp3</code>: 1-16,384
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>: 4-16,384
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>st1</code> and <code>sc1</code>: 125-16,384
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>standard</code>: 1-1,024
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you specify both
     *         <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the
     *         size of the snapshot.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The volume type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the
     * <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> | <code>st1</code> | <code>sc1</code> |
     * <code>gp3</code>
     * </p>
     * 
     * @return The volume type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume
     *         Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     *         <p>
     *         Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> | <code>st1</code> |
     *         <code>sc1</code> | <code>gp3</code>
     */
    public final String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the default value
     * is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the default
     *         value is <code>true</code>.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The number of input/output (I/O) operations per second (IOPS) to provision for the volume. For <code>gp3</code>
     * and <code>io1</code> volumes, this represents the number of IOPS that are provisioned for the volume. For
     * <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume
     * accumulates I/O credits for bursting.
     * </p>
     * <p>
     * The following are the supported values for each volume type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>gp3</code>: 3,000-16,000 IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code>: 100-64,000 IOPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances
     * built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS.
     * </p>
     * <p>
     * <code>Iops</code> is supported when the volume type is <code>gp3</code> or <code>io1</code> and required only
     * when the volume type is <code>io1</code>. (Not used with <code>standard</code>, <code>gp2</code>,
     * <code>st1</code>, or <code>sc1</code> volumes.)
     * </p>
     * 
     * @return The number of input/output (I/O) operations per second (IOPS) to provision for the volume. For
     *         <code>gp3</code> and <code>io1</code> volumes, this represents the number of IOPS that are provisioned
     *         for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and
     *         the rate at which the volume accumulates I/O credits for bursting. </p>
     *         <p>
     *         The following are the supported values for each volume type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>gp3</code>: 3,000-16,000 IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code>: 100-64,000 IOPS
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances"
     *         >Instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000
     *         IOPS.
     *         </p>
     *         <p>
     *         <code>Iops</code> is supported when the volume type is <code>gp3</code> or <code>io1</code> and required
     *         only when the volume type is <code>io1</code>. (Not used with <code>standard</code>, <code>gp2</code>,
     *         <code>st1</code>, or <code>sc1</code> volumes.)
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be attached to instances that
     * support Amazon EBS encryption. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances"
     * >Supported Instance Types</a>. If your AMI uses encrypted volumes, you can also only launch it on supported
     * instance types.
     * </p>
     * <note>
     * <p>
     * If you are creating a volume from a snapshot, you cannot specify an encryption value. Volumes that are created
     * from encrypted snapshots are automatically encrypted, and volumes that are created from unencrypted snapshots are
     * automatically unencrypted. By default, encrypted snapshots use the Amazon Web Services managed CMK that is used
     * for EBS encryption, but you can specify a custom CMK when you create the snapshot. The ability to encrypt a
     * snapshot during copying also allows you to apply a new CMK to an already-encrypted snapshot. Volumes restored
     * from the resulting copy are only accessible using the new CMK.
     * </p>
     * <p>
     * Enabling <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">encryption by
     * default</a> results in all EBS volumes being encrypted with the Amazon Web Services managed CMK or a customer
     * managed CMK, whether or not the snapshot was encrypted.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Using
     * Encryption with EBS-Backed AMIs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> and <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/key-policy-requirements-EBS-encryption.html">Required
     * CMK key policy for use with encrypted volumes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be attached to instances
     *         that support Amazon EBS encryption. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances"
     *         >Supported Instance Types</a>. If your AMI uses encrypted volumes, you can also only launch it on
     *         supported instance types.</p> <note>
     *         <p>
     *         If you are creating a volume from a snapshot, you cannot specify an encryption value. Volumes that are
     *         created from encrypted snapshots are automatically encrypted, and volumes that are created from
     *         unencrypted snapshots are automatically unencrypted. By default, encrypted snapshots use the Amazon Web
     *         Services managed CMK that is used for EBS encryption, but you can specify a custom CMK when you create
     *         the snapshot. The ability to encrypt a snapshot during copying also allows you to apply a new CMK to an
     *         already-encrypted snapshot. Volumes restored from the resulting copy are only accessible using the new
     *         CMK.
     *         </p>
     *         <p>
     *         Enabling <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default"
     *         >encryption by default</a> results in all EBS volumes being encrypted with the Amazon Web Services
     *         managed CMK or a customer managed CMK, whether or not the snapshot was encrypted.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Using Encryption with
     *         EBS-Backed AMIs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> and <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/key-policy-requirements-EBS-encryption.html"
     *         >Required CMK key policy for use with encrypted volumes</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The throughput (MiBps) to provision for a <code>gp3</code> volume.
     * </p>
     * 
     * @return The throughput (MiBps) to provision for a <code>gp3</code> volume.
     */
    public final Integer throughput() {
        return throughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ebs)) {
            return false;
        }
        Ebs other = (Ebs) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeType(), other.volumeType())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(iops(), other.iops())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(throughput(), other.throughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ebs").add("SnapshotId", snapshotId()).add("VolumeSize", volumeSize())
                .add("VolumeType", volumeType()).add("DeleteOnTermination", deleteOnTermination()).add("Iops", iops())
                .add("Encrypted", encrypted()).add("Throughput", throughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ebs, T> g) {
        return obj -> g.apply((Ebs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ebs> {
        /**
         * <p>
         * The snapshot ID of the volume to use.
         * </p>
         * <p>
         * You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID of the volume to use.</p>
         *        <p>
         *        You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The volume size, in GiBs. The following are the supported volumes sizes for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp2</code> and <code>gp3</code>: 1-16,384
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>: 4-16,384
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>st1</code> and <code>sc1</code>: 125-16,384
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>standard</code>: 1-1,024
         * </p>
         * </li>
         * </ul>
         * <p>
         * You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you specify both
         * <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the size
         * of the snapshot.
         * </p>
         * 
         * @param volumeSize
         *        The volume size, in GiBs. The following are the supported volumes sizes for each volume type: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp2</code> and <code>gp3</code>: 1-16,384
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>: 4-16,384
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>st1</code> and <code>sc1</code>: 125-16,384
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>standard</code>: 1-1,024
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you specify both
         *        <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must be equal or greater than the
         *        size of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The volume type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in
         * the <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * <p>
         * Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> | <code>st1</code> |
         * <code>sc1</code> | <code>gp3</code>
         * </p>
         * 
         * @param volumeType
         *        The volume type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume
         *        Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
         *        <p>
         *        Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> | <code>st1</code> |
         *        <code>sc1</code> | <code>gp3</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the default
         * value is <code>true</code>.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the
         *        default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The number of input/output (I/O) operations per second (IOPS) to provision for the volume. For
         * <code>gp3</code> and <code>io1</code> volumes, this represents the number of IOPS that are provisioned for
         * the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate
         * at which the volume accumulates I/O credits for bursting.
         * </p>
         * <p>
         * The following are the supported values for each volume type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>gp3</code>: 3,000-16,000 IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code>: 100-64,000 IOPS
         * </p>
         * </li>
         * </ul>
         * <p>
         * For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances
         * built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS.
         * </p>
         * <p>
         * <code>Iops</code> is supported when the volume type is <code>gp3</code> or <code>io1</code> and required only
         * when the volume type is <code>io1</code>. (Not used with <code>standard</code>, <code>gp2</code>,
         * <code>st1</code>, or <code>sc1</code> volumes.)
         * </p>
         * 
         * @param iops
         *        The number of input/output (I/O) operations per second (IOPS) to provision for the volume. For
         *        <code>gp3</code> and <code>io1</code> volumes, this represents the number of IOPS that are provisioned
         *        for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume
         *        and the rate at which the volume accumulates I/O credits for bursting. </p>
         *        <p>
         *        The following are the supported values for each volume type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>gp3</code>: 3,000-16,000 IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code>: 100-64,000 IOPS
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances"
         *        >Instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000
         *        IOPS.
         *        </p>
         *        <p>
         *        <code>Iops</code> is supported when the volume type is <code>gp3</code> or <code>io1</code> and
         *        required only when the volume type is <code>io1</code>. (Not used with <code>standard</code>,
         *        <code>gp2</code>, <code>st1</code>, or <code>sc1</code> volumes.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be attached to instances
         * that support Amazon EBS encryption. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances"
         * >Supported Instance Types</a>. If your AMI uses encrypted volumes, you can also only launch it on supported
         * instance types.
         * </p>
         * <note>
         * <p>
         * If you are creating a volume from a snapshot, you cannot specify an encryption value. Volumes that are
         * created from encrypted snapshots are automatically encrypted, and volumes that are created from unencrypted
         * snapshots are automatically unencrypted. By default, encrypted snapshots use the Amazon Web Services managed
         * CMK that is used for EBS encryption, but you can specify a custom CMK when you create the snapshot. The
         * ability to encrypt a snapshot during copying also allows you to apply a new CMK to an already-encrypted
         * snapshot. Volumes restored from the resulting copy are only accessible using the new CMK.
         * </p>
         * <p>
         * Enabling <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default"
         * >encryption by default</a> results in all EBS volumes being encrypted with the Amazon Web Services managed
         * CMK or a customer managed CMK, whether or not the snapshot was encrypted.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Using Encryption with
         * EBS-Backed AMIs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> and <a
         * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/key-policy-requirements-EBS-encryption.html"
         * >Required CMK key policy for use with encrypted volumes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be attached to
         *        instances that support Amazon EBS encryption. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances"
         *        >Supported Instance Types</a>. If your AMI uses encrypted volumes, you can also only launch it on
         *        supported instance types.</p> <note>
         *        <p>
         *        If you are creating a volume from a snapshot, you cannot specify an encryption value. Volumes that are
         *        created from encrypted snapshots are automatically encrypted, and volumes that are created from
         *        unencrypted snapshots are automatically unencrypted. By default, encrypted snapshots use the Amazon
         *        Web Services managed CMK that is used for EBS encryption, but you can specify a custom CMK when you
         *        create the snapshot. The ability to encrypt a snapshot during copying also allows you to apply a new
         *        CMK to an already-encrypted snapshot. Volumes restored from the resulting copy are only accessible
         *        using the new CMK.
         *        </p>
         *        <p>
         *        Enabling <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default"
         *        >encryption by default</a> results in all EBS volumes being encrypted with the Amazon Web Services
         *        managed CMK or a customer managed CMK, whether or not the snapshot was encrypted.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html">Using Encryption with
         *        EBS-Backed AMIs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> and <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/key-policy-requirements-EBS-encryption.html"
         *        >Required CMK key policy for use with encrypted volumes</a> in the <i>Amazon EC2 Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The throughput (MiBps) to provision for a <code>gp3</code> volume.
         * </p>
         * 
         * @param throughput
         *        The throughput (MiBps) to provision for a <code>gp3</code> volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private Integer volumeSize;

        private String volumeType;

        private Boolean deleteOnTermination;

        private Integer iops;

        private Boolean encrypted;

        private Integer throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(Ebs model) {
            snapshotId(model.snapshotId);
            volumeSize(model.volumeSize);
            volumeType(model.volumeType);
            deleteOnTermination(model.deleteOnTermination);
            iops(model.iops);
            encrypted(model.encrypted);
            throughput(model.throughput);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public Ebs build() {
            return new Ebs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
