/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMappingsCopier;
import software.amazon.awssdk.services.autoscaling.model.ClassicLinkVPCSecurityGroupsCopier;
import software.amazon.awssdk.services.autoscaling.model.InstanceMetadataOptions;
import software.amazon.awssdk.services.autoscaling.model.InstanceMonitoring;
import software.amazon.awssdk.services.autoscaling.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchConfiguration> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchConfigurationName").getter(LaunchConfiguration.getter(LaunchConfiguration::launchConfigurationName)).setter(LaunchConfiguration.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchConfigurationARN").getter(LaunchConfiguration.getter(LaunchConfiguration::launchConfigurationARN)).setter(LaunchConfiguration.setter(Builder::launchConfigurationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationARN").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(LaunchConfiguration.getter(LaunchConfiguration::imageId)).setter(LaunchConfiguration.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(LaunchConfiguration.getter(LaunchConfiguration::keyName)).setter(LaunchConfiguration.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(LaunchConfiguration.getter(LaunchConfiguration::securityGroups)).setter(LaunchConfiguration.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLASSIC_LINK_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClassicLinkVPCId").getter(LaunchConfiguration.getter(LaunchConfiguration::classicLinkVPCId)).setter(LaunchConfiguration.setter(Builder::classicLinkVPCId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVPCId").build()}).build();
    private static final SdkField<List<String>> CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClassicLinkVPCSecurityGroups").getter(LaunchConfiguration.getter(LaunchConfiguration::classicLinkVPCSecurityGroups)).setter(LaunchConfiguration.setter(Builder::classicLinkVPCSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassicLinkVPCSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(LaunchConfiguration.getter(LaunchConfiguration::userData)).setter(LaunchConfiguration.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(LaunchConfiguration.getter(LaunchConfiguration::instanceType)).setter(LaunchConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(LaunchConfiguration.getter(LaunchConfiguration::kernelId)).setter(LaunchConfiguration.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()}).build();
    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamdiskId").getter(LaunchConfiguration.getter(LaunchConfiguration::ramdiskId)).setter(LaunchConfiguration.setter(Builder::ramdiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId").build()}).build();
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(LaunchConfiguration.getter(LaunchConfiguration::blockDeviceMappings)).setter(LaunchConfiguration.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceMonitoring> INSTANCE_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMonitoring").getter(LaunchConfiguration.getter(LaunchConfiguration::instanceMonitoring)).setter(LaunchConfiguration.setter(Builder::instanceMonitoring)).constructor(InstanceMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMonitoring").build()}).build();
    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotPrice").getter(LaunchConfiguration.getter(LaunchConfiguration::spotPrice)).setter(LaunchConfiguration.setter(Builder::spotPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").build()}).build();
    private static final SdkField<String> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamInstanceProfile").getter(LaunchConfiguration.getter(LaunchConfiguration::iamInstanceProfile)).setter(LaunchConfiguration.setter(Builder::iamInstanceProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(LaunchConfiguration.getter(LaunchConfiguration::createdTime)).setter(LaunchConfiguration.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(LaunchConfiguration.getter(LaunchConfiguration::ebsOptimized)).setter(LaunchConfiguration.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress").getter(LaunchConfiguration.getter(LaunchConfiguration::associatePublicIpAddress)).setter(LaunchConfiguration.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build()}).build();
    private static final SdkField<String> PLACEMENT_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementTenancy").getter(LaunchConfiguration.getter(LaunchConfiguration::placementTenancy)).setter(LaunchConfiguration.setter(Builder::placementTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementTenancy").build()}).build();
    private static final SdkField<InstanceMetadataOptions> METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataOptions").getter(LaunchConfiguration.getter(LaunchConfiguration::metadataOptions)).setter(LaunchConfiguration.setter(Builder::metadataOptions)).constructor(InstanceMetadataOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_CONFIGURATION_ARN_FIELD, IMAGE_ID_FIELD, KEY_NAME_FIELD, SECURITY_GROUPS_FIELD, CLASSIC_LINK_VPC_ID_FIELD, CLASSIC_LINK_VPC_SECURITY_GROUPS_FIELD, USER_DATA_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, RAMDISK_ID_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, INSTANCE_MONITORING_FIELD, SPOT_PRICE_FIELD, IAM_INSTANCE_PROFILE_FIELD, CREATED_TIME_FIELD, EBS_OPTIMIZED_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, PLACEMENT_TENANCY_FIELD, METADATA_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String launchConfigurationName;
    private final String launchConfigurationARN;
    private final String imageId;
    private final String keyName;
    private final List<String> securityGroups;
    private final String classicLinkVPCId;
    private final List<String> classicLinkVPCSecurityGroups;
    private final String userData;
    private final String instanceType;
    private final String kernelId;
    private final String ramdiskId;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final InstanceMonitoring instanceMonitoring;
    private final String spotPrice;
    private final String iamInstanceProfile;
    private final Instant createdTime;
    private final Boolean ebsOptimized;
    private final Boolean associatePublicIpAddress;
    private final String placementTenancy;
    private final InstanceMetadataOptions metadataOptions;

    private LaunchConfiguration(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchConfigurationARN = builder.launchConfigurationARN;
        this.imageId = builder.imageId;
        this.keyName = builder.keyName;
        this.securityGroups = builder.securityGroups;
        this.classicLinkVPCId = builder.classicLinkVPCId;
        this.classicLinkVPCSecurityGroups = builder.classicLinkVPCSecurityGroups;
        this.userData = builder.userData;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.instanceMonitoring = builder.instanceMonitoring;
        this.spotPrice = builder.spotPrice;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.createdTime = builder.createdTime;
        this.ebsOptimized = builder.ebsOptimized;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.placementTenancy = builder.placementTenancy;
        this.metadataOptions = builder.metadataOptions;
    }

    public final String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public final String launchConfigurationARN() {
        return this.launchConfigurationARN;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final String classicLinkVPCId() {
        return this.classicLinkVPCId;
    }

    public final boolean hasClassicLinkVPCSecurityGroups() {
        return this.classicLinkVPCSecurityGroups != null && !(this.classicLinkVPCSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> classicLinkVPCSecurityGroups() {
        return this.classicLinkVPCSecurityGroups;
    }

    public final String userData() {
        return this.userData;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final String ramdiskId() {
        return this.ramdiskId;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final InstanceMonitoring instanceMonitoring() {
        return this.instanceMonitoring;
    }

    public final String spotPrice() {
        return this.spotPrice;
    }

    public final String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final String placementTenancy() {
        return this.placementTenancy;
    }

    public final InstanceMetadataOptions metadataOptions() {
        return this.metadataOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.classicLinkVPCId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClassicLinkVPCSecurityGroups() ? this.classicLinkVPCSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementTenancy());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfiguration)) {
            return false;
        }
        LaunchConfiguration other = (LaunchConfiguration)obj;
        return Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.launchConfigurationARN(), other.launchConfigurationARN()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.keyName(), other.keyName()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.classicLinkVPCId(), other.classicLinkVPCId()) && this.hasClassicLinkVPCSecurityGroups() == other.hasClassicLinkVPCSecurityGroups() && Objects.equals(this.classicLinkVPCSecurityGroups(), other.classicLinkVPCSecurityGroups()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.instanceMonitoring(), other.instanceMonitoring()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.placementTenancy(), other.placementTenancy()) && Objects.equals(this.metadataOptions(), other.metadataOptions());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchConfiguration").add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("LaunchConfigurationARN", (Object)this.launchConfigurationARN()).add("ImageId", (Object)this.imageId()).add("KeyName", (Object)this.keyName()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("ClassicLinkVPCId", (Object)this.classicLinkVPCId()).add("ClassicLinkVPCSecurityGroups", this.hasClassicLinkVPCSecurityGroups() ? this.classicLinkVPCSecurityGroups() : null).add("UserData", (Object)this.userData()).add("InstanceType", (Object)this.instanceType()).add("KernelId", (Object)this.kernelId()).add("RamdiskId", (Object)this.ramdiskId()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("InstanceMonitoring", (Object)this.instanceMonitoring()).add("SpotPrice", (Object)this.spotPrice()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("CreatedTime", (Object)this.createdTime()).add("EbsOptimized", (Object)this.ebsOptimized()).add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("PlacementTenancy", (Object)this.placementTenancy()).add("MetadataOptions", (Object)this.metadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "LaunchConfigurationARN": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationARN()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "ClassicLinkVPCId": {
                return Optional.ofNullable(clazz.cast(this.classicLinkVPCId()));
            }
            case "ClassicLinkVPCSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.classicLinkVPCSecurityGroups()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "RamdiskId": {
                return Optional.ofNullable(clazz.cast(this.ramdiskId()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "InstanceMonitoring": {
                return Optional.ofNullable(clazz.cast(this.instanceMonitoring()));
            }
            case "SpotPrice": {
                return Optional.ofNullable(clazz.cast(this.spotPrice()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "PlacementTenancy": {
                return Optional.ofNullable(clazz.cast(this.placementTenancy()));
            }
            case "MetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.metadataOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchConfiguration, T> g) {
        return obj -> g.apply((LaunchConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchConfigurationName;
        private String launchConfigurationARN;
        private String imageId;
        private String keyName;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String classicLinkVPCId;
        private List<String> classicLinkVPCSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String userData;
        private String instanceType;
        private String kernelId;
        private String ramdiskId;
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private InstanceMonitoring instanceMonitoring;
        private String spotPrice;
        private String iamInstanceProfile;
        private Instant createdTime;
        private Boolean ebsOptimized;
        private Boolean associatePublicIpAddress;
        private String placementTenancy;
        private InstanceMetadataOptions metadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfiguration model) {
            this.launchConfigurationName(model.launchConfigurationName);
            this.launchConfigurationARN(model.launchConfigurationARN);
            this.imageId(model.imageId);
            this.keyName(model.keyName);
            this.securityGroups(model.securityGroups);
            this.classicLinkVPCId(model.classicLinkVPCId);
            this.classicLinkVPCSecurityGroups(model.classicLinkVPCSecurityGroups);
            this.userData(model.userData);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.ramdiskId(model.ramdiskId);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.instanceMonitoring(model.instanceMonitoring);
            this.spotPrice(model.spotPrice);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.createdTime(model.createdTime);
            this.ebsOptimized(model.ebsOptimized);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.placementTenancy(model.placementTenancy);
            this.metadataOptions(model.metadataOptions);
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final String getLaunchConfigurationARN() {
            return this.launchConfigurationARN;
        }

        @Override
        public final Builder launchConfigurationARN(String launchConfigurationARN) {
            this.launchConfigurationARN = launchConfigurationARN;
            return this;
        }

        public final void setLaunchConfigurationARN(String launchConfigurationARN) {
            this.launchConfigurationARN = launchConfigurationARN;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getClassicLinkVPCId() {
            return this.classicLinkVPCId;
        }

        @Override
        public final Builder classicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
            return this;
        }

        public final void setClassicLinkVPCId(String classicLinkVPCId) {
            this.classicLinkVPCId = classicLinkVPCId;
        }

        public final Collection<String> getClassicLinkVPCSecurityGroups() {
            if (this.classicLinkVPCSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.classicLinkVPCSecurityGroups;
        }

        @Override
        public final Builder classicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLinkVPCSecurityGroups(String ... classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups(Arrays.asList(classicLinkVPCSecurityGroups));
            return this;
        }

        public final void setClassicLinkVPCSecurityGroups(Collection<String> classicLinkVPCSecurityGroups) {
            this.classicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroupsCopier.copy(classicLinkVPCSecurityGroups);
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingsCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (BlockDeviceMapping)((BlockDeviceMapping.Builder)BlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final InstanceMonitoring.Builder getInstanceMonitoring() {
            return this.instanceMonitoring != null ? this.instanceMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder instanceMonitoring(InstanceMonitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public final void setInstanceMonitoring(InstanceMonitoring.BuilderImpl instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring != null ? instanceMonitoring.build() : null;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final String getPlacementTenancy() {
            return this.placementTenancy;
        }

        @Override
        public final Builder placementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        public final void setPlacementTenancy(String placementTenancy) {
            this.placementTenancy = placementTenancy;
        }

        public final InstanceMetadataOptions.Builder getMetadataOptions() {
            return this.metadataOptions != null ? this.metadataOptions.toBuilder() : null;
        }

        @Override
        public final Builder metadataOptions(InstanceMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final void setMetadataOptions(InstanceMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        public LaunchConfiguration build() {
            return new LaunchConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchConfiguration> {
        public Builder launchConfigurationName(String var1);

        public Builder launchConfigurationARN(String var1);

        public Builder imageId(String var1);

        public Builder keyName(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder classicLinkVPCId(String var1);

        public Builder classicLinkVPCSecurityGroups(Collection<String> var1);

        public Builder classicLinkVPCSecurityGroups(String ... var1);

        public Builder userData(String var1);

        public Builder instanceType(String var1);

        public Builder kernelId(String var1);

        public Builder ramdiskId(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder> ... var1);

        public Builder instanceMonitoring(InstanceMonitoring var1);

        default public Builder instanceMonitoring(Consumer<InstanceMonitoring.Builder> instanceMonitoring) {
            return this.instanceMonitoring((InstanceMonitoring)((InstanceMonitoring.Builder)InstanceMonitoring.builder().applyMutation(instanceMonitoring)).build());
        }

        public Builder spotPrice(String var1);

        public Builder iamInstanceProfile(String var1);

        public Builder createdTime(Instant var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder associatePublicIpAddress(Boolean var1);

        public Builder placementTenancy(String var1);

        public Builder metadataOptions(InstanceMetadataOptions var1);

        default public Builder metadataOptions(Consumer<InstanceMetadataOptions.Builder> metadataOptions) {
            return this.metadataOptions((InstanceMetadataOptions)((InstanceMetadataOptions.Builder)InstanceMetadataOptions.builder().applyMutation(metadataOptions)).build());
        }
    }
}

