/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAutoScalingNotificationTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeAutoScalingNotificationTypesResponse.Builder, DescribeAutoScalingNotificationTypesResponse> {
    private static final SdkField<List<String>> AUTO_SCALING_NOTIFICATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AutoScalingNotificationTypes")
            .getter(getter(DescribeAutoScalingNotificationTypesResponse::autoScalingNotificationTypes))
            .setter(setter(Builder::autoScalingNotificationTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingNotificationTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTO_SCALING_NOTIFICATION_TYPES_FIELD));

    private final List<String> autoScalingNotificationTypes;

    private DescribeAutoScalingNotificationTypesResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingNotificationTypes = builder.autoScalingNotificationTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoScalingNotificationTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoScalingNotificationTypes() {
        return autoScalingNotificationTypes != null && !(autoScalingNotificationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The notification types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoScalingNotificationTypes} method.
     * </p>
     * 
     * @return The notification types.
     */
    public final List<String> autoScalingNotificationTypes() {
        return autoScalingNotificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoScalingNotificationTypes() ? autoScalingNotificationTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingNotificationTypesResponse)) {
            return false;
        }
        DescribeAutoScalingNotificationTypesResponse other = (DescribeAutoScalingNotificationTypesResponse) obj;
        return hasAutoScalingNotificationTypes() == other.hasAutoScalingNotificationTypes()
                && Objects.equals(autoScalingNotificationTypes(), other.autoScalingNotificationTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAutoScalingNotificationTypesResponse")
                .add("AutoScalingNotificationTypes", hasAutoScalingNotificationTypes() ? autoScalingNotificationTypes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingNotificationTypes":
            return Optional.ofNullable(clazz.cast(autoScalingNotificationTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoScalingNotificationTypesResponse, T> g) {
        return obj -> g.apply((DescribeAutoScalingNotificationTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAutoScalingNotificationTypesResponse> {
        /**
         * <p>
         * The notification types.
         * </p>
         * 
         * @param autoScalingNotificationTypes
         *        The notification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes);

        /**
         * <p>
         * The notification types.
         * </p>
         * 
         * @param autoScalingNotificationTypes
         *        The notification types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingNotificationTypes(String... autoScalingNotificationTypes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<String> autoScalingNotificationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingNotificationTypesResponse model) {
            super(model);
            autoScalingNotificationTypes(model.autoScalingNotificationTypes);
        }

        public final Collection<String> getAutoScalingNotificationTypes() {
            if (autoScalingNotificationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return autoScalingNotificationTypes;
        }

        public final void setAutoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
        }

        @Override
        @Transient
        public final Builder autoScalingNotificationTypes(Collection<String> autoScalingNotificationTypes) {
            this.autoScalingNotificationTypes = AutoScalingNotificationTypesCopier.copy(autoScalingNotificationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoScalingNotificationTypes(String... autoScalingNotificationTypes) {
            autoScalingNotificationTypes(Arrays.asList(autoScalingNotificationTypes));
            return this;
        }

        @Override
        public DescribeAutoScalingNotificationTypesResponse build() {
            return new DescribeAutoScalingNotificationTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
