/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an override for a launch template. For more information, see <a
 * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-configuring-overrides.html">Configuring
 * overrides</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateOverrides.Builder, LaunchTemplateOverrides> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(LaunchTemplateOverrides::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> WEIGHTED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WeightedCapacity").getter(getter(LaunchTemplateOverrides::weightedCapacity))
            .setter(setter(Builder::weightedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").build()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplateSpecification")
            .getter(getter(LaunchTemplateOverrides::launchTemplateSpecification))
            .setter(setter(Builder::launchTemplateSpecification))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification")
                    .build()).build();

    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirements> builder(MarshallingType.SDK_POJO).memberName("InstanceRequirements")
            .getter(getter(LaunchTemplateOverrides::instanceRequirements)).setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            WEIGHTED_CAPACITY_FIELD, LAUNCH_TEMPLATE_SPECIFICATION_FIELD, INSTANCE_REQUIREMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String weightedCapacity;

    private final LaunchTemplateSpecification launchTemplateSpecification;

    private final InstanceRequirements instanceRequirements;

    private LaunchTemplateOverrides(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.instanceRequirements = builder.instanceRequirements;
    }

    /**
     * <p>
     * The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in your
     * requested Region and Availability Zones. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in
     *         your requested Region and Availability Zones. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of capacity units provided by the instance type specified in <code>InstanceType</code> in terms of
     * virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or On-Demand
     * Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches
     * instances until the desired capacity is totally fulfilled, even if this results in an overage. For example, if
     * there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a
     * <code>WeightedCapacity</code> of five units, the instance is launched, and the desired capacity is exceeded by
     * three units. For more information, see <a
     * href="https://docs.aws.amazon.com/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html">Instance
     * weighting for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in the
     * range of 1–999.
     * </p>
     * 
     * @return The number of capacity units provided by the instance type specified in <code>InstanceType</code> in
     *         terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a
     *         Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2
     *         Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this results in
     *         an overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto
     *         Scaling can only launch an instance with a <code>WeightedCapacity</code> of five units, the instance is
     *         launched, and the desired capacity is exceeded by three units. For more information, see <a
     *         href="https://docs.aws.amazon.com/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html"
     *         >Instance weighting for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     *         Value must be in the range of 1–999.
     */
    public final String weightedCapacity() {
        return weightedCapacity;
    }

    /**
     * <p>
     * Provides the launch template to be used when launching the instance type specified in <code>InstanceType</code>.
     * For example, some instance types might require a launch template with a different AMI. If not provided, Amazon
     * EC2 Auto Scaling uses the launch template that's defined for your mixed instances policy. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html"
     * >Specifying a different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User
     * Guide</i>.
     * </p>
     * 
     * @return Provides the launch template to be used when launching the instance type specified in
     *         <code>InstanceType</code>. For example, some instance types might require a launch template with a
     *         different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's defined for your
     *         mixed instances policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html"
     *         >Specifying a different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User
     *         Guide</i>.
     */
    public final LaunchTemplateSpecification launchTemplateSpecification() {
        return launchTemplateSpecification;
    }

    /**
     * <p>
     * The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds instance types
     * that satisfy your requirements, and then uses your On-Demand and Spot allocation strategies to launch instances
     * from these instance types, in the same way as when you specify a list of specific instance types.
     * </p>
     * 
     * @return The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds instance
     *         types that satisfy your requirements, and then uses your On-Demand and Spot allocation strategies to
     *         launch instances from these instance types, in the same way as when you specify a list of specific
     *         instance types.
     */
    public final InstanceRequirements instanceRequirements() {
        return instanceRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateOverrides)) {
            return false;
        }
        LaunchTemplateOverrides other = (LaunchTemplateOverrides) obj;
        return Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(weightedCapacity(), other.weightedCapacity())
                && Objects.equals(launchTemplateSpecification(), other.launchTemplateSpecification())
                && Objects.equals(instanceRequirements(), other.instanceRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateOverrides").add("InstanceType", instanceType())
                .add("WeightedCapacity", weightedCapacity()).add("LaunchTemplateSpecification", launchTemplateSpecification())
                .add("InstanceRequirements", instanceRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "WeightedCapacity":
            return Optional.ofNullable(clazz.cast(weightedCapacity()));
        case "LaunchTemplateSpecification":
            return Optional.ofNullable(clazz.cast(launchTemplateSpecification()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateOverrides, T> g) {
        return obj -> g.apply((LaunchTemplateOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateOverrides> {
        /**
         * <p>
         * The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in your
         * requested Region and Availability Zones. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type, such as <code>m3.xlarge</code>. You must use an instance type that is supported in
         *        your requested Region and Availability Zones. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of capacity units provided by the instance type specified in <code>InstanceType</code> in terms of
         * virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When a Spot or
         * On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling
         * launches instances until the desired capacity is totally fulfilled, even if this results in an overage. For
         * example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling can only launch an
         * instance with a <code>WeightedCapacity</code> of five units, the instance is launched, and the desired
         * capacity is exceeded by three units. For more information, see <a
         * href="https://docs.aws.amazon.com/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html">Instance
         * weighting for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in
         * the range of 1–999.
         * </p>
         * 
         * @param weightedCapacity
         *        The number of capacity units provided by the instance type specified in <code>InstanceType</code> in
         *        terms of virtual CPUs, memory, storage, throughput, or other relative performance characteristic. When
         *        a Spot or On-Demand Instance is launched, the capacity units count toward the desired capacity. Amazon
         *        EC2 Auto Scaling launches instances until the desired capacity is totally fulfilled, even if this
         *        results in an overage. For example, if there are two units remaining to fulfill capacity, and Amazon
         *        EC2 Auto Scaling can only launch an instance with a <code>WeightedCapacity</code> of five units, the
         *        instance is launched, and the desired capacity is exceeded by three units. For more information, see
         *        <a href="https://docs.aws.amazon.com/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html">
         *        Instance weighting for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         *        Value must be in the range of 1–999.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedCapacity(String weightedCapacity);

        /**
         * <p>
         * Provides the launch template to be used when launching the instance type specified in
         * <code>InstanceType</code>. For example, some instance types might require a launch template with a different
         * AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's defined for your mixed
         * instances policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html"
         * >Specifying a different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User
         * Guide</i>.
         * </p>
         * 
         * @param launchTemplateSpecification
         *        Provides the launch template to be used when launching the instance type specified in
         *        <code>InstanceType</code>. For example, some instance types might require a launch template with a
         *        different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's defined for
         *        your mixed instances policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html"
         *        >Specifying a different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateSpecification(LaunchTemplateSpecification launchTemplateSpecification);

        /**
         * <p>
         * Provides the launch template to be used when launching the instance type specified in
         * <code>InstanceType</code>. For example, some instance types might require a launch template with a different
         * AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's defined for your mixed
         * instances policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html"
         * >Specifying a different launch template for an instance type</a> in the <i>Amazon EC2 Auto Scaling User
         * Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateSpecification.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplateSpecification(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplateSpecification
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateSpecification(LaunchTemplateSpecification)
         */
        default Builder launchTemplateSpecification(Consumer<LaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return launchTemplateSpecification(LaunchTemplateSpecification.builder().applyMutation(launchTemplateSpecification)
                    .build());
        }

        /**
         * <p>
         * The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds instance
         * types that satisfy your requirements, and then uses your On-Demand and Spot allocation strategies to launch
         * instances from these instance types, in the same way as when you specify a list of specific instance types.
         * </p>
         * 
         * @param instanceRequirements
         *        The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds
         *        instance types that satisfy your requirements, and then uses your On-Demand and Spot allocation
         *        strategies to launch instances from these instance types, in the same way as when you specify a list
         *        of specific instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirements instanceRequirements);

        /**
         * <p>
         * The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds instance
         * types that satisfy your requirements, and then uses your On-Demand and Spot allocation strategies to launch
         * instances from these instance types, in the same way as when you specify a list of specific instance types.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceRequirements.Builder} avoiding the need
         * to create one manually via {@link InstanceRequirements#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceRequirements.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceRequirements(InstanceRequirements)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirements)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirements.builder().applyMutation(instanceRequirements).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String weightedCapacity;

        private LaunchTemplateSpecification launchTemplateSpecification;

        private InstanceRequirements instanceRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateOverrides model) {
            instanceType(model.instanceType);
            weightedCapacity(model.weightedCapacity);
            launchTemplateSpecification(model.launchTemplateSpecification);
            instanceRequirements(model.instanceRequirements);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getWeightedCapacity() {
            return weightedCapacity;
        }

        public final void setWeightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        @Transient
        public final Builder weightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return launchTemplateSpecification != null ? launchTemplateSpecification.toBuilder() : null;
        }

        public final void setLaunchTemplateSpecification(LaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder launchTemplateSpecification(LaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        @Override
        public LaunchTemplateOverrides build() {
            return new LaunchTemplateOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
